/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum SignatureSubpacket {
    signatureCreationTime(2),
    signatureExpirationTime(3),
    exportableCertification(4),
    trustSignature(5),
    regularExpression(6),
    revocable(7),
    keyExpirationTime(9),
    placeholder(10),
    preferredSymmetricAlgorithms(11),
    revocationKey(12),
    issuerKeyId(16),
    notationData(20),
    preferredHashAlgorithms(21),
    preferredCompressionAlgorithms(22),
    keyServerPreferences(23),
    preferredKeyServers(24),
    primaryUserId(25),
    policyUrl(26),
    keyFlags(27),
    signerUserId(28),
    revocationReason(29),
    features(30),
    signatureTarget(31),
    embeddedSignature(32),
    issuerFingerprint(33),
    preferredAEADAlgorithms(39),
    intendedRecipientFingerprint(35),
    attestedCertification(37);

    private static final Map<Integer, SignatureSubpacket> MAP;
    private final int code;

    private SignatureSubpacket(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public static SignatureSubpacket fromCode(int code) {
        return MAP.get(code);
    }

    @Nonnull
    public static SignatureSubpacket requireFromCode(int code) {
        SignatureSubpacket tag = SignatureSubpacket.fromCode(code);
        if (tag == null) {
            throw new NoSuchElementException("No SignatureSubpacket tag found with code " + code);
        }
        return tag;
    }

    public static List<SignatureSubpacket> fromCodes(int[] codes) {
        ArrayList<SignatureSubpacket> tags = new ArrayList<SignatureSubpacket>();
        for (int code : codes) {
            try {
                tags.add(SignatureSubpacket.requireFromCode(code));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return tags;
    }

    static {
        MAP = new ConcurrentHashMap<Integer, SignatureSubpacket>();
        for (SignatureSubpacket p : SignatureSubpacket.values()) {
            MAP.put(p.code, p);
        }
    }
}

