/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.consumer.CertificateValidator;
import org.pgpainless.signature.consumer.DetachedSignatureCheck;
import org.pgpainless.signature.consumer.OnePassSignatureCheck;
import org.pgpainless.signature.consumer.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureInputStream
extends FilterInputStream {
    protected SignatureInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public static class VerifySignatures
    extends SignatureInputStream {
        private static final Logger LOGGER = LoggerFactory.getLogger(VerifySignatures.class);
        private final PGPObjectFactory objectFactory;
        private final List<OnePassSignatureCheck> opSignatures;
        private final Map<Long, OnePassSignatureCheck> opSignaturesWithMissingCert;
        private final List<DetachedSignatureCheck> detachedSignatures;
        private final ConsumerOptions options;
        private final OpenPgpMetadata.Builder resultBuilder;

        public VerifySignatures(InputStream literalDataStream, @Nullable PGPObjectFactory objectFactory, List<OnePassSignatureCheck> opSignatures, Map<Long, OnePassSignatureCheck> onePassSignaturesWithMissingCert, List<DetachedSignatureCheck> detachedSignatures, ConsumerOptions options, OpenPgpMetadata.Builder resultBuilder) {
            super(literalDataStream);
            this.objectFactory = objectFactory;
            this.opSignatures = opSignatures;
            this.opSignaturesWithMissingCert = onePassSignaturesWithMissingCert;
            this.detachedSignatures = detachedSignatures;
            this.options = options;
            this.resultBuilder = resultBuilder;
        }

        @Override
        public int read() throws IOException {
            boolean endOfStream;
            int data = super.read();
            boolean bl = endOfStream = data == -1;
            if (endOfStream) {
                this.finalizeSignatures();
            } else {
                byte b = (byte)data;
                this.updateOnePassSignatures(b);
                this.updateDetachedSignatures(b);
            }
            return data;
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            boolean endOfStream;
            int read = super.read(b, off, len);
            boolean bl = endOfStream = read == -1;
            if (endOfStream) {
                this.finalizeSignatures();
            } else {
                this.updateOnePassSignatures(b, off, read);
                this.updateDetachedSignatures(b, off, read);
            }
            return read;
        }

        private void finalizeSignatures() {
            this.parseAndCombineSignatures();
            this.verifyOnePassSignatures();
            this.verifyDetachedSignatures();
        }

        public void parseAndCombineSignatures() {
            PGPSignatureList signatures;
            if (this.objectFactory == null) {
                return;
            }
            try {
                signatures = this.parseSignatures(this.objectFactory);
            }
            catch (IOException e) {
                return;
            }
            List<PGPSignature> signatureList = SignatureUtils.toList(signatures);
            for (int i = 0; i < this.opSignatures.size(); ++i) {
                int reversedIndex = this.opSignatures.size() - i - 1;
                this.opSignatures.get(i).setSignature(signatureList.get(reversedIndex));
            }
            for (PGPSignature signature : signatureList) {
                if (!this.opSignaturesWithMissingCert.containsKey(signature.getKeyID())) continue;
                OnePassSignatureCheck check = this.opSignaturesWithMissingCert.remove(signature.getKeyID());
                check.setSignature(signature);
                this.resultBuilder.addInvalidInbandSignature(new SignatureVerification(signature, null), new SignatureValidationException("Missing verification certificate " + Long.toHexString(signature.getKeyID())));
            }
        }

        private PGPSignatureList parseSignatures(PGPObjectFactory objectFactory) throws IOException {
            PGPSignatureList signatureList = null;
            Object pgpObject = objectFactory.nextObject();
            while (pgpObject != null && signatureList == null) {
                if (pgpObject instanceof PGPSignatureList) {
                    signatureList = (PGPSignatureList)pgpObject;
                    continue;
                }
                pgpObject = objectFactory.nextObject();
            }
            if (signatureList == null || signatureList.isEmpty()) {
                throw new IOException("Verification failed - No Signatures found");
            }
            return signatureList;
        }

        private synchronized void verifyOnePassSignatures() {
            Policy policy = PGPainless.getPolicy();
            for (OnePassSignatureCheck opSignature : this.opSignatures) {
                if (opSignature.getSignature() == null) {
                    LOGGER.warn("Found OnePassSignature without respective signature packet -> skip");
                    continue;
                }
                try {
                    SignatureValidator.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(opSignature.getSignature());
                    CertificateValidator.validateCertificateAndVerifyOnePassSignature(opSignature, policy);
                    this.resultBuilder.addVerifiedInbandSignature(new SignatureVerification(opSignature.getSignature(), opSignature.getSigningKey()));
                }
                catch (SignatureValidationException e) {
                    LOGGER.warn("One-pass-signature verification failed for signature made by key {}: {}", opSignature.getSigningKey(), e.getMessage(), e);
                    this.resultBuilder.addInvalidInbandSignature(new SignatureVerification(opSignature.getSignature(), opSignature.getSigningKey()), e);
                }
            }
        }

        private void verifyDetachedSignatures() {
            Policy policy = PGPainless.getPolicy();
            for (DetachedSignatureCheck s : this.detachedSignatures) {
                try {
                    SignatureValidator.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(s.getSignature());
                    CertificateValidator.validateCertificateAndVerifyInitializedSignature(s.getSignature(), (PGPPublicKeyRing)s.getSigningKeyRing(), policy);
                    this.resultBuilder.addVerifiedDetachedSignature(new SignatureVerification(s.getSignature(), s.getSigningKeyIdentifier()));
                }
                catch (SignatureValidationException e) {
                    LOGGER.warn("One-pass-signature verification failed for signature made by key {}: {}", s.getSigningKeyIdentifier(), e.getMessage(), e);
                    this.resultBuilder.addInvalidDetachedSignature(new SignatureVerification(s.getSignature(), s.getSigningKeyIdentifier()), e);
                }
            }
        }

        private void updateOnePassSignatures(byte data) {
            for (OnePassSignatureCheck opSignature : this.opSignatures) {
                opSignature.getOnePassSignature().update(data);
            }
        }

        private void updateOnePassSignatures(byte[] bytes, int offset, int length) {
            for (OnePassSignatureCheck opSignature : this.opSignatures) {
                opSignature.getOnePassSignature().update(bytes, offset, length);
            }
        }

        private void updateDetachedSignatures(byte b) {
            for (DetachedSignatureCheck detachedSignature : this.detachedSignatures) {
                detachedSignature.getSignature().update(b);
            }
        }

        private void updateDetachedSignatures(byte[] b, int off, int read) {
            for (DetachedSignatureCheck detachedSignature : this.detachedSignatures) {
                detachedSignature.getSignature().update(b, off, read);
            }
        }
    }
}

