/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.pgpainless.key.protection.BaseSecretKeyRingProtector;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class PasswordBasedSecretKeyRingProtector
extends BaseSecretKeyRingProtector {
    public PasswordBasedSecretKeyRingProtector(@Nonnull SecretKeyPassphraseProvider passphraseProvider) {
        super(passphraseProvider);
    }

    public PasswordBasedSecretKeyRingProtector(@Nonnull KeyRingProtectionSettings settings, @Nonnull SecretKeyPassphraseProvider passphraseProvider) {
        super(passphraseProvider, settings);
    }

    public static PasswordBasedSecretKeyRingProtector forKey(final PGPKeyRing keyRing, final Passphrase passphrase) {
        SecretKeyPassphraseProvider passphraseProvider = new SecretKeyPassphraseProvider(){

            @Override
            @Nullable
            public Passphrase getPassphraseFor(Long keyId) {
                return this.hasPassphrase(keyId) ? passphrase : null;
            }

            @Override
            public boolean hasPassphrase(Long keyId) {
                return keyRing.getPublicKey(keyId) != null;
            }
        };
        return new PasswordBasedSecretKeyRingProtector(passphraseProvider);
    }

    public static PasswordBasedSecretKeyRingProtector forKey(PGPSecretKey key, Passphrase passphrase) {
        return PasswordBasedSecretKeyRingProtector.forKeyId(key.getPublicKey().getKeyID(), passphrase);
    }

    public static PasswordBasedSecretKeyRingProtector forKeyId(final long singleKeyId, final Passphrase passphrase) {
        SecretKeyPassphraseProvider passphraseProvider = new SecretKeyPassphraseProvider(){

            @Override
            @Nullable
            public Passphrase getPassphraseFor(Long keyId) {
                if (keyId == singleKeyId) {
                    return passphrase;
                }
                return null;
            }

            @Override
            public boolean hasPassphrase(Long keyId) {
                return keyId == singleKeyId;
            }
        };
        return new PasswordBasedSecretKeyRingProtector(passphraseProvider);
    }
}

