/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.decryption_verification.OpenPgpInputStream;
import org.pgpainless.decryption_verification.cleartext_signatures.ClearsignedMessageUtil;
import org.pgpainless.exception.WrongConsumingMethodException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import sop.ReadyWithResult;
import sop.Signatures;
import sop.exception.SOPGPException;
import sop.operation.InlineDetach;

public class InlineDetachImpl
implements InlineDetach {
    private boolean armor = true;

    @Override
    public InlineDetach noArmor() {
        this.armor = false;
        return this;
    }

    @Override
    public ReadyWithResult<Signatures> message(final InputStream messageInputStream) {
        return new ReadyWithResult<Signatures>(){
            private final ByteArrayOutputStream sigOut = new ByteArrayOutputStream();

            @Override
            public Signatures writeTo(OutputStream messageOutputStream) throws SOPGPException.NoSignature, IOException {
                PGPSignatureList signatures = null;
                OpenPgpInputStream pgpIn = new OpenPgpInputStream(messageInputStream);
                if (pgpIn.isNonOpenPgp()) {
                    throw new SOPGPException.BadData("Data appears to be non-OpenPGP.");
                }
                if (pgpIn.isAsciiArmored()) {
                    ArmoredInputStream armorIn = new ArmoredInputStream(pgpIn);
                    if (armorIn.isClearText()) {
                        try {
                            signatures = ClearsignedMessageUtil.detachSignaturesFromInbandClearsignedMessage(armorIn, messageOutputStream);
                            if (signatures == null) {
                                throw new SOPGPException.BadData("Data did not contain OpenPGP signatures.");
                            }
                        }
                        catch (WrongConsumingMethodException e) {
                            throw new SOPGPException.BadData(e);
                        }
                    }
                    pgpIn = new OpenPgpInputStream(armorIn);
                }
                if (signatures == null) {
                    Iterator<PGPSignature> next;
                    if (!pgpIn.isBinaryOpenPgp()) {
                        throw new SOPGPException.BadData("Data was containing ASCII armored non-OpenPGP data.");
                    }
                    PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(pgpIn);
                    while ((next = objectFactory.nextObject()) != null) {
                        if (next instanceof PGPOnePassSignatureList) continue;
                        if (next instanceof PGPLiteralData) {
                            PGPLiteralData literalData = (PGPLiteralData)((Object)next);
                            InputStream literalIn = literalData.getDataStream();
                            Streams.pipeAll(literalIn, messageOutputStream);
                            literalIn.close();
                            continue;
                        }
                        if (next instanceof PGPCompressedData) {
                            PGPCompressedData compressedData = (PGPCompressedData)((Object)next);
                            try {
                                objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(compressedData.getDataStream());
                                continue;
                            }
                            catch (PGPException e) {
                                throw new SOPGPException.BadData("Cannot decompress PGPCompressedData", e);
                            }
                        }
                        if (!(next instanceof PGPSignatureList)) continue;
                        signatures = (PGPSignatureList)((Object)next);
                    }
                }
                if (signatures == null) {
                    throw new SOPGPException.BadData("Data did not contain OpenPGP signatures.");
                }
                if (InlineDetachImpl.this.armor) {
                    ArmoredOutputStream armorOut = ArmoredOutputStreamFactory.get(this.sigOut);
                    for (PGPSignature signature : signatures) {
                        signature.encode(armorOut);
                    }
                    armorOut.close();
                } else {
                    for (PGPSignature signature : signatures) {
                        signature.encode(this.sigOut);
                    }
                }
                return new Signatures(){

                    @Override
                    public void writeTo(OutputStream signatureOutputStream) throws IOException {
                        Streams.pipeAll(new ByteArrayInputStream(sigOut.toByteArray()), signatureOutputStream);
                    }
                };
            }
        };
    }
}

