/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.cli.PGPainlessCLI;
import org.pgpainless.cli.TestUtils;

public class InlineDetachCmdTest {
    private PrintStream originalSout;
    private static File tempDir;
    private static File certFile;
    private static final String CERT = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: BCPG v1.64\n\nmFIEXhtfCBMIKoZIzj0DAQcCAwTGSFMBUOSLusXS8hdNHbdK3gN8hS7jd4ky7Czl\nmSti+oVyRJUwQAFZJ1NMsg1H8flSJP1/9YbHd9FBU4bHKGKPtBE8ZW1pbEBlbWFp\nbC51c2VyPoh1BBMTCgAdBQJeG18IAhsjBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQ\nVzbmkxrPNwz8rAD/S/VCQc5NJLArgTDkgrt3Q573HiYfrIQo1uk3dwV15WIBAMiq\noDmRMb8jzOBv6FGW4P5WAubPdnAvDD7XmArD+TSeuFYEXhtfCBIIKoZIzj0DAQcC\nAwTgWDWmHJLQUQ35Qg/rINmUhkUhj1E4O5t6Y2PipbqlGfDufLmIKnX40BoJPS4G\nHW7U0QXfwSaTXa1BAaNsMUomAwEIB4h1BBgTCgAdBQJeG18IAhsMBRYCAwEABAsJ\nCAcFFQoJCAsCHgEACgkQVzbmkxrPNwxOcwEA19Fnhw7XwpQoT61Fqg54vroAwTZ3\nT5A+LOdevAtzNOUA/RWeKfOGk6D+vKYRNpMJyqsHi/vBeKwXoeN0n6HuExVF\n=a1W7\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CLEAR_SIGNED_MESSAGE = "-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA512\n\nAh, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.\n-----BEGIN PGP SIGNATURE-----\n\niHUEARMKAB0WIQRPZlxNwsRmC8ZCXkFXNuaTGs83DAUCYJ/x5gAKCRBXNuaTGs83\nDFRwAP9/4wMvV3WcX59Clo7mkRce6iwW3VBdiN+yMu3tjmHB2wD/RfE28Q1v4+eo\nySNgbyvqYYsNr0fnBwaG3aaj+u5ExiE=\n=Z2SO\n-----END PGP SIGNATURE-----";
    private static final String CLEAR_SIGNED_SIGNATURE = "-----BEGIN PGP SIGNATURE-----\n\niHUEARMKAB0WIQRPZlxNwsRmC8ZCXkFXNuaTGs83DAUCYJ/x5gAKCRBXNuaTGs83\nDFRwAP9/4wMvV3WcX59Clo7mkRce6iwW3VBdiN+yMu3tjmHB2wD/RfE28Q1v4+eo\nySNgbyvqYYsNr0fnBwaG3aaj+u5ExiE=\n=Z2SO\n-----END PGP SIGNATURE-----";
    private static final String CLEAR_SIGNED_BODY = "Ah, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.";

    @BeforeAll
    public static void createTempDir() throws IOException {
        tempDir = TestUtils.createTempDirectory();
        certFile = new File(tempDir, "cert.asc");
        Assertions.assertTrue((boolean)certFile.createNewFile());
        try (FileOutputStream out = new FileOutputStream(certFile);){
            ByteArrayInputStream in = new ByteArrayInputStream(CERT.getBytes(StandardCharsets.UTF_8));
            Streams.pipeAll((InputStream)in, (OutputStream)out);
        }
    }

    @BeforeEach
    public void saveSout() {
        this.originalSout = System.out;
    }

    @AfterEach
    public void restoreSout() {
        System.setOut(this.originalSout);
    }

    @Test
    public void detachInbandSignatureAndMessage() throws IOException {
        ByteArrayInputStream clearSignedIn = new ByteArrayInputStream(CLEAR_SIGNED_MESSAGE.getBytes(StandardCharsets.UTF_8));
        System.setIn(clearSignedIn);
        ByteArrayOutputStream msgOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(msgOut));
        File tempSigFile = new File(tempDir, "sig.out");
        PGPainlessCLI.main((String[])new String[]{"inline-detach", "--signatures-out=" + tempSigFile.getAbsolutePath()});
        Assertions.assertEquals((Object)CLEAR_SIGNED_BODY, (Object)msgOut.toString());
        try (FileInputStream sigIn = new FileInputStream(tempSigFile);){
            ByteArrayOutputStream sigBytes = new ByteArrayOutputStream();
            Streams.pipeAll((InputStream)sigIn, (OutputStream)sigBytes);
            String sig = sigBytes.toString();
            TestUtils.assertSignatureIsArmored(sigBytes.toByteArray());
            TestUtils.assertSignatureEquals(CLEAR_SIGNED_SIGNATURE, sig);
        }
        catch (FileNotFoundException e) {
            Assertions.fail((String)"Signature File must have been written.", (Throwable)e);
        }
        System.setIn(new ByteArrayInputStream(msgOut.toByteArray()));
        ByteArrayOutputStream verifyOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(verifyOut));
        PGPainlessCLI.main((String[])new String[]{"verify", tempSigFile.getAbsolutePath(), certFile.getAbsolutePath()});
        Assertions.assertEquals((Object)"2021-05-15T16:08:06Z 4F665C4DC2C4660BC6425E415736E6931ACF370C 4F665C4DC2C4660BC6425E415736E6931ACF370C\n", (Object)verifyOut.toString());
    }

    @Test
    public void detachInbandSignatureAndMessageNoArmor() throws IOException {
        ByteArrayInputStream clearSignedIn = new ByteArrayInputStream(CLEAR_SIGNED_MESSAGE.getBytes(StandardCharsets.UTF_8));
        System.setIn(clearSignedIn);
        ByteArrayOutputStream msgOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(msgOut));
        File tempSigFile = new File(tempDir, "sig.asc");
        PGPainlessCLI.main((String[])new String[]{"inline-detach", "--signatures-out=" + tempSigFile.getAbsolutePath(), "--no-armor"});
        Assertions.assertEquals((Object)CLEAR_SIGNED_BODY, (Object)msgOut.toString());
        try (FileInputStream sigIn = new FileInputStream(tempSigFile);){
            ByteArrayOutputStream sigBytes = new ByteArrayOutputStream();
            Streams.pipeAll((InputStream)sigIn, (OutputStream)sigBytes);
            byte[] sig = sigBytes.toByteArray();
            TestUtils.assertSignatureIsNotArmored(sig);
            TestUtils.assertSignatureEquals(CLEAR_SIGNED_SIGNATURE.getBytes(StandardCharsets.UTF_8), sig);
        }
        catch (FileNotFoundException e) {
            Assertions.fail((String)"Signature File must have been written.", (Throwable)e);
        }
        System.setIn(new ByteArrayInputStream(msgOut.toByteArray()));
        ByteArrayOutputStream verifyOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(verifyOut));
        PGPainlessCLI.main((String[])new String[]{"verify", tempSigFile.getAbsolutePath(), certFile.getAbsolutePath()});
        Assertions.assertEquals((Object)"2021-05-15T16:08:06Z 4F665C4DC2C4660BC6425E415736E6931ACF370C 4F665C4DC2C4660BC6425E415736E6931ACF370C\n", (Object)verifyOut.toString());
    }

    @Test
    @ExpectSystemExitWithStatus(value=59)
    public void existingSignatureOutCausesException() throws IOException {
        ByteArrayInputStream clearSignedIn = new ByteArrayInputStream(CLEAR_SIGNED_MESSAGE.getBytes(StandardCharsets.UTF_8));
        System.setIn(clearSignedIn);
        ByteArrayOutputStream msgOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(msgOut));
        File existingSigFile = new File(tempDir, "sig.existing");
        Assertions.assertTrue((boolean)existingSigFile.createNewFile());
        PGPainlessCLI.main((String[])new String[]{"inline-detach", "--signatures-out=" + existingSigFile.getAbsolutePath()});
    }
}

