/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import com.ginsberg.junit.exit.FailOnSystemExit;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.cli.PGPainlessCLI;
import org.pgpainless.cli.TestUtils;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.util.KeyRingUtils;

public class RoundTripSignVerifyCmdTest {
    private static File tempDir;
    private static PrintStream originalSout;

    @BeforeAll
    public static void prepare() throws IOException {
        tempDir = TestUtils.createTempDirectory();
    }

    @Test
    @FailOnSystemExit
    public void testSignatureCreationAndVerification() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        originalSout = System.out;
        InputStream originalIn = System.in;
        File aliceKeyFile = new File(tempDir, "alice.key");
        Assertions.assertTrue((boolean)aliceKeyFile.createNewFile());
        PGPSecretKeyRing aliceKeys = PGPainless.generateKeyRing().modernKeyRing("alice");
        FileOutputStream aliceKeyOut = new FileOutputStream(aliceKeyFile);
        Streams.pipeAll((InputStream)new ByteArrayInputStream(aliceKeys.getEncoded()), (OutputStream)aliceKeyOut);
        ((OutputStream)aliceKeyOut).close();
        File aliceCertFile = new File(tempDir, "alice.pub");
        Assertions.assertTrue((boolean)aliceCertFile.createNewFile());
        PGPPublicKeyRing alicePub = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)aliceKeys);
        FileOutputStream aliceCertOut = new FileOutputStream(aliceCertFile);
        Streams.pipeAll((InputStream)new ByteArrayInputStream(alicePub.getEncoded()), (OutputStream)aliceCertOut);
        ((OutputStream)aliceCertOut).close();
        String data = "If privacy is outlawed, only outlaws will have privacy.\n";
        File dataFile = new File(tempDir, "data");
        Assertions.assertTrue((boolean)dataFile.createNewFile());
        FileOutputStream dataOut = new FileOutputStream(dataFile);
        Streams.pipeAll((InputStream)new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)), (OutputStream)dataOut);
        dataOut.close();
        File micalgOut = new File(tempDir, "micalg");
        FileInputStream dataIn = new FileInputStream(dataFile);
        System.setIn(dataIn);
        File sigFile = new File(tempDir, "sig.asc");
        Assertions.assertTrue((boolean)sigFile.createNewFile());
        FileOutputStream sigOut = new FileOutputStream(sigFile);
        System.setOut(new PrintStream(sigOut));
        PGPainlessCLI.execute((String[])new String[]{"sign", "--armor", "--micalg-out", micalgOut.getAbsolutePath(), aliceKeyFile.getAbsolutePath()});
        sigOut.close();
        ByteArrayOutputStream verifyOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(verifyOut));
        dataIn = new FileInputStream(dataFile);
        System.setIn(dataIn);
        PGPainlessCLI.execute((String[])new String[]{"verify", sigFile.getAbsolutePath(), aliceCertFile.getAbsolutePath()});
        dataIn.close();
        String verification = verifyOut.toString();
        String[] split = verification.split(" ");
        OpenPgpV4Fingerprint primaryKeyFingerprint = new OpenPgpV4Fingerprint(aliceKeys);
        OpenPgpV4Fingerprint signingKeyFingerprint = new OpenPgpV4Fingerprint((PGPPublicKey)new KeyRingInfo((PGPKeyRing)alicePub, new Date()).getSigningSubkeys().get(0));
        Assertions.assertEquals((Object)signingKeyFingerprint.toString(), (Object)split[1].trim(), (String)verification);
        Assertions.assertEquals((Object)primaryKeyFingerprint.toString(), (Object)split[2].trim());
        Assertions.assertTrue((boolean)micalgOut.exists());
        FileReader fileReader = new FileReader(micalgOut);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line = bufferedReader.readLine();
        Assertions.assertNull((Object)bufferedReader.readLine());
        bufferedReader.close();
        Assertions.assertEquals((Object)"pgp-sha512", (Object)line);
        System.setIn(originalIn);
    }

    @AfterAll
    public static void after() {
        System.setOut(originalSout);
        System.out.println(tempDir.getAbsolutePath());
    }
}

