/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.MarkerPacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.OpenPgpPacket;

public class TeeBCPGInputStream {
    protected final DelayedTeeInputStream delayedTee;
    protected final BCPGInputStream packetInputStream;

    public TeeBCPGInputStream(BCPGInputStream inputStream, OutputStream outputStream) {
        this.delayedTee = new DelayedTeeInputStream(inputStream, outputStream);
        this.packetInputStream = BCPGInputStream.wrap(this.delayedTee);
    }

    public OpenPgpPacket nextPacketTag() throws IOException {
        int tag = this.packetInputStream.nextPacketTag();
        if (tag == -1) {
            return null;
        }
        OpenPgpPacket packet = OpenPgpPacket.requireFromTag(tag);
        return packet;
    }

    public Packet readPacket() throws IOException {
        return this.packetInputStream.readPacket();
    }

    public PGPCompressedData readCompressedData() throws IOException {
        this.delayedTee.squeeze();
        PGPCompressedData compressedData = new PGPCompressedData(this.packetInputStream);
        return compressedData;
    }

    public PGPLiteralData readLiteralData() throws IOException {
        this.delayedTee.squeeze();
        return new PGPLiteralData(this.packetInputStream);
    }

    public PGPEncryptedDataList readEncryptedDataList() throws IOException {
        this.delayedTee.squeeze();
        return new PGPEncryptedDataList(this.packetInputStream);
    }

    public PGPOnePassSignature readOnePassSignature() throws PGPException, IOException {
        PGPOnePassSignature onePassSignature = new PGPOnePassSignature(this.packetInputStream);
        this.delayedTee.squeeze();
        return onePassSignature;
    }

    public PGPSignature readSignature() throws PGPException, IOException {
        PGPSignature signature = new PGPSignature(this.packetInputStream);
        this.delayedTee.squeeze();
        return signature;
    }

    public MarkerPacket readMarker() throws IOException {
        MarkerPacket markerPacket = (MarkerPacket)this.readPacket();
        this.delayedTee.squeeze();
        return markerPacket;
    }

    public void close() throws IOException {
        this.packetInputStream.close();
    }

    public static class DelayedTeeInputStream
    extends InputStream {
        private int last = -1;
        private final InputStream inputStream;
        private final OutputStream outputStream;

        public DelayedTeeInputStream(InputStream inputStream, OutputStream outputStream) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        @Override
        public int read() throws IOException {
            if (this.last != -1) {
                this.outputStream.write(this.last);
            }
            try {
                this.last = this.inputStream.read();
                return this.last;
            }
            catch (IOException e) {
                if ("crc check failed in armored message.".equals(e.getMessage())) {
                    throw e;
                }
                return -1;
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r;
            if (this.last != -1) {
                this.outputStream.write(this.last);
            }
            if ((r = this.inputStream.read(b, off, len)) > 0) {
                this.outputStream.write(b, off, r - 1);
                this.last = b[off + r - 1];
            } else {
                this.last = -1;
            }
            return r;
        }

        public void squeeze() throws IOException {
            if (this.last != -1) {
                this.outputStream.write(this.last);
            }
            this.last = -1;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
            this.outputStream.close();
        }
    }
}

