/*
 * Decompiled with CFR 0.152.
 */
package pgp.certificate_store.certificate;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.certificate.KeyMaterial;

public class Key
implements KeyMaterial {
    private final byte[] bytes;
    private final Certificate certificate;
    private final Long tag;

    public Key(byte[] bytes, Certificate certificate, Long tag) {
        this.bytes = bytes;
        this.certificate = certificate;
        this.tag = tag;
    }

    public Key(Key key, Long tag) {
        this(key.bytes, new Certificate(key.certificate, tag), tag);
    }

    public Certificate getCertificate() {
        return new Certificate(this.certificate, this.getTag());
    }

    @Override
    public String getFingerprint() {
        return this.certificate.getFingerprint();
    }

    @Override
    public Certificate asCertificate() {
        return this.getCertificate();
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public Long getTag() {
        return this.tag;
    }

    @Override
    public List<Long> getSubkeyIds() {
        return this.certificate.getSubkeyIds();
    }
}

