/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.cli.commands.CLITest;
import org.slf4j.LoggerFactory;

public class ArmorCmdTest
extends CLITest {
    private static final String key = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 62E9 DDA4 F20F 8341 D2BC  4B4C 8B07 5177 01F9 534C\nComment: alice@pgpainless.org\n\nlFgEY2vOkhYJKwYBBAHaRw8BAQdAqGOtLd1tKnuwaYYcdr2/7C0cPiCCggRMKG+W\nt32QQdEAAP9VaBzjk/AaAqyykZnQHmS1HByEvRLv5/4yJMSr22451BFjtBRhbGlj\nZUBwZ3BhaW5sZXNzLm9yZ4iOBBMWCgBBBQJja86SCRCLB1F3AflTTBYhBGLp3aTy\nD4NB0rxLTIsHUXcB+VNMAp4BApsBBRYCAwEABAsJCAcFFQoJCAsCmQEAACZhAP4s\n8hn/RBDvyLvGROOd15EYATnWlgyi+b5WXP6cELalJwD1FZy3RROhfNtZWcJPS43f\nG03pYNyb0NXoitIMAaXEB5xdBGNrzpISCisGAQQBl1UBBQEBB0CqCcYethOynfni\n8uRO+r/cZWp9hCLy8pRIExKqzcyEFAMBCAcAAP9sRRLoZkLpDaTNNrtIBovXu2AN\nhL8keUMWtVcuEHnkQA6iiHUEGBYKAB0FAmNrzpICngECmwwFFgIDAQAECwkIBwUV\nCgkICwAKCRCLB1F3AflTTBVpAP491etrjqCMWx2bBaw3K1vP0Mix6U0vF3J4kP9U\neZm6owEA4kX9VAGESvLgIc7CEiswmxdWjxnLQyCRtWXfjgFmYQucWARja86SFgkr\nBgEEAdpHDwEBB0DBslhDpWC6CV3xJUSo071NSO5Cf4fgOwOj+QHs8mpFbwABAPkQ\nioSydYiMi04LyfPohyrhhcdJDHallQg+jYHHUb2pEJCI1QQYFgoAfQUCY2vOkgKe\nAQKbAgUWAgMBAAQLCQgHBRUKCQgLXyAEGRYKAAYFAmNrzpIACgkQiHlkvEXh+f1e\nywEA9A2GLU9LxCJxZf2X4qcZY//YJDChIZHPnY0Vaek1DsMBAN1YILrH2rxQeCXj\nm4bUKfJIRrGt6ZJscwORgNI1dFQFAAoJEIsHUXcB+VNMK3gA/3vvPm57JsHA860w\nlB4D1II71oFNL8TFnJqTAvpSKe1AAP49S4mKB4PE0ElcDo7n+nEYt6ba8IMRDlMo\nrsH85mUgCw==\n=EMKf\n-----END PGP PRIVATE KEY BLOCK-----\n";

    public ArmorCmdTest() {
        super(LoggerFactory.getLogger(ArmorCmdTest.class));
    }

    @Test
    public void armorSecretKey() throws IOException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(key);
        byte[] binary = secretKeys.getEncoded();
        this.pipeBytesToStdin(binary);
        ByteArrayOutputStream armorOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("armor"));
        PGPSecretKeyRing armored = PGPainless.readKeyRing().secretKeyRing(armorOut.toString());
        Assertions.assertArrayEquals((byte[])secretKeys.getEncoded(), (byte[])armored.getEncoded());
    }

    @Test
    public void armorPublicKey() throws IOException {
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(key);
        PGPPublicKeyRing publicKey = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
        byte[] bytes = publicKey.getEncoded();
        this.pipeBytesToStdin(bytes);
        ByteArrayOutputStream armorOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("armor"));
        PGPPublicKeyRing armored = PGPainless.readKeyRing().publicKeyRing(armorOut.toString());
        Assertions.assertArrayEquals((byte[])publicKey.getEncoded(), (byte[])armored.getEncoded());
    }

    @Test
    public void armorMessage() throws IOException {
        String message = "Hello, World!\n";
        this.pipeStringToStdin(message);
        ByteArrayOutputStream armorOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("armor"));
        String armored = armorOut.toString();
        Assertions.assertTrue((boolean)armored.startsWith("-----BEGIN PGP MESSAGE-----\n"));
        Assertions.assertTrue((boolean)armored.contains("SGVsbG8sIFdvcmxkIQo="));
    }

    @Test
    public void labelNotYetSupported() throws IOException {
        this.pipeStringToStdin("Hello, World!\n");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("armor", "--label", "Message");
        Assertions.assertEquals((int)37, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void armorAlreadyArmoredDataIsIdempotent() throws IOException {
        this.pipeStringToStdin(key);
        ByteArrayOutputStream armorOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("armor"));
        String armored = armorOut.toString();
        Assertions.assertEquals((Object)key, (Object)armored);
    }
}

