/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.cli.commands.CLITest;
import org.slf4j.LoggerFactory;

public class DearmorCmdTest
extends CLITest {
    private static final String key = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 62E9 DDA4 F20F 8341 D2BC  4B4C 8B07 5177 01F9 534C\nComment: alice@pgpainless.org\n\nlFgEY2vOkhYJKwYBBAHaRw8BAQdAqGOtLd1tKnuwaYYcdr2/7C0cPiCCggRMKG+W\nt32QQdEAAP9VaBzjk/AaAqyykZnQHmS1HByEvRLv5/4yJMSr22451BFjtBRhbGlj\nZUBwZ3BhaW5sZXNzLm9yZ4iOBBMWCgBBBQJja86SCRCLB1F3AflTTBYhBGLp3aTy\nD4NB0rxLTIsHUXcB+VNMAp4BApsBBRYCAwEABAsJCAcFFQoJCAsCmQEAACZhAP4s\n8hn/RBDvyLvGROOd15EYATnWlgyi+b5WXP6cELalJwD1FZy3RROhfNtZWcJPS43f\nG03pYNyb0NXoitIMAaXEB5xdBGNrzpISCisGAQQBl1UBBQEBB0CqCcYethOynfni\n8uRO+r/cZWp9hCLy8pRIExKqzcyEFAMBCAcAAP9sRRLoZkLpDaTNNrtIBovXu2AN\nhL8keUMWtVcuEHnkQA6iiHUEGBYKAB0FAmNrzpICngECmwwFFgIDAQAECwkIBwUV\nCgkICwAKCRCLB1F3AflTTBVpAP491etrjqCMWx2bBaw3K1vP0Mix6U0vF3J4kP9U\neZm6owEA4kX9VAGESvLgIc7CEiswmxdWjxnLQyCRtWXfjgFmYQucWARja86SFgkr\nBgEEAdpHDwEBB0DBslhDpWC6CV3xJUSo071NSO5Cf4fgOwOj+QHs8mpFbwABAPkQ\nioSydYiMi04LyfPohyrhhcdJDHallQg+jYHHUb2pEJCI1QQYFgoAfQUCY2vOkgKe\nAQKbAgUWAgMBAAQLCQgHBRUKCQgLXyAEGRYKAAYFAmNrzpIACgkQiHlkvEXh+f1e\nywEA9A2GLU9LxCJxZf2X4qcZY//YJDChIZHPnY0Vaek1DsMBAN1YILrH2rxQeCXj\nm4bUKfJIRrGt6ZJscwORgNI1dFQFAAoJEIsHUXcB+VNMK3gA/3vvPm57JsHA860w\nlB4D1II71oFNL8TFnJqTAvpSKe1AAP49S4mKB4PE0ElcDo7n+nEYt6ba8IMRDlMo\nrsH85mUgCw==\n=EMKf\n-----END PGP PRIVATE KEY BLOCK-----\n";

    public DearmorCmdTest() {
        super(LoggerFactory.getLogger(DearmorCmdTest.class));
    }

    @Test
    public void dearmorSecretKey() throws IOException {
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(key);
        this.pipeStringToStdin(key);
        ByteArrayOutputStream dearmored = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("dearmor"));
        Assertions.assertArrayEquals((byte[])secretKey.getEncoded(), (byte[])dearmored.toByteArray());
    }

    @Test
    public void dearmorBrokenArmoredKeyFails() throws IOException {
        String invalidBase64 = "lFgEY2vOkhYJKwYBBAHaRw8BAQdAqGOtLd1tKnuwaYYcdr2/7C0cPiCCggRMKG+Wt32QQdEAAP9VaBzjk/AaAqyykZnQHmS1HByEvRLv5/4yJMSr22451BFjtBRhbGljZUBwZ3BhaW5sZXNzLm9yZ4iOBBMWCgBBBQJja86SCRCLB1F3AflTTBYhBGLp3aTyD4NB0rxLT-IsHUXcB+VNMAp4BApsBBRYCAwEABAsJCAcFFQoJCAsCmQEAACZhAP4s8hn/RBDvyLvGROOd15EYATnWlgyi+b5WXP6cELalJwD1FZy3RROhfNtZWcJPS43fG03pYNyb0NXoitIMAaXEB5xdBGNrzpISCisGAQQBl1UBBQEBB0CqCcYethOynfni8uRO+r/cZWp9hCLy8pRIExKqzcyEFAMBCAcAAP9sRRLoZkLpDaTNNrtIBovXu2ANhL8keUMWtVcuEHnkQA6iiHUEGBYKAB0FAmNrzpICngECmwwFFgIDAQAECwkIBwUVCgkICwAKCRCLB1F3AflTTBVpAP491etrjqCMWx2bBaw3K1vP0Mix6U0vF3J4kP9UeZm6owEA4kX9VAGESvLgIc7CEiswmxdWjxnLQyCRtWXfjgFmYQucWARja86SFgkrBgEEAdpHDwEBB0DBslhDpWC6CV3xJUSo071NSO5Cf4fgOwOj+QHs8mpFbwABAPkQioSydYiMi04LyfPohyrhhcdJDHallQg+jYHHUb2pEJCI1QQYFgoAfQUCY2vOkgKeAQKbAgUWAgMBAAQLCQgHBRUKCQgLXyAEGRYKAAYFAmNrzpIACgkQiHlkvEXh+f1eywEA9A2GLU9LxCJxZf2X4qcZY//YJDChIZHPnY0Vaek1DsMBAN1YILrH2rxQeCXjm4bUKfJIRrGt6ZJscwORgNI1dFQFAAoJEIsHUXcB+VNMK3gA/3vvPm57JsHA860wlB4D1II71oFNL8TFnJqTAvpSKe1AAP49S4mKB4PE0ElcDo7n+nEYt6ba8IMRDlMorsH85mUgCw==";
        this.pipeStringToStdin(invalidBase64);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("dearmor");
        Assertions.assertEquals((int)41, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void dearmorCertificate() throws IOException {
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(key);
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
        String armoredCert = PGPainless.asciiArmor((PGPKeyRing)certificate);
        this.pipeStringToStdin(armoredCert);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("dearmor"));
        Assertions.assertArrayEquals((byte[])certificate.getEncoded(), (byte[])out.toByteArray());
    }

    @Test
    public void dearmorMessage() throws IOException {
        String armored = "-----BEGIN PGP MESSAGE-----\nVersion: BCPG v1.69\n\nSGVsbG8sIFdvcmxkCg==\n=fkLo\n-----END PGP MESSAGE-----";
        this.pipeStringToStdin(armored);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("dearmor"));
        Assertions.assertEquals((Object)"Hello, World\n", (Object)out.toString());
    }

    @Test
    public void dearmorGarbageEmitsEmpty() throws IOException {
        String noArmoredData = "This is not armored.";
        this.pipeStringToStdin(noArmoredData);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("dearmor"));
        Assertions.assertTrue((boolean)out.toString().isEmpty());
    }
}

