/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.cli.commands.CLITest;
import org.pgpainless.key.info.KeyRingInfo;
import org.slf4j.LoggerFactory;

public class ExtractCertCmdTest
extends CLITest {
    public ExtractCertCmdTest() {
        super(LoggerFactory.getLogger(ExtractCertCmdTest.class));
    }

    @Test
    public void testExtractCert() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("Juliet Capulet <juliet@capulet.lit>");
        this.pipeBytesToStdin(secretKeys.getEncoded());
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("extract-cert", "--armor"));
        Assertions.assertTrue((boolean)out.toString().startsWith("-----BEGIN PGP PUBLIC KEY BLOCK-----\n"));
        PGPPublicKeyRing publicKeys = PGPainless.readKeyRing().publicKeyRing(out.toByteArray());
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)publicKeys);
        Assertions.assertFalse((boolean)info.isSecretKey());
        Assertions.assertTrue((boolean)info.isUserIdValid("Juliet Capulet <juliet@capulet.lit>"));
    }

    @Test
    public void testExtractCertFromCertFails() throws IOException {
        File keyFile = this.pipeStdoutToFile("key.asc");
        this.assertSuccess(this.executeCommand("generate-key", "Alice <alice@pgpainless.org>"));
        this.pipeFileToStdin(keyFile);
        File certFile = this.pipeStdoutToFile("cert.asc");
        this.assertSuccess(this.executeCommand("extract-cert"));
        this.pipeFileToStdin(certFile);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("extract-cert");
        Assertions.assertEquals((int)41, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void extractCertFromGarbageFails() throws IOException {
        this.pipeStringToStdin("This is a bunch of garbage!");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("extract-cert");
        Assertions.assertEquals((int)41, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void testExtractCertUnarmored() throws IOException {
        File keyFile = this.pipeStdoutToFile("key.asc");
        this.assertSuccess(this.executeCommand("generate-key", "Alice <alice@pgpainless.org>"));
        this.pipeFileToStdin(keyFile);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("extract-cert", "--no-armor"));
        Assertions.assertFalse((boolean)out.toString().startsWith("-----BEGIN PGP PUBLIC KEY BLOCK-----\n"));
        this.pipeBytesToStdin(out.toByteArray());
        ByteArrayOutputStream armored = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("armor"));
        Assertions.assertTrue((boolean)armored.toString().startsWith("-----BEGIN PGP PUBLIC KEY BLOCK-----\n"));
    }
}

