/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.encoders.Hex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.cli.commands.CLITest;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;
import org.slf4j.LoggerFactory;

public class GenerateKeyCmdTest
extends CLITest {
    public GenerateKeyCmdTest() {
        super(LoggerFactory.getLogger(GenerateKeyCmdTest.class));
    }

    @Test
    public void testGenerateKey() throws IOException {
        File keyFile = this.pipeStdoutToFile("key.asc");
        this.assertSuccess(this.executeCommand("generate-key", "Alice <alice@pgpainless.org>"));
        String key = this.readStringFromFile(keyFile);
        Assertions.assertTrue((boolean)key.startsWith("-----BEGIN PGP PRIVATE KEY BLOCK-----\n"));
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(key);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isFullyDecrypted());
        Assertions.assertEquals(Collections.singletonList("Alice <alice@pgpainless.org>"), (Object)info.getUserIds());
    }

    @Test
    public void testGenerateBinaryKey() throws IOException {
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("generate-key", "--no-armor", "Alice <alice@pgpainless.org>"));
        byte[] key = out.toByteArray();
        String firstHexOctet = Hex.toHexString((byte[])key, (int)0, (int)1);
        Assertions.assertTrue((firstHexOctet.equals("c5") || firstHexOctet.equals("94") ? 1 : 0) != 0);
    }

    @Test
    public void testGenerateKeyWithMultipleUserIds() throws IOException {
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("generate-key", "Alice <alice@pgpainless.org>", "Alice <alice@openpgp.org>"));
        String key = out.toString();
        Assertions.assertTrue((boolean)key.startsWith("-----BEGIN PGP PRIVATE KEY BLOCK-----\n"));
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(key);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isFullyDecrypted());
        Assertions.assertEquals(Arrays.asList("Alice <alice@pgpainless.org>", "Alice <alice@openpgp.org>"), (Object)info.getUserIds());
    }

    @Test
    public void testPasswordProtectedKey() throws IOException, PGPException {
        File passwordFile = this.writeFile("password", "sw0rdf1sh");
        passwordFile.deleteOnExit();
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("generate-key", "--with-key-password", passwordFile.getAbsolutePath(), "Alice <alice@pgpainless.org>"));
        String key = out.toString();
        Assertions.assertTrue((boolean)key.startsWith("-----BEGIN PGP PRIVATE KEY BLOCK-----\n"));
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(key);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isFullyEncrypted());
        Assertions.assertNotNull((Object)UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (Passphrase)Passphrase.fromPassword((String)"sw0rdf1sh")));
    }

    @Test
    public void testGeneratePasswordProtectedKey_missingPasswordFile() throws IOException {
        int exit = this.executeCommand("generate-key", "--with-key-password", "nonexistent", "Alice <alice@pgpainless.org>");
        Assertions.assertEquals((int)61, (int)exit, (String)"Expected MISSING_INPUT (61)");
    }
}

