/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.pgpainless.algorithm.AlgorithmSuite;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.util.DateUtil;
import org.pgpainless.util.NotationRegistry;

public final class Policy {
    private static Policy INSTANCE;
    private HashAlgorithmPolicy signatureHashAlgorithmPolicy = HashAlgorithmPolicy.smartSignatureHashAlgorithmPolicy();
    private HashAlgorithmPolicy revocationSignatureHashAlgorithmPolicy = HashAlgorithmPolicy.smartSignatureHashAlgorithmPolicy();
    private SymmetricKeyAlgorithmPolicy symmetricKeyEncryptionAlgorithmPolicy = SymmetricKeyAlgorithmPolicy.symmetricKeyEncryptionPolicy2022();
    private SymmetricKeyAlgorithmPolicy symmetricKeyDecryptionAlgorithmPolicy = SymmetricKeyAlgorithmPolicy.symmetricKeyDecryptionPolicy2022();
    private CompressionAlgorithmPolicy compressionAlgorithmPolicy = CompressionAlgorithmPolicy.anyCompressionAlgorithmPolicy();
    private PublicKeyAlgorithmPolicy publicKeyAlgorithmPolicy = PublicKeyAlgorithmPolicy.bsi2021PublicKeyAlgorithmPolicy();
    private final NotationRegistry notationRegistry = new NotationRegistry();
    private AlgorithmSuite keyGenerationAlgorithmSuite = AlgorithmSuite.getDefaultAlgorithmSuite();
    private SignerUserIdValidationLevel signerUserIdValidationLevel = SignerUserIdValidationLevel.DISABLED;
    private boolean enableKeyParameterValidation = false;

    Policy() {
    }

    public static Policy getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Policy();
        }
        return INSTANCE;
    }

    public HashAlgorithmPolicy getSignatureHashAlgorithmPolicy() {
        return this.signatureHashAlgorithmPolicy;
    }

    public void setSignatureHashAlgorithmPolicy(HashAlgorithmPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("Policy cannot be null.");
        }
        this.signatureHashAlgorithmPolicy = policy;
    }

    public HashAlgorithmPolicy getRevocationSignatureHashAlgorithmPolicy() {
        return this.revocationSignatureHashAlgorithmPolicy;
    }

    public void setRevocationSignatureHashAlgorithmPolicy(HashAlgorithmPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("Policy cannot be null.");
        }
        this.revocationSignatureHashAlgorithmPolicy = policy;
    }

    public SymmetricKeyAlgorithmPolicy getSymmetricKeyEncryptionAlgorithmPolicy() {
        return this.symmetricKeyEncryptionAlgorithmPolicy;
    }

    public SymmetricKeyAlgorithmPolicy getSymmetricKeyDecryptionAlgorithmPolicy() {
        return this.symmetricKeyDecryptionAlgorithmPolicy;
    }

    public void setSymmetricKeyEncryptionAlgorithmPolicy(SymmetricKeyAlgorithmPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("Policy cannot be null.");
        }
        this.symmetricKeyEncryptionAlgorithmPolicy = policy;
    }

    public void setSymmetricKeyDecryptionAlgorithmPolicy(SymmetricKeyAlgorithmPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("Policy cannot be null.");
        }
        this.symmetricKeyDecryptionAlgorithmPolicy = policy;
    }

    public CompressionAlgorithmPolicy getCompressionAlgorithmPolicy() {
        return this.compressionAlgorithmPolicy;
    }

    public void setCompressionAlgorithmPolicy(CompressionAlgorithmPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("Compression policy cannot be null.");
        }
        this.compressionAlgorithmPolicy = policy;
    }

    public PublicKeyAlgorithmPolicy getPublicKeyAlgorithmPolicy() {
        return this.publicKeyAlgorithmPolicy;
    }

    public void setPublicKeyAlgorithmPolicy(PublicKeyAlgorithmPolicy publicKeyAlgorithmPolicy) {
        if (publicKeyAlgorithmPolicy == null) {
            throw new NullPointerException("Public key algorithm policy cannot be null.");
        }
        this.publicKeyAlgorithmPolicy = publicKeyAlgorithmPolicy;
    }

    public NotationRegistry getNotationRegistry() {
        return this.notationRegistry;
    }

    @Nonnull
    public AlgorithmSuite getKeyGenerationAlgorithmSuite() {
        return this.keyGenerationAlgorithmSuite;
    }

    public void setKeyGenerationAlgorithmSuite(@Nonnull AlgorithmSuite algorithmSuite) {
        this.keyGenerationAlgorithmSuite = algorithmSuite;
    }

    public SignerUserIdValidationLevel getSignerUserIdValidationLevel() {
        return this.signerUserIdValidationLevel;
    }

    public Policy setSignerUserIdValidationLevel(SignerUserIdValidationLevel signerUserIdValidationLevel) {
        if (signerUserIdValidationLevel == null) {
            throw new NullPointerException("SignerUserIdValidationLevel cannot be null.");
        }
        this.signerUserIdValidationLevel = signerUserIdValidationLevel;
        return this;
    }

    public Policy setEnableKeyParameterValidation(boolean enable) {
        this.enableKeyParameterValidation = enable;
        return this;
    }

    public boolean isEnableKeyParameterValidation() {
        return this.enableKeyParameterValidation;
    }

    public static final class PublicKeyAlgorithmPolicy {
        private final Map<PublicKeyAlgorithm, Integer> algorithmStrengths = new EnumMap<PublicKeyAlgorithm, Integer>(PublicKeyAlgorithm.class);

        public PublicKeyAlgorithmPolicy(Map<PublicKeyAlgorithm, Integer> minimalAlgorithmBitStrengths) {
            this.algorithmStrengths.putAll(minimalAlgorithmBitStrengths);
        }

        public boolean isAcceptable(int algorithmId, int bitStrength) {
            try {
                PublicKeyAlgorithm algorithm = PublicKeyAlgorithm.requireFromId(algorithmId);
                return this.isAcceptable(algorithm, bitStrength);
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }

        public boolean isAcceptable(PublicKeyAlgorithm algorithm, int bitStrength) {
            if (!this.algorithmStrengths.containsKey((Object)algorithm)) {
                return false;
            }
            int minStrength = this.algorithmStrengths.get((Object)algorithm);
            return bitStrength >= minStrength;
        }

        @Deprecated
        public static PublicKeyAlgorithmPolicy defaultPublicKeyAlgorithmPolicy() {
            return PublicKeyAlgorithmPolicy.bsi2021PublicKeyAlgorithmPolicy();
        }

        public static PublicKeyAlgorithmPolicy bsi2021PublicKeyAlgorithmPolicy() {
            EnumMap<PublicKeyAlgorithm, Integer> minimalBitStrengths = new EnumMap<PublicKeyAlgorithm, Integer>(PublicKeyAlgorithm.class);
            minimalBitStrengths.put(PublicKeyAlgorithm.RSA_GENERAL, 2000);
            minimalBitStrengths.put(PublicKeyAlgorithm.RSA_SIGN, 2000);
            minimalBitStrengths.put(PublicKeyAlgorithm.RSA_ENCRYPT, 2000);
            minimalBitStrengths.put(PublicKeyAlgorithm.ELGAMAL_ENCRYPT, 2000);
            minimalBitStrengths.put(PublicKeyAlgorithm.ELGAMAL_GENERAL, 2000);
            minimalBitStrengths.put(PublicKeyAlgorithm.DSA, 2000);
            minimalBitStrengths.put(PublicKeyAlgorithm.ECDSA, 250);
            minimalBitStrengths.put(PublicKeyAlgorithm.EDDSA, 250);
            minimalBitStrengths.put(PublicKeyAlgorithm.DIFFIE_HELLMAN, 2000);
            minimalBitStrengths.put(PublicKeyAlgorithm.ECDH, 250);
            minimalBitStrengths.put(PublicKeyAlgorithm.EC, 250);
            return new PublicKeyAlgorithmPolicy(minimalBitStrengths);
        }
    }

    public static final class CompressionAlgorithmPolicy {
        private final CompressionAlgorithm defaultCompressionAlgorithm;
        private final List<CompressionAlgorithm> acceptableCompressionAlgorithms;

        public CompressionAlgorithmPolicy(CompressionAlgorithm defaultCompressionAlgorithm, List<CompressionAlgorithm> acceptableCompressionAlgorithms) {
            this.defaultCompressionAlgorithm = defaultCompressionAlgorithm;
            this.acceptableCompressionAlgorithms = Collections.unmodifiableList(acceptableCompressionAlgorithms);
        }

        public CompressionAlgorithm defaultCompressionAlgorithm() {
            return this.defaultCompressionAlgorithm;
        }

        public boolean isAcceptable(int compressionAlgorithmTag) {
            try {
                CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.requireFromId(compressionAlgorithmTag);
                return this.isAcceptable(compressionAlgorithm);
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }

        public boolean isAcceptable(CompressionAlgorithm compressionAlgorithm) {
            return this.acceptableCompressionAlgorithms.contains((Object)compressionAlgorithm);
        }

        @Deprecated
        public static CompressionAlgorithmPolicy defaultCompressionAlgorithmPolicy() {
            return CompressionAlgorithmPolicy.anyCompressionAlgorithmPolicy();
        }

        public static CompressionAlgorithmPolicy anyCompressionAlgorithmPolicy() {
            return new CompressionAlgorithmPolicy(CompressionAlgorithm.ZIP, Arrays.asList(CompressionAlgorithm.UNCOMPRESSED, CompressionAlgorithm.ZIP, CompressionAlgorithm.BZIP2, CompressionAlgorithm.ZLIB));
        }
    }

    public static final class HashAlgorithmPolicy {
        private final HashAlgorithm defaultHashAlgorithm;
        private final Map<HashAlgorithm, Date> acceptableHashAlgorithmsAndTerminationDates;

        public HashAlgorithmPolicy(@Nonnull HashAlgorithm defaultHashAlgorithm, @Nonnull Map<HashAlgorithm, Date> algorithmTerminationDates) {
            this.defaultHashAlgorithm = defaultHashAlgorithm;
            this.acceptableHashAlgorithmsAndTerminationDates = algorithmTerminationDates;
        }

        public HashAlgorithmPolicy(@Nonnull HashAlgorithm defaultHashAlgorithm, @Nonnull List<HashAlgorithm> acceptableHashAlgorithms) {
            this(defaultHashAlgorithm, Collections.unmodifiableMap(HashAlgorithmPolicy.listToMap(acceptableHashAlgorithms)));
        }

        private static Map<HashAlgorithm, Date> listToMap(@Nonnull List<HashAlgorithm> algorithms) {
            HashMap<HashAlgorithm, Date> algorithmsAndTerminationDates = new HashMap<HashAlgorithm, Date>();
            for (HashAlgorithm algorithm : algorithms) {
                algorithmsAndTerminationDates.put(algorithm, null);
            }
            return algorithmsAndTerminationDates;
        }

        public HashAlgorithm defaultHashAlgorithm() {
            return this.defaultHashAlgorithm;
        }

        public boolean isAcceptable(@Nonnull HashAlgorithm hashAlgorithm) {
            return this.isAcceptable(hashAlgorithm, new Date());
        }

        public boolean isAcceptable(int algorithmId) {
            try {
                HashAlgorithm algorithm = HashAlgorithm.requireFromId(algorithmId);
                return this.isAcceptable(algorithm);
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }

        public boolean isAcceptable(@Nonnull HashAlgorithm hashAlgorithm, @Nonnull Date usageDate) {
            if (!this.acceptableHashAlgorithmsAndTerminationDates.containsKey((Object)hashAlgorithm)) {
                return false;
            }
            Date terminationDate = this.acceptableHashAlgorithmsAndTerminationDates.get((Object)hashAlgorithm);
            if (terminationDate == null) {
                return true;
            }
            return terminationDate.after(usageDate);
        }

        public boolean isAcceptable(int algorithmId, @Nonnull Date usageDate) {
            try {
                HashAlgorithm algorithm = HashAlgorithm.requireFromId(algorithmId);
                return this.isAcceptable(algorithm, usageDate);
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }

        @Deprecated
        public static HashAlgorithmPolicy defaultSignatureAlgorithmPolicy() {
            return HashAlgorithmPolicy.smartSignatureHashAlgorithmPolicy();
        }

        public static HashAlgorithmPolicy smartSignatureHashAlgorithmPolicy() {
            HashMap<HashAlgorithm, Date> algorithmDateMap = new HashMap<HashAlgorithm, Date>();
            algorithmDateMap.put(HashAlgorithm.MD5, DateUtil.parseUTCDate("1997-02-01 00:00:00 UTC"));
            algorithmDateMap.put(HashAlgorithm.SHA1, DateUtil.parseUTCDate("2013-02-01 00:00:00 UTC"));
            algorithmDateMap.put(HashAlgorithm.RIPEMD160, DateUtil.parseUTCDate("2013-02-01 00:00:00 UTC"));
            algorithmDateMap.put(HashAlgorithm.SHA224, null);
            algorithmDateMap.put(HashAlgorithm.SHA256, null);
            algorithmDateMap.put(HashAlgorithm.SHA384, null);
            algorithmDateMap.put(HashAlgorithm.SHA512, null);
            return new HashAlgorithmPolicy(HashAlgorithm.SHA512, algorithmDateMap);
        }

        public static HashAlgorithmPolicy static2022SignatureHashAlgorithmPolicy() {
            return new HashAlgorithmPolicy(HashAlgorithm.SHA512, Arrays.asList(HashAlgorithm.SHA224, HashAlgorithm.SHA256, HashAlgorithm.SHA384, HashAlgorithm.SHA512));
        }

        @Deprecated
        public static HashAlgorithmPolicy defaultRevocationSignatureHashAlgorithmPolicy() {
            return HashAlgorithmPolicy.smartSignatureHashAlgorithmPolicy();
        }

        public static HashAlgorithmPolicy static2022RevocationSignatureHashAlgorithmPolicy() {
            return new HashAlgorithmPolicy(HashAlgorithm.SHA512, Arrays.asList(HashAlgorithm.RIPEMD160, HashAlgorithm.SHA1, HashAlgorithm.SHA224, HashAlgorithm.SHA256, HashAlgorithm.SHA384, HashAlgorithm.SHA512));
        }
    }

    public static final class SymmetricKeyAlgorithmPolicy {
        private final SymmetricKeyAlgorithm defaultSymmetricKeyAlgorithm;
        private final List<SymmetricKeyAlgorithm> acceptableSymmetricKeyAlgorithms;

        public SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm defaultSymmetricKeyAlgorithm, List<SymmetricKeyAlgorithm> acceptableSymmetricKeyAlgorithms) {
            this.defaultSymmetricKeyAlgorithm = defaultSymmetricKeyAlgorithm;
            this.acceptableSymmetricKeyAlgorithms = Collections.unmodifiableList(acceptableSymmetricKeyAlgorithms);
        }

        public SymmetricKeyAlgorithm getDefaultSymmetricKeyAlgorithm() {
            return this.defaultSymmetricKeyAlgorithm;
        }

        public boolean isAcceptable(SymmetricKeyAlgorithm algorithm) {
            return this.acceptableSymmetricKeyAlgorithms.contains((Object)algorithm);
        }

        public boolean isAcceptable(int algorithmId) {
            try {
                SymmetricKeyAlgorithm algorithm = SymmetricKeyAlgorithm.requireFromId(algorithmId);
                return this.isAcceptable(algorithm);
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }

        @Deprecated
        public static SymmetricKeyAlgorithmPolicy defaultSymmetricKeyEncryptionAlgorithmPolicy() {
            return SymmetricKeyAlgorithmPolicy.symmetricKeyEncryptionPolicy2022();
        }

        public static SymmetricKeyAlgorithmPolicy symmetricKeyEncryptionPolicy2022() {
            return new SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_256, Arrays.asList(SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.TWOFISH, SymmetricKeyAlgorithm.CAMELLIA_256, SymmetricKeyAlgorithm.CAMELLIA_192, SymmetricKeyAlgorithm.CAMELLIA_128));
        }

        @Deprecated
        public static SymmetricKeyAlgorithmPolicy defaultSymmetricKeyDecryptionAlgorithmPolicy() {
            return SymmetricKeyAlgorithmPolicy.symmetricKeyDecryptionPolicy2022();
        }

        public static SymmetricKeyAlgorithmPolicy symmetricKeyDecryptionPolicy2022() {
            return new SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_256, Arrays.asList(SymmetricKeyAlgorithm.CAST5, SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.TWOFISH, SymmetricKeyAlgorithm.CAMELLIA_256, SymmetricKeyAlgorithm.CAMELLIA_192, SymmetricKeyAlgorithm.CAMELLIA_128));
        }

        public SymmetricKeyAlgorithm selectBest(List<SymmetricKeyAlgorithm> options) {
            for (SymmetricKeyAlgorithm acceptable : this.acceptableSymmetricKeyAlgorithms) {
                if (!options.contains((Object)acceptable)) continue;
                return acceptable;
            }
            return null;
        }
    }

    public static enum SignerUserIdValidationLevel {
        STRICT,
        DISABLED;

    }
}

