/*
 * Decompiled with CFR 0.152.
 */
package sop;

import java.nio.charset.Charset;

public class Profile {
    private final String name;
    private final String description;

    public Profile(String name, String description) {
        this.name = name;
        this.description = description;
        if (Profile.exceeds1000CharLineLimit(this)) {
            throw new IllegalArgumentException("The line representation of a profile MUST NOT exceed 1000 bytes.");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getName() + ": " + this.getDescription();
    }

    private static boolean exceeds1000CharLineLimit(Profile profile) {
        String line = profile.toString();
        return line.getBytes(Charset.forName("UTF8")).length > 1000;
    }
}

