/*
 * Decompiled with CFR 0.152.
 */
package sop;

import java.util.Date;
import sop.enums.SignatureMode;
import sop.util.UTCUtil;

public class Verification {
    private final Date creationTime;
    private final String signingKeyFingerprint;
    private final String signingCertFingerprint;
    private final SignatureMode signatureMode;
    private final String description;
    private static final String MODE = "mode:";

    public Verification(Date creationTime, String signingKeyFingerprint, String signingCertFingerprint) {
        this(creationTime, signingKeyFingerprint, signingCertFingerprint, null, null);
    }

    public Verification(Date creationTime, String signingKeyFingerprint, String signingCertFingerprint, SignatureMode signatureMode, String description) {
        this.creationTime = creationTime;
        this.signingKeyFingerprint = signingKeyFingerprint;
        this.signingCertFingerprint = signingCertFingerprint;
        this.signatureMode = signatureMode;
        this.description = description == null ? null : description.trim();
    }

    public static Verification fromString(String toString) {
        String[] split = toString.trim().split(" ");
        if (split.length < 3) {
            throw new IllegalArgumentException("Verification must be of the format 'UTC-DATE OpenPGPFingerprint OpenPGPFingerprint [mode] [info]'");
        }
        if (split.length == 3) {
            return new Verification(UTCUtil.parseUTCDate(split[0]), split[1], split[2]);
        }
        SignatureMode mode = null;
        int index = 3;
        if (split[index].startsWith(MODE)) {
            mode = SignatureMode.valueOf(split[3].substring(MODE.length()));
            ++index;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = index; i < split.length; ++i) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(split[i]);
        }
        return new Verification(UTCUtil.parseUTCDate(split[0]), split[1], split[2], mode, sb.length() != 0 ? sb.toString() : null);
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getSigningKeyFingerprint() {
        return this.signingKeyFingerprint;
    }

    public String getSigningCertFingerprint() {
        return this.signingCertFingerprint;
    }

    public SignatureMode getSignatureMode() {
        return this.signatureMode;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(UTCUtil.formatUTCDate(this.getCreationTime())).append(' ').append(this.getSigningKeyFingerprint()).append(' ').append(this.getSigningCertFingerprint());
        if (this.signatureMode != null) {
            sb.append(' ').append(MODE).append((Object)this.signatureMode);
        }
        if (this.description != null) {
            sb.append(' ').append(this.description);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Verification)) {
            return false;
        }
        Verification other = (Verification)obj;
        return this.toString().equals(other.toString());
    }
}

