/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.cli.commands.CLITest;
import org.slf4j.LoggerFactory;

public class VersionCmdTest
extends CLITest {
    public VersionCmdTest() {
        super(LoggerFactory.getLogger(VersionCmdTest.class));
    }

    @Test
    public void testVersion() throws IOException {
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("version"));
        Assertions.assertTrue((boolean)out.toString().startsWith("PGPainless-SOP "));
    }

    @Test
    public void testGetBackendVersion() throws IOException {
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("version", "--backend"));
        Assertions.assertTrue((boolean)out.toString().startsWith("Bouncy Castle "));
    }

    @Test
    public void testExtendedVersion() throws IOException {
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("version", "--extended"));
        String info = out.toString();
        Assertions.assertTrue((boolean)info.startsWith("PGPainless-SOP "));
        Assertions.assertTrue((boolean)info.contains("Bouncy Castle"));
        Assertions.assertTrue((boolean)info.contains("Stateless OpenPGP Protocol"));
    }

    @Test
    public void testSopSpecVersion() throws IOException {
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("version", "--sop-spec"));
        String info = out.toString();
        Assertions.assertTrue((boolean)info.startsWith("draft-dkg-openpgp-stateless-cli-"));
    }
}

