/*
 * Decompiled with CFR 0.152.
 */
package sop;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sop.util.Optional;
import sop.util.UTF8Util;

public class Profile {
    private final String name;
    private final Optional<String> description;

    public Profile(@Nonnull String name, @Nullable String description) {
        String trimmedDescription;
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty.");
        }
        if (name.contains(":")) {
            throw new IllegalArgumentException("Name cannot contain ':'.");
        }
        if (name.contains(" ") || name.contains("\n") || name.contains("\t") || name.contains("\r")) {
            throw new IllegalArgumentException("Name cannot contain whitespace characters.");
        }
        this.name = name;
        this.description = description == null ? Optional.ofEmpty() : ((trimmedDescription = description.trim()).isEmpty() ? Optional.ofEmpty() : Optional.of(trimmedDescription));
        if (Profile.exceeds1000CharLineLimit(this)) {
            throw new IllegalArgumentException("The line representation of a profile MUST NOT exceed 1000 bytes.");
        }
    }

    public Profile(String name) {
        this(name, null);
    }

    public static Profile parse(String string) {
        if (string.contains(": ")) {
            String name = string.substring(0, string.indexOf(": "));
            String description = string.substring(string.indexOf(": ") + 2);
            return new Profile(name, description.trim());
        }
        if (string.endsWith(":")) {
            return new Profile(string.substring(0, string.length() - 1));
        }
        return new Profile(string.trim());
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description.isPresent();
    }

    public String toString() {
        if (this.getDescription().isEmpty()) {
            return this.getName();
        }
        return this.getName() + ": " + this.getDescription().get();
    }

    private static boolean exceeds1000CharLineLimit(Profile profile) {
        String line = profile.toString();
        return line.getBytes(UTF8Util.UTF8).length > 1000;
    }
}

