/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.RevokeKey;

@CommandLine.Command(name="revoke-key", resourceBundle="msg_revoke-key", exitCodeOnInvalidInput=37)
public class RevokeKeyCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    boolean armor = true;
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    String withKeyPassword;

    @Override
    public void run() {
        Ready ready;
        RevokeKey revokeKey = this.throwIfUnsupportedSubcommand(SopCLI.getSop().revokeKey(), "revoke-key");
        if (!this.armor) {
            revokeKey.noArmor();
        }
        if (this.withKeyPassword != null) {
            try {
                String password = RevokeKeyCmd.stringFromInputStream(this.getInput(this.withKeyPassword));
                revokeKey.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption e) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--with-key-password");
                throw new SOPGPException.UnsupportedOption(errorMsg, e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            ready = revokeKey.keys(System.in);
        }
        catch (SOPGPException.KeyIsProtected e) {
            String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", "STANDARD_IN");
            throw new SOPGPException.KeyIsProtected(errorMsg, e);
        }
        try {
            ready.writeTo(System.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

