/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.authentication.CertificateAuthenticity;
import org.pgpainless.authentication.CertificateAuthority;
import org.pgpainless.exception.KeyException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyAccessor;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.util.Passphrase;

public class EncryptionOptions {
    private final EncryptionPurpose purpose;
    private final Set<PGPKeyEncryptionMethodGenerator> encryptionMethods = new LinkedHashSet<PGPKeyEncryptionMethodGenerator>();
    private final Set<SubkeyIdentifier> encryptionKeys = new LinkedHashSet<SubkeyIdentifier>();
    private final Map<SubkeyIdentifier, KeyRingInfo> keyRingInfo = new HashMap<SubkeyIdentifier, KeyRingInfo>();
    private final Map<SubkeyIdentifier, KeyAccessor> keyViews = new HashMap<SubkeyIdentifier, KeyAccessor>();
    private final EncryptionKeySelector encryptionKeySelector = EncryptionOptions.encryptToAllCapableSubkeys();
    private boolean allowEncryptionWithMissingKeyFlags = false;
    private Date evaluationDate = new Date();
    private SymmetricKeyAlgorithm encryptionAlgorithmOverride = null;

    public EncryptionOptions() {
        this(EncryptionPurpose.ANY);
    }

    public EncryptionOptions(@Nonnull EncryptionPurpose purpose) {
        this.purpose = purpose;
    }

    public static EncryptionOptions get() {
        return new EncryptionOptions();
    }

    public EncryptionOptions setEvaluationDate(@Nonnull Date evaluationDate) {
        this.evaluationDate = evaluationDate;
        return this;
    }

    public static EncryptionOptions encryptCommunications() {
        return new EncryptionOptions(EncryptionPurpose.COMMUNICATIONS);
    }

    public static EncryptionOptions encryptDataAtRest() {
        return new EncryptionOptions(EncryptionPurpose.STORAGE);
    }

    public EncryptionOptions addAuthenticatableRecipients(String userId, boolean email, CertificateAuthority authority) {
        return this.addAuthenticatableRecipients(userId, email, authority, 120);
    }

    public EncryptionOptions addAuthenticatableRecipients(String userId, boolean email, CertificateAuthority authority, int targetAmount) {
        List<CertificateAuthenticity> identifiedCertificates = authority.lookupByUserId(userId, email, this.evaluationDate, targetAmount);
        boolean foundAcceptable = false;
        for (CertificateAuthenticity candidate : identifiedCertificates) {
            if (!candidate.isAuthenticated()) continue;
            this.addRecipient(candidate.getCertificate());
            foundAcceptable = true;
        }
        if (!foundAcceptable) {
            throw new IllegalArgumentException("Could not identify any trust-worthy certificates for '" + userId + "' and target trust amount " + targetAmount);
        }
        return this;
    }

    public EncryptionOptions addRecipients(@Nonnull Iterable<PGPPublicKeyRing> keys) {
        if (!keys.iterator().hasNext()) {
            throw new IllegalArgumentException("Set of recipient keys cannot be empty.");
        }
        for (PGPPublicKeyRing key : keys) {
            this.addRecipient(key);
        }
        return this;
    }

    public EncryptionOptions addRecipients(@Nonnull Iterable<PGPPublicKeyRing> keys, @Nonnull EncryptionKeySelector selector) {
        if (!keys.iterator().hasNext()) {
            throw new IllegalArgumentException("Set of recipient keys cannot be empty.");
        }
        for (PGPPublicKeyRing key : keys) {
            this.addRecipient(key, selector);
        }
        return this;
    }

    public EncryptionOptions addRecipient(@Nonnull PGPPublicKeyRing key, @Nonnull CharSequence userId) {
        return this.addRecipient(key, userId, this.encryptionKeySelector);
    }

    public EncryptionOptions addRecipient(@Nonnull PGPPublicKeyRing key, @Nonnull CharSequence userId, @Nonnull EncryptionKeySelector encryptionKeySelectionStrategy) {
        KeyRingInfo info = new KeyRingInfo(key, this.evaluationDate);
        List<PGPPublicKey> encryptionSubkeys = encryptionKeySelectionStrategy.selectEncryptionSubkeys(info.getEncryptionSubkeys(userId.toString(), this.purpose));
        if (encryptionSubkeys.isEmpty()) {
            throw new KeyException.UnacceptableEncryptionKeyException(OpenPgpFingerprint.of(key));
        }
        for (PGPPublicKey encryptionSubkey : encryptionSubkeys) {
            SubkeyIdentifier keyId = new SubkeyIdentifier((PGPKeyRing)key, encryptionSubkey.getKeyID());
            this.keyRingInfo.put(keyId, info);
            this.keyViews.put(keyId, new KeyAccessor.ViaUserId(info, keyId, userId.toString()));
            this.addRecipientKey(key, encryptionSubkey, false);
        }
        return this;
    }

    public EncryptionOptions addRecipient(@Nonnull PGPPublicKeyRing key) {
        return this.addRecipient(key, this.encryptionKeySelector);
    }

    public EncryptionOptions addRecipient(@Nonnull PGPPublicKeyRing key, @Nonnull EncryptionKeySelector encryptionKeySelectionStrategy) {
        return this.addAsRecipient(key, encryptionKeySelectionStrategy, false);
    }

    public EncryptionOptions addHiddenRecipient(@Nonnull PGPPublicKeyRing key) {
        return this.addHiddenRecipient(key, this.encryptionKeySelector);
    }

    public EncryptionOptions addHiddenRecipient(PGPPublicKeyRing key, EncryptionKeySelector encryptionKeySelectionStrategy) {
        return this.addAsRecipient(key, encryptionKeySelectionStrategy, true);
    }

    private EncryptionOptions addAsRecipient(PGPPublicKeyRing key, EncryptionKeySelector encryptionKeySelectionStrategy, boolean wildcardKeyId) {
        Date primaryKeyExpiration;
        KeyRingInfo info = new KeyRingInfo(key, this.evaluationDate);
        try {
            primaryKeyExpiration = info.getPrimaryKeyExpirationDate();
        }
        catch (NoSuchElementException e) {
            throw new KeyException.UnacceptableSelfSignatureException(OpenPgpFingerprint.of(key));
        }
        if (primaryKeyExpiration != null && primaryKeyExpiration.before(this.evaluationDate)) {
            throw new KeyException.ExpiredKeyException(OpenPgpFingerprint.of(key), primaryKeyExpiration);
        }
        List<PGPPublicKey> encryptionSubkeys = encryptionKeySelectionStrategy.selectEncryptionSubkeys(info.getEncryptionSubkeys(this.purpose));
        if (encryptionSubkeys.isEmpty() && this.allowEncryptionWithMissingKeyFlags) {
            List<PGPPublicKey> validSubkeys = info.getValidSubkeys();
            for (PGPPublicKey validSubkey : validSubkeys) {
                if (!validSubkey.isEncryptionKey() || !info.getKeyFlagsOf(validSubkey.getKeyID()).isEmpty()) continue;
                encryptionSubkeys.add(validSubkey);
            }
        }
        if (encryptionSubkeys.isEmpty()) {
            throw new KeyException.UnacceptableEncryptionKeyException(OpenPgpFingerprint.of(key));
        }
        for (PGPPublicKey encryptionSubkey : encryptionSubkeys) {
            SubkeyIdentifier keyId = new SubkeyIdentifier((PGPKeyRing)key, encryptionSubkey.getKeyID());
            this.keyRingInfo.put(keyId, info);
            this.keyViews.put(keyId, new KeyAccessor.ViaKeyId(info, keyId));
            this.addRecipientKey(key, encryptionSubkey, wildcardKeyId);
        }
        return this;
    }

    private void addRecipientKey(@Nonnull PGPPublicKeyRing keyRing, @Nonnull PGPPublicKey key, boolean wildcardKeyId) {
        this.encryptionKeys.add(new SubkeyIdentifier((PGPKeyRing)keyRing, key.getKeyID()));
        PublicKeyKeyEncryptionMethodGenerator encryptionMethod = ImplementationFactory.getInstance().getPublicKeyKeyEncryptionMethodGenerator(key);
        encryptionMethod.setUseWildcardKeyID(wildcardKeyId);
        this.addEncryptionMethod(encryptionMethod);
    }

    public EncryptionOptions addPassphrase(@Nonnull Passphrase passphrase) {
        if (passphrase.isEmpty()) {
            throw new IllegalArgumentException("Passphrase must not be empty.");
        }
        PBEKeyEncryptionMethodGenerator encryptionMethod = ImplementationFactory.getInstance().getPBEKeyEncryptionMethodGenerator(passphrase);
        return this.addEncryptionMethod(encryptionMethod);
    }

    public EncryptionOptions addEncryptionMethod(@Nonnull PGPKeyEncryptionMethodGenerator encryptionMethod) {
        this.encryptionMethods.add(encryptionMethod);
        return this;
    }

    Set<PGPKeyEncryptionMethodGenerator> getEncryptionMethods() {
        return new HashSet<PGPKeyEncryptionMethodGenerator>(this.encryptionMethods);
    }

    Map<SubkeyIdentifier, KeyRingInfo> getKeyRingInfo() {
        return new HashMap<SubkeyIdentifier, KeyRingInfo>(this.keyRingInfo);
    }

    Set<SubkeyIdentifier> getEncryptionKeyIdentifiers() {
        return new HashSet<SubkeyIdentifier>(this.encryptionKeys);
    }

    Map<SubkeyIdentifier, KeyAccessor> getKeyViews() {
        return new HashMap<SubkeyIdentifier, KeyAccessor>(this.keyViews);
    }

    SymmetricKeyAlgorithm getEncryptionAlgorithmOverride() {
        return this.encryptionAlgorithmOverride;
    }

    public EncryptionOptions overrideEncryptionAlgorithm(@Nonnull SymmetricKeyAlgorithm encryptionAlgorithm) {
        if (encryptionAlgorithm == SymmetricKeyAlgorithm.NULL) {
            throw new IllegalArgumentException("Plaintext encryption can only be used to denote unencrypted secret keys.");
        }
        this.encryptionAlgorithmOverride = encryptionAlgorithm;
        return this;
    }

    public EncryptionOptions setAllowEncryptionWithMissingKeyFlags() {
        this.allowEncryptionWithMissingKeyFlags = true;
        return this;
    }

    public boolean hasEncryptionMethod() {
        return !this.encryptionMethods.isEmpty();
    }

    public static EncryptionKeySelector encryptToFirstSubkey() {
        return new EncryptionKeySelector(){

            @Override
            public List<PGPPublicKey> selectEncryptionSubkeys(@Nonnull List<PGPPublicKey> encryptionCapableKeys) {
                return encryptionCapableKeys.isEmpty() ? Collections.emptyList() : Collections.singletonList(encryptionCapableKeys.get(0));
            }
        };
    }

    public static EncryptionKeySelector encryptToAllCapableSubkeys() {
        return new EncryptionKeySelector(){

            @Override
            public List<PGPPublicKey> selectEncryptionSubkeys(@Nonnull List<PGPPublicKey> encryptionCapableKeys) {
                return encryptionCapableKeys;
            }
        };
    }

    public static interface EncryptionKeySelector {
        public List<PGPPublicKey> selectEncryptionSubkeys(@Nonnull List<PGPPublicKey> var1);
    }
}

