/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.exception.MissingPassphraseException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.Passphrase;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.ChangeKeyPassword;

public class ChangeKeyPasswordImpl
implements ChangeKeyPassword {
    private final MatchMakingSecretKeyRingProtector oldProtector = new MatchMakingSecretKeyRingProtector();
    private Passphrase newPassphrase = Passphrase.emptyPassphrase();
    private boolean armor = true;

    @Override
    public ChangeKeyPassword noArmor() {
        this.armor = false;
        return this;
    }

    @Override
    public ChangeKeyPassword oldKeyPassphrase(String oldPassphrase) {
        this.oldProtector.addPassphrase(Passphrase.fromPassword(oldPassphrase));
        return this;
    }

    @Override
    public ChangeKeyPassword newKeyPassphrase(String newPassphrase) {
        this.newPassphrase = Passphrase.fromPassword(newPassphrase);
        return this;
    }

    @Override
    public Ready keys(InputStream inputStream) throws SOPGPException.KeyIsProtected {
        PGPSecretKeyRingCollection secretKeyRingCollection;
        SecretKeyRingProtector newProtector = SecretKeyRingProtector.unlockAnyKeyWith(this.newPassphrase);
        try {
            secretKeyRingCollection = KeyReader.readSecretKeys(inputStream, true);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData(e);
        }
        ArrayList<PGPSecretKeyRing> updatedSecretKeys = new ArrayList<PGPSecretKeyRing>();
        for (PGPSecretKeyRing secretKeys : secretKeyRingCollection) {
            this.oldProtector.addSecretKey(secretKeys);
            try {
                PGPSecretKeyRing changed = KeyRingUtils.changePassphrase(null, secretKeys, this.oldProtector, newProtector);
                updatedSecretKeys.add(changed);
            }
            catch (MissingPassphraseException e) {
                throw new SOPGPException.KeyIsProtected("Cannot unlock key " + OpenPgpFingerprint.of(secretKeys), e);
            }
            catch (PGPException e) {
                if (e.getMessage().contains("Exception decrypting key")) {
                    throw new SOPGPException.KeyIsProtected("Cannot unlock key " + OpenPgpFingerprint.of(secretKeys), e);
                }
                throw new RuntimeException("Cannot change passphrase of key " + OpenPgpFingerprint.of(secretKeys), e);
            }
        }
        final PGPSecretKeyRingCollection changedSecretKeyCollection = new PGPSecretKeyRingCollection(updatedSecretKeys);
        return new Ready(){

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                if (ChangeKeyPasswordImpl.this.armor) {
                    ArmoredOutputStream armorOut = ArmoredOutputStreamFactory.get(outputStream);
                    changedSecretKeyCollection.encode(armorOut);
                    armorOut.close();
                } else {
                    changedSecretKeyCollection.encode(outputStream);
                }
            }
        };
    }
}

