/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.util.Passphrase;
import sop.Profile;
import sop.Ready;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;
import sop.operation.Encrypt;
import sop.util.ProxyOutputStream;

public class EncryptImpl
implements Encrypt {
    private static final Profile RFC4880_PROFILE = new Profile("rfc4880", "Follow the packet format of rfc4880");
    public static final List<Profile> SUPPORTED_PROFILES = Arrays.asList(RFC4880_PROFILE);
    EncryptionOptions encryptionOptions = EncryptionOptions.get();
    SigningOptions signingOptions = null;
    MatchMakingSecretKeyRingProtector protector = new MatchMakingSecretKeyRingProtector();
    private final Set<PGPSecretKeyRing> signingKeys = new HashSet<PGPSecretKeyRing>();
    private String profile = RFC4880_PROFILE.getName();
    private EncryptAs encryptAs = EncryptAs.Binary;
    boolean armor = true;

    @Override
    public Encrypt noArmor() {
        this.armor = false;
        return this;
    }

    @Override
    public Encrypt mode(EncryptAs mode) throws SOPGPException.UnsupportedOption {
        this.encryptAs = mode;
        return this;
    }

    @Override
    public Encrypt signWith(InputStream keyIn) throws SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
        PGPSecretKeyRingCollection keys;
        if (this.signingOptions == null) {
            this.signingOptions = SigningOptions.get();
        }
        if ((keys = KeyReader.readSecretKeys(keyIn, true)).size() != 1) {
            throw new SOPGPException.BadData((Throwable)((Object)new AssertionError((Object)("Exactly one secret key at a time expected. Got " + keys.size()))));
        }
        PGPSecretKeyRing signingKey = keys.iterator().next();
        KeyRingInfo info = PGPainless.inspectKeyRing(signingKey);
        if (info.getSigningSubkeys().isEmpty()) {
            throw new SOPGPException.KeyCannotSign("Key " + OpenPgpFingerprint.of(signingKey) + " cannot sign.");
        }
        this.protector.addSecretKey(signingKey);
        this.signingKeys.add(signingKey);
        return this;
    }

    @Override
    public Encrypt withKeyPassword(byte[] password) {
        String passphrase = new String(password, Charset.forName("UTF8"));
        this.protector.addPassphrase(Passphrase.fromPassword(passphrase));
        return this;
    }

    @Override
    public Encrypt withPassword(String password) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        this.encryptionOptions.addPassphrase(Passphrase.fromPassword(password));
        return this;
    }

    @Override
    public Encrypt withCert(InputStream cert) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData {
        try {
            PGPPublicKeyRingCollection certificates = KeyReader.readPublicKeys(cert, true);
            this.encryptionOptions.addRecipients(certificates);
        }
        catch (KeyException.UnacceptableEncryptionKeyException e) {
            throw new SOPGPException.CertCannotEncrypt(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData(e);
        }
        return this;
    }

    @Override
    public Encrypt profile(String profileName) {
        for (Profile profile : SUPPORTED_PROFILES) {
            if (!profile.getName().equals(profileName)) continue;
            this.profile = profile.getName();
            return this;
        }
        throw new SOPGPException.UnsupportedProfile("encrypt", profileName);
    }

    @Override
    public Ready plaintext(final InputStream plaintext) throws IOException {
        if (!this.encryptionOptions.hasEncryptionMethod()) {
            throw new SOPGPException.MissingArg("Missing encryption method.");
        }
        ProducerOptions producerOptions = this.signingOptions != null ? ProducerOptions.signAndEncrypt(this.encryptionOptions, this.signingOptions) : ProducerOptions.encrypt(this.encryptionOptions);
        producerOptions.setAsciiArmor(this.armor);
        producerOptions.setEncoding(EncryptImpl.encryptAsToStreamEncoding(this.encryptAs));
        for (PGPSecretKeyRing signingKey : this.signingKeys) {
            try {
                this.signingOptions.addInlineSignature((SecretKeyRingProtector)this.protector, signingKey, this.encryptAs == EncryptAs.Binary ? DocumentSignatureType.BINARY_DOCUMENT : DocumentSignatureType.CANONICAL_TEXT_DOCUMENT);
            }
            catch (KeyException.UnacceptableSigningKeyException e) {
                throw new SOPGPException.KeyCannotSign();
            }
            catch (WrongPassphraseException e) {
                throw new SOPGPException.KeyIsProtected();
            }
            catch (PGPException e) {
                throw new SOPGPException.BadData(e);
            }
        }
        try {
            final ProxyOutputStream proxy = new ProxyOutputStream();
            final EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream(proxy).withOptions(producerOptions);
            return new Ready(){

                @Override
                public void writeTo(OutputStream outputStream) throws IOException {
                    proxy.replaceOutputStream(outputStream);
                    Streams.pipeAll(plaintext, encryptionStream);
                    encryptionStream.close();
                }
            };
        }
        catch (PGPException e) {
            throw new IOException();
        }
    }

    private static StreamEncoding encryptAsToStreamEncoding(EncryptAs encryptAs) {
        switch (encryptAs) {
            case Binary: {
                return StreamEncoding.BINARY;
            }
            case Text: {
                return StreamEncoding.UTF8;
            }
        }
        throw new IllegalArgumentException("Invalid value encountered: " + (Object)((Object)encryptAs));
    }
}

