/*
 * Decompiled with CFR 0.152.
 */
package sop;

import java.text.ParseException;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sop.enums.SignatureMode;
import sop.util.Optional;
import sop.util.UTCUtil;

public class Verification {
    private final Date creationTime;
    private final String signingKeyFingerprint;
    private final String signingCertFingerprint;
    private final Optional<SignatureMode> signatureMode;
    private final Optional<String> description;
    private static final String MODE = "mode:";

    public Verification(@Nonnull Date creationTime, @Nonnull String signingKeyFingerprint, @Nonnull String signingCertFingerprint) {
        this(creationTime, signingKeyFingerprint, signingCertFingerprint, Optional.ofEmpty(), Optional.ofEmpty());
    }

    public Verification(@Nonnull Date creationTime, @Nonnull String signingKeyFingerprint, @Nonnull String signingCertFingerprint, @Nullable SignatureMode signatureMode, @Nullable String description) {
        this(creationTime, signingKeyFingerprint, signingCertFingerprint, Optional.ofNullable(signatureMode), Optional.ofNullable(Verification.nullSafeTrim(description)));
    }

    private Verification(@Nonnull Date creationTime, @Nonnull String signingKeyFingerprint, @Nonnull String signingCertFingerprint, @Nonnull Optional<SignatureMode> signatureMode, @Nonnull Optional<String> description) {
        this.creationTime = creationTime;
        this.signingKeyFingerprint = signingKeyFingerprint;
        this.signingCertFingerprint = signingCertFingerprint;
        this.signatureMode = signatureMode;
        this.description = description;
    }

    private static String nullSafeTrim(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    @Nonnull
    public static Verification fromString(@Nonnull String toString) {
        String[] split = toString.trim().split(" ");
        if (split.length < 3) {
            throw new IllegalArgumentException("Verification must be of the format 'UTC-DATE OpenPGPFingerprint OpenPGPFingerprint [mode] [info]'");
        }
        if (split.length == 3) {
            return new Verification(Verification.parseUTCDate(split[0]), split[1], split[2]);
        }
        SignatureMode mode = null;
        int index = 3;
        if (split[index].startsWith(MODE)) {
            mode = SignatureMode.valueOf(split[3].substring(MODE.length()));
            ++index;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = index; i < split.length; ++i) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(split[i]);
        }
        return new Verification(Verification.parseUTCDate(split[0]), split[1], split[2], mode, sb.length() != 0 ? sb.toString() : null);
    }

    private static Date parseUTCDate(String utcFormatted) {
        try {
            return UTCUtil.parseUTCDate(utcFormatted);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Malformed UTC timestamp.", e);
        }
    }

    @Nonnull
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Nonnull
    public String getSigningKeyFingerprint() {
        return this.signingKeyFingerprint;
    }

    @Nonnull
    public String getSigningCertFingerprint() {
        return this.signingCertFingerprint;
    }

    @Nonnull
    public Optional<SignatureMode> getSignatureMode() {
        return this.signatureMode;
    }

    @Nonnull
    public Optional<String> getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(UTCUtil.formatUTCDate(this.getCreationTime())).append(' ').append(this.getSigningKeyFingerprint()).append(' ').append(this.getSigningCertFingerprint());
        if (this.signatureMode.isPresent()) {
            sb.append(' ').append(MODE).append((Object)this.signatureMode.get());
        }
        if (this.description.isPresent()) {
            sb.append(' ').append(this.description.get());
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Verification)) {
            return false;
        }
        Verification other = (Verification)obj;
        return this.toString().equals(other.toString());
    }
}

