/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import com.ginsberg.junit.exit.FailOnSystemExit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.cli.PGPainlessCLI;
import org.pgpainless.cli.TestUtils;

public class RoundTripInlineSignVerifyCmdTest {
    private static File tempDir;
    private static PrintStream originalSout;

    @BeforeAll
    public static void prepare() throws IOException {
        tempDir = TestUtils.createTempDirectory();
    }

    @Test
    @FailOnSystemExit
    public void encryptAndDecryptAMessage() throws IOException {
        originalSout = System.out;
        File sigmundKeyFile = new File(tempDir, "sigmund.key");
        Assertions.assertTrue((boolean)sigmundKeyFile.createNewFile());
        File sigmundCertFile = new File(tempDir, "sigmund.cert");
        Assertions.assertTrue((boolean)sigmundCertFile.createNewFile());
        File msgFile = new File(tempDir, "signed.asc");
        Assertions.assertTrue((boolean)msgFile.createNewFile());
        File passwordFile = new File(tempDir, "password");
        Assertions.assertTrue((boolean)passwordFile.createNewFile());
        FileOutputStream passwordOut = new FileOutputStream(passwordFile);
        passwordOut.write("sw0rdf1sh".getBytes(StandardCharsets.UTF_8));
        passwordOut.close();
        FileOutputStream sigmundKeyOut = new FileOutputStream(sigmundKeyFile);
        System.setOut(new PrintStream(sigmundKeyOut));
        PGPainlessCLI.execute((String[])new String[]{"generate-key", "--with-key-password=" + passwordFile.getAbsolutePath(), "Sigmund Freud <sigmund@pgpainless.org>"});
        ((OutputStream)sigmundKeyOut).close();
        FileInputStream sigmundKeyIn = new FileInputStream(sigmundKeyFile);
        System.setIn(sigmundKeyIn);
        FileOutputStream sigmundCertOut = new FileOutputStream(sigmundCertFile);
        System.setOut(new PrintStream(sigmundCertOut));
        PGPainlessCLI.execute((String[])new String[]{"extract-cert"});
        sigmundKeyIn.close();
        ((OutputStream)sigmundCertOut).close();
        String msg = "Hello World!\n";
        ByteArrayInputStream msgIn = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        System.setIn(msgIn);
        FileOutputStream msgAscOut = new FileOutputStream(msgFile);
        System.setOut(new PrintStream(msgAscOut));
        PGPainlessCLI.execute((String[])new String[]{"inline-sign", "--with-key-password=" + passwordFile.getAbsolutePath(), sigmundKeyFile.getAbsolutePath()});
        ((OutputStream)msgAscOut).close();
        File verifyFile = new File(tempDir, "verify.txt");
        FileInputStream msgAscIn = new FileInputStream(msgFile);
        System.setIn(msgAscIn);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream pOut = new PrintStream(out);
        System.setOut(pOut);
        PGPainlessCLI.execute((String[])new String[]{"inline-verify", "--verifications-out", verifyFile.getAbsolutePath(), sigmundCertFile.getAbsolutePath()});
        msgAscIn.close();
        Assertions.assertEquals((Object)msg, (Object)out.toString());
    }

    @AfterAll
    public static void after() {
        System.setOut(originalSout);
        System.out.println(tempDir.getAbsolutePath());
    }
}

