/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.opentest4j.TestAbortedException;
import org.pgpainless.cli.TestUtils;
import org.pgpainless.sop.SOPImpl;
import org.slf4j.Logger;
import sop.SOP;
import sop.cli.picocli.SopCLI;

public abstract class CLITest {
    protected File testDirectory;
    protected InputStream stdin;
    protected PrintStream stdout;
    protected final Logger LOGGER;

    public CLITest(@Nonnull Logger logger) {
        this.LOGGER = logger;
        SopCLI.setSopInstance((SOP)new SOPImpl());
    }

    @BeforeEach
    public void setup() throws IOException {
        this.testDirectory = TestUtils.createTempDirectory();
        this.testDirectory.deleteOnExit();
        this.LOGGER.debug(this.testDirectory.getAbsolutePath());
        this.stdin = System.in;
        this.stdout = System.out;
    }

    @AfterEach
    public void cleanup() throws IOException {
        this.resetStreams();
    }

    public File nonExistentFile(String name) {
        File file = new File(this.testDirectory, name);
        if (file.exists()) {
            throw new TestAbortedException("File " + file.getAbsolutePath() + " already exists.");
        }
        return file;
    }

    public File pipeStdoutToFile(String name) throws IOException {
        File file = new File(this.testDirectory, name);
        file.deleteOnExit();
        if (!file.createNewFile()) {
            throw new TestAbortedException("Cannot create new file " + file.getAbsolutePath());
        }
        System.setOut(new PrintStream(Files.newOutputStream(file.toPath(), new OpenOption[0])));
        return file;
    }

    public ByteArrayOutputStream pipeStdoutToStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.pipeStdoutToStream(out);
        return out;
    }

    public void pipeStdoutToStream(OutputStream stream) {
        System.setOut(new PrintStream(stream));
    }

    public void pipeFileToStdin(File file) throws IOException {
        System.setIn(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public void pipeBytesToStdin(byte[] bytes) {
        System.setIn(new ByteArrayInputStream(bytes));
    }

    public void pipeStringToStdin(String string) {
        System.setIn(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
    }

    public void resetStdout() {
        if (System.out != this.stdout) {
            System.out.flush();
            System.out.close();
        }
        System.setOut(this.stdout);
    }

    public void resetStdin() throws IOException {
        if (System.in != this.stdin) {
            System.in.close();
        }
        System.setIn(this.stdin);
    }

    public void resetStreams() throws IOException {
        this.resetStdout();
        this.resetStdin();
    }

    public File writeFile(String name, String data) throws IOException {
        return this.writeFile(name, data.getBytes(StandardCharsets.UTF_8));
    }

    public File writeFile(String name, byte[] bytes) throws IOException {
        return this.writeFile(name, new ByteArrayInputStream(bytes));
    }

    public File writeFile(String name, InputStream data) throws IOException {
        File file = new File(this.testDirectory, name);
        if (!file.createNewFile()) {
            throw new TestAbortedException("Cannot create new file " + file.getAbsolutePath());
        }
        file.deleteOnExit();
        try (FileOutputStream fileOut = new FileOutputStream(file);){
            Streams.pipeAll((InputStream)data, (OutputStream)fileOut);
            fileOut.flush();
        }
        return file;
    }

    public byte[] readBytesFromFile(File file) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (FileInputStream fileIn = new FileInputStream(file);){
            Streams.pipeAll((InputStream)fileIn, (OutputStream)buffer);
        }
        catch (FileNotFoundException e) {
            throw new TestAbortedException("File " + file.getAbsolutePath() + " does not exist!", (Throwable)e);
        }
        catch (IOException e) {
            throw new TestAbortedException("Cannot read from file " + file.getAbsolutePath(), (Throwable)e);
        }
        return buffer.toByteArray();
    }

    public String readStringFromFile(File file) {
        return new String(this.readBytesFromFile(file), StandardCharsets.UTF_8);
    }

    public int executeCommand(String ... command) throws IOException {
        int exitCode = SopCLI.execute((String[])command);
        this.resetStreams();
        return exitCode;
    }

    public void assertSuccess(int exitCode) {
        Assertions.assertEquals((int)0, (int)exitCode, (String)"Expected successful program execution");
    }
}

