/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.OutputStream;
import java.security.MessageDigest;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.util.Arrays;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.encryption_signing.PGPHashContextContentSignerBuilder;

class BcPGPHashContextContentSignerBuilder
extends PGPHashContextContentSignerBuilder {
    private final BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private final MessageDigest messageDigest;
    private final HashAlgorithm hashAlgorithm;

    BcPGPHashContextContentSignerBuilder(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
        this.hashAlgorithm = BcPGPHashContextContentSignerBuilder.requireFromName(messageDigest.getAlgorithm());
    }

    private static HashAlgorithm requireFromName(String digestName) {
        HashAlgorithm hashAlgorithm = HashAlgorithm.fromName(digestName);
        if (hashAlgorithm == null) {
            throw new IllegalArgumentException("Cannot recognize OpenPGP Hash Algorithm: " + digestName);
        }
        return hashAlgorithm;
    }

    @Override
    public PGPContentSigner build(final int signatureType, final PGPPrivateKey privateKey) throws PGPException {
        final PublicKeyAlgorithm keyAlgorithm = PublicKeyAlgorithm.requireFromId(privateKey.getPublicKeyPacket().getAlgorithm());
        AsymmetricKeyParameter privKeyParam = this.keyConverter.getPrivateKey(privateKey);
        final Signer signer = BcPGPHashContextContentSignerBuilder.createSigner(keyAlgorithm, this.messageDigest, privKeyParam);
        signer.init(true, privKeyParam);
        return new PGPContentSigner(){

            @Override
            public int getType() {
                return signatureType;
            }

            @Override
            public int getHashAlgorithm() {
                return BcPGPHashContextContentSignerBuilder.this.hashAlgorithm.getAlgorithmId();
            }

            @Override
            public int getKeyAlgorithm() {
                return keyAlgorithm.getAlgorithmId();
            }

            @Override
            public long getKeyID() {
                return privateKey.getKeyID();
            }

            @Override
            public OutputStream getOutputStream() {
                return new PGPHashContextContentSignerBuilder.SignerOutputStream(signer);
            }

            @Override
            public byte[] getSignature() {
                try {
                    return signer.generateSignature();
                }
                catch (CryptoException e) {
                    throw new IllegalStateException("unable to create signature");
                }
            }

            @Override
            public byte[] getDigest() {
                return BcPGPHashContextContentSignerBuilder.this.messageDigest.digest();
            }
        };
    }

    static Signer createSigner(PublicKeyAlgorithm keyAlgorithm, MessageDigest messageDigest, CipherParameters keyParam) throws PGPException {
        PGPHashContextContentSignerBuilder.ExistingMessageDigest staticDigest = new PGPHashContextContentSignerBuilder.ExistingMessageDigest(messageDigest);
        switch (keyAlgorithm.getAlgorithmId()) {
            case 1: 
            case 3: {
                return new RSADigestSigner(staticDigest);
            }
            case 17: {
                return new DSADigestSigner(new DSASigner(), staticDigest);
            }
            case 19: {
                return new DSADigestSigner(new ECDSASigner(), staticDigest);
            }
            case 22: {
                if (keyParam instanceof Ed25519PrivateKeyParameters || keyParam instanceof Ed25519PublicKeyParameters) {
                    return new EdDsaSigner(new Ed25519Signer(), staticDigest);
                }
                return new EdDsaSigner(new Ed448Signer(new byte[0]), staticDigest);
            }
        }
        throw new PGPException("cannot recognise keyAlgorithm: " + (Object)((Object)keyAlgorithm));
    }

    private static class EdDsaSigner
    implements Signer {
        private final Signer signer;
        private final Digest digest;
        private final byte[] digBuf;

        EdDsaSigner(Signer signer, Digest digest) {
            this.signer = signer;
            this.digest = digest;
            this.digBuf = new byte[digest.getDigestSize()];
        }

        @Override
        public void init(boolean forSigning, CipherParameters param) {
            this.signer.init(forSigning, param);
            this.digest.reset();
        }

        @Override
        public void update(byte b) {
            this.digest.update(b);
        }

        @Override
        public void update(byte[] in, int off, int len) {
            this.digest.update(in, off, len);
        }

        @Override
        public byte[] generateSignature() throws CryptoException, DataLengthException {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.generateSignature();
        }

        @Override
        public boolean verifySignature(byte[] signature) {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.verifySignature(signature);
        }

        @Override
        public void reset() {
            Arrays.clear(this.digBuf);
            this.signer.reset();
            this.digest.reset();
        }
    }
}

