/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.consumer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.consumer.OnePassSignatureCheck;
import org.pgpainless.signature.consumer.SignatureValidator;

public final class SignatureVerifier {
    private SignatureVerifier() {
    }

    public static boolean verifySignatureOverUserId(String userId, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserId, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureType type = SignatureType.valueOf(signature.getSignatureType());
        switch (type) {
            case GENERIC_CERTIFICATION: 
            case NO_CERTIFICATION: 
            case CASUAL_CERTIFICATION: 
            case POSITIVE_CERTIFICATION: {
                return SignatureVerifier.verifyUserIdCertification(userId, signature, signingKey, keyWithUserId, policy, referenceDate);
            }
            case CERTIFICATION_REVOCATION: {
                return SignatureVerifier.verifyUserIdRevocation(userId, signature, signingKey, keyWithUserId, policy, referenceDate);
            }
        }
        throw new SignatureValidationException("Signature is not a valid user-id certification/revocation signature: " + (Object)((Object)type));
    }

    public static boolean verifyUserIdCertification(String userId, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        return SignatureVerifier.verifyUserIdCertification(userId, signature, primaryKey, primaryKey, policy, referenceDate);
    }

    public static boolean verifyUserIdCertification(String userId, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserId, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureValidator.wasPossiblyMadeByKey(signingKey).verify(signature);
        SignatureValidator.signatureIsCertification().verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(referenceDate).verify(signature);
        SignatureValidator.correctSignatureOverUserId(userId, keyWithUserId, signingKey).verify(signature);
        return true;
    }

    public static boolean verifyUserIdRevocation(String userId, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        return SignatureVerifier.verifyUserIdRevocation(userId, signature, primaryKey, primaryKey, policy, referenceDate);
    }

    public static boolean verifyUserIdRevocation(String userId, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserId, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureValidator.wasPossiblyMadeByKey(signingKey).verify(signature);
        SignatureValidator.signatureIsOfType(SignatureType.CERTIFICATION_REVOCATION).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(referenceDate).verify(signature);
        SignatureValidator.correctSignatureOverUserId(userId, keyWithUserId, signingKey).verify(signature);
        return true;
    }

    public static boolean verifyUserAttributesCertification(PGPUserAttributeSubpacketVector userAttributes, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        return SignatureVerifier.verifyUserAttributesCertification(userAttributes, signature, primaryKey, primaryKey, policy, referenceDate);
    }

    public static boolean verifyUserAttributesCertification(PGPUserAttributeSubpacketVector userAttributes, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserAttributes, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureValidator.wasPossiblyMadeByKey(signingKey).verify(signature);
        SignatureValidator.signatureIsCertification().verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(referenceDate).verify(signature);
        SignatureValidator.correctSignatureOverUserAttributes(userAttributes, keyWithUserAttributes, signingKey).verify(signature);
        return true;
    }

    public static boolean verifyUserAttributesRevocation(PGPUserAttributeSubpacketVector userAttributes, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        return SignatureVerifier.verifyUserAttributesRevocation(userAttributes, signature, primaryKey, primaryKey, policy, referenceDate);
    }

    public static boolean verifyUserAttributesRevocation(PGPUserAttributeSubpacketVector userAttributes, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserAttributes, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureValidator.wasPossiblyMadeByKey(signingKey).verify(signature);
        SignatureValidator.signatureIsOfType(SignatureType.CERTIFICATION_REVOCATION).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(referenceDate).verify(signature);
        SignatureValidator.correctSignatureOverUserAttributes(userAttributes, keyWithUserAttributes, signingKey).verify(signature);
        return true;
    }

    public static boolean verifySubkeyBindingSignature(PGPSignature signature, PGPPublicKey primaryKey, PGPPublicKey subkey, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.SUBKEY_BINDING).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
        SignatureValidator.signatureDoesNotPredateSignee(subkey).verify(signature);
        SignatureValidator.signatureIsEffective(referenceDate).verify(signature);
        SignatureValidator.hasValidPrimaryKeyBindingSignatureIfRequired(primaryKey, subkey, policy, referenceDate).verify(signature);
        SignatureValidator.correctSubkeyBindingSignature(primaryKey, subkey).verify(signature);
        return true;
    }

    public static boolean verifySubkeyBindingRevocation(PGPSignature signature, PGPPublicKey primaryKey, PGPPublicKey subkey, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.SUBKEY_REVOCATION).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
        SignatureValidator.signatureDoesNotPredateSignee(subkey).verify(signature);
        SignatureValidator.signatureIsEffective(referenceDate).verify(signature);
        SignatureValidator.correctSignatureOverKey(primaryKey, subkey).verify(signature);
        return true;
    }

    public static boolean verifyDirectKeySignature(PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        return SignatureVerifier.verifyDirectKeySignature(signature, primaryKey, primaryKey, policy, referenceDate);
    }

    public static boolean verifyDirectKeySignature(PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey signedKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.DIRECT_KEY).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureDoesNotPredateSignee(signedKey).verify(signature);
        SignatureValidator.signatureIsEffective(referenceDate).verify(signature);
        SignatureValidator.correctSignatureOverKey(signingKey, signedKey).verify(signature);
        return true;
    }

    public static boolean verifyKeyRevocationSignature(PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.KEY_REVOCATION).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(referenceDate).verify(signature);
        SignatureValidator.correctSignatureOverKey(primaryKey, primaryKey).verify(signature);
        return true;
    }

    public static boolean verifyUninitializedSignature(PGPSignature signature, InputStream signedData, PGPPublicKey signingKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureVerifier.initializeSignatureAndUpdateWithSignedData(signature, signedData, signingKey);
        return SignatureVerifier.verifyInitializedSignature(signature, signingKey, policy, referenceDate);
    }

    public static void initializeSignatureAndUpdateWithSignedData(PGPSignature signature, InputStream signedData, PGPPublicKey signingKey) throws SignatureValidationException {
        try {
            int read;
            signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), signingKey);
            byte[] buf = new byte[8192];
            byte lastByte = -1;
            while ((read = signedData.read(buf)) != -1) {
                if (lastByte == 10) {
                    signature.update(lastByte);
                }
                if ((lastByte = buf[read - 1]) == 10) {
                    signature.update(buf, 0, read - 1);
                    continue;
                }
                signature.update(buf, 0, read);
            }
        }
        catch (PGPException e) {
            throw new SignatureValidationException("Cannot init signature.", e);
        }
        catch (IOException e) {
            throw new SignatureValidationException("Cannot update signature.", e);
        }
    }

    public static boolean verifyInitializedSignature(PGPSignature signature, PGPPublicKey signingKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        SignatureValidator.wasPossiblyMadeByKey(signingKey).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(referenceDate).verify(signature);
        try {
            if (!signature.verify()) {
                throw new SignatureValidationException("Signature is not correct.");
            }
            return true;
        }
        catch (PGPException e) {
            throw new SignatureValidationException("Could not verify signature correctness.", e);
        }
    }

    public static boolean verifyOnePassSignature(PGPSignature signature, PGPPublicKey signingKey, OnePassSignatureCheck onePassSignature, Policy policy) throws SignatureValidationException {
        try {
            SignatureValidator.wasPossiblyMadeByKey(signingKey).verify(signature);
            SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
            SignatureValidator.signatureIsEffective().verify(signature);
        }
        catch (SignatureValidationException e) {
            throw new SignatureValidationException("Signature is not valid: " + e.getMessage(), e);
        }
        try {
            if (onePassSignature.getSignature() == null) {
                throw new IllegalStateException("No comparison signature provided.");
            }
            if (!onePassSignature.getOnePassSignature().verify(signature)) {
                throw new SignatureValidationException("Bad signature of key " + Long.toHexString(signingKey.getKeyID()));
            }
        }
        catch (PGPException e) {
            throw new SignatureValidationException("Could not verify correctness of One-Pass-Signature: " + e.getMessage(), e);
        }
        return true;
    }

    public static boolean verifySignatureOverUserId(String userId, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date referenceDate) throws SignatureValidationException {
        return SignatureVerifier.verifySignatureOverUserId(userId, signature, primaryKey, primaryKey, policy, referenceDate);
    }
}

