/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.PGPainless;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.Passphrase;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.RevokeKey;
import sop.util.UTF8Util;

public class RevokeKeyImpl
implements RevokeKey {
    private final MatchMakingSecretKeyRingProtector protector = new MatchMakingSecretKeyRingProtector();
    private boolean armor = true;

    @Override
    public RevokeKey noArmor() {
        this.armor = false;
        return this;
    }

    @Override
    public RevokeKey withKeyPassword(byte[] password) throws SOPGPException.UnsupportedOption, SOPGPException.PasswordNotHumanReadable {
        String string;
        try {
            string = UTF8Util.decodeUTF8(password);
        }
        catch (CharacterCodingException e) {
            throw new SOPGPException.PasswordNotHumanReadable("Cannot UTF8-decode password.");
        }
        this.protector.addPassphrase(Passphrase.fromPassword(string));
        return this;
    }

    @Override
    public Ready keys(InputStream keys) throws SOPGPException.BadData {
        PGPSecretKeyRingCollection secretKeyRings;
        try {
            secretKeyRings = KeyReader.readSecretKeys(keys, true);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData("Cannot decode secret keys.", e);
        }
        for (PGPSecretKeyRing secretKeys : secretKeyRings) {
            this.protector.addSecretKey(secretKeys);
        }
        final ArrayList<PGPPublicKeyRing> revocationCertificates = new ArrayList<PGPPublicKeyRing>();
        for (PGPSecretKeyRing secretKeys : secretKeyRings) {
            SecretKeyRingEditorInterface editor = PGPainless.modifyKeyRing(secretKeys);
            try {
                RevocationAttributes revocationAttributes = RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.NO_REASON).withoutDescription();
                if (secretKeys.getPublicKey().getVersion() == 6) {
                    PGPPublicKeyRing revocation = editor.createMinimalRevocationCertificate(this.protector, revocationAttributes);
                    revocationCertificates.add(revocation);
                    continue;
                }
                PGPPublicKeyRing certificate = PGPainless.extractCertificate(secretKeys);
                PGPSignature revocation = editor.createRevocation(this.protector, revocationAttributes);
                certificate = KeyRingUtils.injectCertification(certificate, revocation);
                revocationCertificates.add(certificate);
            }
            catch (WrongPassphraseException e) {
                throw new SOPGPException.KeyIsProtected("Missing or wrong passphrase for key " + OpenPgpFingerprint.of(secretKeys), e);
            }
            catch (PGPException e) {
                throw new RuntimeException("Cannot generate revocation certificate.", e);
            }
        }
        return new Ready(){

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                PGPPublicKeyRingCollection certificateCollection = new PGPPublicKeyRingCollection(revocationCertificates);
                if (RevokeKeyImpl.this.armor) {
                    ArmoredOutputStream out = ArmoredOutputStreamFactory.get(outputStream);
                    certificateCollection.encode(out);
                    out.close();
                } else {
                    certificateCollection.encode(outputStream);
                }
            }
        };
    }
}

