/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.authentication;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.authentication.CertificationChain;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001c\u001a\u00020\rR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/authentication/CertificateAuthenticity;", "", "userId", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "certificationChains", "", "Lorg/pgpainless/authentication/CertificationChain;", "", "targetAmount", "(Ljava/lang/String;Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Ljava/util/Map;I)V", "authenticated", "", "getAuthenticated", "()Z", "authenticityPercentage", "getAuthenticityPercentage", "()I", "getCertificate", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getCertificationChains", "()Ljava/util/Map;", "getTargetAmount", "totalTrustAmount", "getTotalTrustAmount", "getUserId", "()Ljava/lang/String;", "isAuthenticated", "pgpainless-core"})
public final class CertificateAuthenticity {
    @NotNull
    private final String userId;
    @NotNull
    private final PGPPublicKeyRing certificate;
    @NotNull
    private final Map<CertificationChain, Integer> certificationChains;
    private final int targetAmount;

    public CertificateAuthenticity(@NotNull String userId, @NotNull PGPPublicKeyRing certificate, @NotNull Map<CertificationChain, Integer> certificationChains, int targetAmount) {
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        Intrinsics.checkNotNullParameter(certificationChains, "certificationChains");
        this.userId = userId;
        this.certificate = certificate;
        this.certificationChains = certificationChains;
        this.targetAmount = targetAmount;
    }

    @NotNull
    public final String getUserId() {
        return this.userId;
    }

    @NotNull
    public final PGPPublicKeyRing getCertificate() {
        return this.certificate;
    }

    @NotNull
    public final Map<CertificationChain, Integer> getCertificationChains() {
        return this.certificationChains;
    }

    public final int getTargetAmount() {
        return this.targetAmount;
    }

    public final int getTotalTrustAmount() {
        return CollectionsKt.sumOfInt((Iterable<Integer>)this.certificationChains.values());
    }

    public final int getAuthenticityPercentage() {
        return this.targetAmount * 100 / this.getTotalTrustAmount();
    }

    public final boolean getAuthenticated() {
        return this.targetAmount <= this.getTotalTrustAmount();
    }

    public final boolean isAuthenticated() {
        return this.getAuthenticated();
    }
}

