/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.exception.ModificationDetectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/decryption_verification/IntegrityProtectedInputStream;", "Ljava/io/InputStream;", "inputStream", "encryptedData", "Lorg/bouncycastle/openpgp/PGPEncryptedData;", "options", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "(Ljava/io/InputStream;Lorg/bouncycastle/openpgp/PGPEncryptedData;Lorg/pgpainless/decryption_verification/ConsumerOptions;)V", "closed", "", "close", "", "read", "", "b", "", "off", "len", "Companion", "pgpainless-core"})
public final class IntegrityProtectedInputStream
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final PGPEncryptedData encryptedData;
    @NotNull
    private final ConsumerOptions options;
    private boolean closed;
    @NotNull
    private static final Logger LOGGER;

    public IntegrityProtectedInputStream(@NotNull InputStream inputStream, @NotNull PGPEncryptedData encryptedData, @NotNull ConsumerOptions options) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(encryptedData, "encryptedData");
        Intrinsics.checkNotNullParameter(options, "options");
        this.inputStream = inputStream;
        this.encryptedData = encryptedData;
        this.options = options;
    }

    @Override
    public int read() {
        return this.inputStream.read();
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter(b, "b");
        return this.inputStream.read(b, off, len);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.encryptedData.isIntegrityProtected() && !this.options.isIgnoreMDCErrors()) {
            try {
                if (!this.encryptedData.verify()) {
                    throw new ModificationDetectionException();
                }
                LOGGER.debug("Integrity Protection check passed.");
            }
            catch (PGPException e) {
                throw new IOException("Data appears to not be integrity protected.", e);
            }
        }
    }

    @NotNull
    public static final Logger getLOGGER() {
        return Companion.getLOGGER();
    }

    static {
        Logger logger = LoggerFactory.getLogger(IntegrityProtectedInputStream.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(IntegrityProte\u2026dInputStream::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/pgpainless/decryption_verification/IntegrityProtectedInputStream$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER$annotations", "getLOGGER", "()Lorg/slf4j/Logger;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        @JvmStatic
        public static /* synthetic */ void getLOGGER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

