/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.authentication.CertificateAuthority;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.SessionKey;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\bdefghijkB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010Q\u001a\u0004\u0018\u00010RH\u0002J\u0006\u0010S\u001a\u00020\"J*\u0010T\u001a\u00020\"2\u0006\u0010U\u001a\u00020\u001e2\u0006\u0010V\u001a\u00020\"2\u0006\u0010W\u001a\u00020X2\b\b\u0002\u0010Y\u001a\u00020ZH\u0007J\u000e\u0010[\u001a\u00020\"2\u0006\u0010\\\u001a\u00020]J\u000e\u0010^\u001a\u00020\"2\u0006\u0010\\\u001a\u00020]J\u000e\u0010^\u001a\u00020\"2\u0006\u0010_\u001a\u00020`J\u000e\u0010a\u001a\u00020\"2\u0006\u0010\\\u001a\u00020]J\u000e\u0010a\u001a\u00020\"2\u0006\u0010_\u001a\u00020`J\u0006\u0010b\u001a\u00020\"J\u000e\u0010c\u001a\u00020\"2\u0006\u0010\\\u001a\u00020]J\u000e\u0010c\u001a\u00020\"2\u0006\u0010_\u001a\u00020`R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\fR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010$R\u001c\u0010&\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010(\u001a\u0004\b&\u0010$R\u0011\u0010)\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010$R\u0013\u0010*\u001a\u0004\u0018\u00010+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0013\u00100\u001a\u0004\u0018\u000101\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0017\u00104\u001a\b\u0012\u0004\u0012\u000206058F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020:05\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00108R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020:05\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00108R\u001d\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020:050\n8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\fR\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020:058F\u00a2\u0006\u0006\u001a\u0004\bA\u00108R\u0013\u0010B\u001a\u0004\u0018\u00010C8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020C0\n8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\fR\u0017\u0010H\u001a\b\u0012\u0004\u0012\u00020I05\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u00108R\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020I05\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u00108R\u001d\u0010M\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020I050\n8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010\fR\u0017\u0010O\u001a\b\u0012\u0004\u0012\u00020I058F\u00a2\u0006\u0006\u001a\u0004\bP\u00108\u00a8\u0006l"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata;", "", "message", "Lorg/pgpainless/decryption_verification/MessageMetadata$Message;", "(Lorg/pgpainless/decryption_verification/MessageMetadata$Message;)V", "compressionAlgorithm", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "getCompressionAlgorithm", "()Lorg/pgpainless/algorithm/CompressionAlgorithm;", "compressionAlgorithms", "", "getCompressionAlgorithms", "()Ljava/util/Iterator;", "compressionLayers", "Lorg/pgpainless/decryption_verification/MessageMetadata$CompressedData;", "getCompressionLayers", "decryptionKey", "Lorg/pgpainless/key/SubkeyIdentifier;", "getDecryptionKey", "()Lorg/pgpainless/key/SubkeyIdentifier;", "encryptionAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getEncryptionAlgorithm", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "encryptionAlgorithms", "getEncryptionAlgorithms", "encryptionLayers", "Lorg/pgpainless/decryption_verification/MessageMetadata$EncryptedData;", "getEncryptionLayers", "filename", "", "getFilename", "()Ljava/lang/String;", "hasSignature", "", "getHasSignature", "()Z", "isEncrypted", "isForYourEyesOnly", "isForYourEyesOnly$annotations", "()V", "isUsingCleartextSignatureFramework", "literalDataEncoding", "Lorg/pgpainless/algorithm/StreamEncoding;", "getLiteralDataEncoding", "()Lorg/pgpainless/algorithm/StreamEncoding;", "getMessage", "()Lorg/pgpainless/decryption_verification/MessageMetadata$Message;", "modificationDate", "Ljava/util/Date;", "getModificationDate", "()Ljava/util/Date;", "recipientKeyIds", "", "", "getRecipientKeyIds", "()Ljava/util/List;", "rejectedDetachedSignatures", "Lorg/pgpainless/decryption_verification/SignatureVerification$Failure;", "getRejectedDetachedSignatures", "rejectedInlineSignatures", "getRejectedInlineSignatures", "rejectedInlineSignaturesByLayer", "getRejectedInlineSignaturesByLayer", "rejectedSignatures", "getRejectedSignatures", "sessionKey", "Lorg/pgpainless/util/SessionKey;", "getSessionKey", "()Lorg/pgpainless/util/SessionKey;", "sessionKeys", "getSessionKeys", "verifiedDetachedSignatures", "Lorg/pgpainless/decryption_verification/SignatureVerification;", "getVerifiedDetachedSignatures", "verifiedInlineSignatures", "getVerifiedInlineSignatures", "verifiedInlineSignaturesByLayer", "getVerifiedInlineSignaturesByLayer", "verifiedSignatures", "getVerifiedSignatures", "findLiteralData", "Lorg/pgpainless/decryption_verification/MessageMetadata$LiteralData;", "hasRejectedSignatures", "isAuthenticatablySignedBy", "userId", "email", "certificateAuthority", "Lorg/pgpainless/authentication/CertificateAuthority;", "targetAmount", "", "isEncryptedFor", "keys", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "isVerifiedDetachedSignedBy", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "isVerifiedInlineSignedBy", "isVerifiedSigned", "isVerifiedSignedBy", "CompressedData", "EncryptedData", "Layer", "LayerIterator", "LiteralData", "Message", "Nested", "Packet", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nMessageMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageMetadata.kt\norg/pgpainless/decryption_verification/MessageMetadata\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,545:1\n2188#2,7:546\n2188#2,7:553\n1229#2:561\n1230#2:565\n2188#2,7:566\n1#3:560\n1747#4,3:562\n1747#4,3:573\n1747#4,3:576\n1747#4,3:579\n1747#4,3:582\n1747#4,3:585\n1747#4,3:588\n1747#4,3:591\n*S KotlinDebug\n*F\n+ 1 MessageMetadata.kt\norg/pgpainless/decryption_verification/MessageMetadata\n*L\n156#1:546,7\n187#1:553,7\n51#1:561\n51#1:565\n86#1:566,7\n52#1:562,3\n248#1:573,3\n268#1:576,3\n271#1:579,3\n274#1:582,3\n277#1:585,3\n280#1:588,3\n283#1:591,3\n*E\n"})
public final class MessageMetadata {
    @NotNull
    private final Message message;
    @Nullable
    private final CompressionAlgorithm compressionAlgorithm;
    @NotNull
    private final List<SignatureVerification> verifiedInlineSignatures;
    @NotNull
    private final List<SignatureVerification.Failure> rejectedInlineSignatures;
    @NotNull
    private final List<SignatureVerification> verifiedDetachedSignatures;
    @NotNull
    private final List<SignatureVerification.Failure> rejectedDetachedSignatures;
    @Nullable
    private final String filename;
    private final boolean isForYourEyesOnly;
    @Nullable
    private final Date modificationDate;
    @Nullable
    private final StreamEncoding literalDataEncoding;

    /*
     * WARNING - void declaration
     */
    public MessageMetadata(@NotNull Message message2) {
        List signatureVerifications;
        List acc;
        Sequence $this$reduce$iv;
        Intrinsics.checkNotNullParameter(message2, "message");
        this.message = message2;
        this.compressionAlgorithm = SequencesKt.firstOrNull(SequencesKt.asSequence(this.getCompressionAlgorithms()));
        Sequence sequence = SequencesKt.map(SequencesKt.asSequence(this.getVerifiedInlineSignaturesByLayer()), verifiedInlineSignatures.1.INSTANCE);
        MessageMetadata messageMetadata = this;
        boolean $i$f$reduce = false;
        Iterator<Object> iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            List list = (List)iterator$iv.next();
            acc = (List)accumulator$iv;
            boolean bl = false;
            acc.addAll(signatureVerifications);
            accumulator$iv = acc;
        }
        messageMetadata.verifiedInlineSignatures = CollectionsKt.toList((Iterable)accumulator$iv);
        $this$reduce$iv = SequencesKt.map(SequencesKt.asSequence(this.getRejectedInlineSignaturesByLayer()), rejectedInlineSignatures.1.INSTANCE);
        messageMetadata = this;
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void failures;
            signatureVerifications = (List)iterator$iv.next();
            acc = (List)accumulator$iv;
            boolean bl = false;
            acc.addAll((Collection)failures);
            accumulator$iv = acc;
        }
        messageMetadata.rejectedInlineSignatures = CollectionsKt.toList((Iterable)accumulator$iv);
        this.verifiedDetachedSignatures = this.message.getVerifiedDetachedSignatures();
        this.rejectedDetachedSignatures = this.message.getRejectedDetachedSignatures();
        LiteralData literalData = this.findLiteralData();
        this.filename = literalData != null ? literalData.getFileName() : null;
        this.isForYourEyesOnly = Intrinsics.areEqual("_CONSOLE", this.filename);
        LiteralData literalData2 = this.findLiteralData();
        this.modificationDate = literalData2 != null ? literalData2.getModificationDate() : null;
        LiteralData literalData3 = this.findLiteralData();
        this.literalDataEncoding = literalData3 != null ? literalData3.getFormat() : null;
    }

    @NotNull
    public final Message getMessage() {
        return this.message;
    }

    @Nullable
    public final SymmetricKeyAlgorithm getEncryptionAlgorithm() {
        Iterator<SymmetricKeyAlgorithm> it = this.getEncryptionAlgorithms();
        boolean bl = false;
        return it.hasNext() ? it.next() : null;
    }

    @NotNull
    public final Iterator<SymmetricKeyAlgorithm> getEncryptionAlgorithms() {
        return SequencesKt.map(SequencesKt.asSequence(this.getEncryptionLayers()), encryptionAlgorithms.1.INSTANCE).iterator();
    }

    public final boolean isEncrypted() {
        return this.getEncryptionAlgorithm() == null ? false : this.getEncryptionAlgorithm() != SymmetricKeyAlgorithm.NULL;
    }

    public final boolean isEncryptedFor(@NotNull PGPKeyRing keys2) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Sequence<EncryptedData> $this$any$iv = SequencesKt.asSequence(this.getEncryptionLayers());
            boolean $i$f$any = false;
            Iterator<EncryptedData> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl2;
                block4: {
                    EncryptedData element$iv;
                    EncryptedData it = element$iv = iterator2.next();
                    boolean bl3 = false;
                    Iterable $this$any$iv2 = it.getRecipients();
                    boolean $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv2) {
                            long keyId = ((Number)element$iv2).longValue();
                            boolean bl4 = false;
                            if (!(keys2.getPublicKey(keyId) != null)) continue;
                            bl2 = true;
                            break block4;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final SessionKey getSessionKey() {
        return SequencesKt.firstOrNull(SequencesKt.asSequence(this.getSessionKeys()));
    }

    @NotNull
    public final Iterator<SessionKey> getSessionKeys() {
        return SequencesKt.mapNotNull(SequencesKt.asSequence(this.getEncryptionLayers()), sessionKeys.1.INSTANCE).iterator();
    }

    @Nullable
    public final SubkeyIdentifier getDecryptionKey() {
        return (SubkeyIdentifier)SequencesKt.firstOrNull(SequencesKt.mapNotNull(SequencesKt.asSequence(this.getEncryptionLayers()), decryptionKey.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> getRecipientKeyIds() {
        Sequence $this$reduce$iv = SequencesKt.map(SequencesKt.asSequence(this.getEncryptionLayers()), recipientKeyIds.1.INSTANCE);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void keyIds;
            List list = (List)iterator$iv.next();
            List all = (List)accumulator$iv;
            boolean bl = false;
            all.addAll((Collection)keyIds);
            accumulator$iv = all;
        }
        return CollectionsKt.toList((Iterable)accumulator$iv);
    }

    @NotNull
    public final Iterator<EncryptedData> getEncryptionLayers() {
        Message message2 = this.message;
        return new LayerIterator<EncryptedData>(message2){

            public boolean matches(@NotNull Packet layer) {
                Intrinsics.checkNotNullParameter(layer, "layer");
                return layer instanceof EncryptedData;
            }

            @NotNull
            public EncryptedData getProperty(@NotNull Layer last) {
                Intrinsics.checkNotNullParameter(last, "last");
                return (EncryptedData)last;
            }
        };
    }

    @Nullable
    public final CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @NotNull
    public final Iterator<CompressionAlgorithm> getCompressionAlgorithms() {
        return SequencesKt.map(SequencesKt.asSequence(this.getCompressionLayers()), compressionAlgorithms.1.INSTANCE).iterator();
    }

    @NotNull
    public final Iterator<CompressedData> getCompressionLayers() {
        Message message2 = this.message;
        return new LayerIterator<CompressedData>(message2){

            public boolean matches(@NotNull Packet layer) {
                Intrinsics.checkNotNullParameter(layer, "layer");
                return layer instanceof CompressedData;
            }

            @NotNull
            public CompressedData getProperty(@NotNull Layer last) {
                Intrinsics.checkNotNullParameter(last, "last");
                return (CompressedData)last;
            }
        };
    }

    public final boolean isUsingCleartextSignatureFramework() {
        return this.message.getCleartextSigned();
    }

    @NotNull
    public final List<SignatureVerification> getVerifiedSignatures() {
        return CollectionsKt.plus((Collection)this.verifiedInlineSignatures, (Iterable)this.verifiedDetachedSignatures);
    }

    @NotNull
    public final List<SignatureVerification.Failure> getRejectedSignatures() {
        return CollectionsKt.toList(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)new ArrayList(), (Iterable)this.rejectedInlineSignatures), (Iterable)this.rejectedDetachedSignatures));
    }

    @NotNull
    public final List<SignatureVerification> getVerifiedInlineSignatures() {
        return this.verifiedInlineSignatures;
    }

    @NotNull
    public final Iterator<List<SignatureVerification>> getVerifiedInlineSignaturesByLayer() {
        Message message2 = this.message;
        return new LayerIterator<List<? extends SignatureVerification>>(message2){

            public boolean matches(@NotNull Packet layer) {
                Intrinsics.checkNotNullParameter(layer, "layer");
                return layer instanceof Layer;
            }

            @NotNull
            public List<SignatureVerification> getProperty(@NotNull Layer last) {
                Intrinsics.checkNotNullParameter(last, "last");
                return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.emptyList(), (Iterable)last.getVerifiedOnePassSignatures()), (Iterable)last.getVerifiedPrependedSignatures());
            }
        };
    }

    @NotNull
    public final List<SignatureVerification.Failure> getRejectedInlineSignatures() {
        return this.rejectedInlineSignatures;
    }

    @NotNull
    public final Iterator<List<SignatureVerification.Failure>> getRejectedInlineSignaturesByLayer() {
        Message message2 = this.message;
        return new LayerIterator<List<? extends SignatureVerification.Failure>>(message2){

            public boolean matches(@NotNull Packet layer) {
                Intrinsics.checkNotNullParameter(layer, "layer");
                return layer instanceof Layer;
            }

            @NotNull
            public List<SignatureVerification.Failure> getProperty(@NotNull Layer last) {
                Intrinsics.checkNotNullParameter(last, "last");
                return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)new ArrayList<E>(), (Iterable)last.getRejectedOnePassSignatures()), (Iterable)last.getRejectedPrependedSignatures());
            }
        };
    }

    @NotNull
    public final List<SignatureVerification> getVerifiedDetachedSignatures() {
        return this.verifiedDetachedSignatures;
    }

    @NotNull
    public final List<SignatureVerification.Failure> getRejectedDetachedSignatures() {
        return this.rejectedDetachedSignatures;
    }

    public final boolean getHasSignature() {
        return this.isVerifiedSigned() || this.hasRejectedSignatures();
    }

    public final boolean isVerifiedSigned() {
        return !((Collection)this.getVerifiedSignatures()).isEmpty();
    }

    public final boolean hasRejectedSignatures() {
        return !((Collection)this.getRejectedSignatures()).isEmpty();
    }

    @JvmOverloads
    public final boolean isAuthenticatablySignedBy(@NotNull String userId, boolean email, @NotNull CertificateAuthority certificateAuthority, int targetAmount) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(userId, "userId");
            Intrinsics.checkNotNullParameter(certificateAuthority, "certificateAuthority");
            Iterable $this$any$iv = this.getVerifiedSignatures();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SignatureVerification it = (SignatureVerification)element$iv;
                    boolean bl2 = false;
                    OpenPgpFingerprint openPgpFingerprint = it.getSigningKey().getFingerprint();
                    Date date = it.getSignature().getCreationTime();
                    Intrinsics.checkNotNullExpressionValue(date, "it.signature.creationTime");
                    if (!certificateAuthority.authenticateBinding(openPgpFingerprint, userId, email, date, targetAmount).getAuthenticated()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isAuthenticatablySignedBy$default(MessageMetadata messageMetadata, String string, boolean bl, CertificateAuthority certificateAuthority, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 120;
        }
        return messageMetadata.isAuthenticatablySignedBy(string, bl, certificateAuthority, n);
    }

    public final boolean isVerifiedSignedBy(@NotNull OpenPgpFingerprint fingerprint) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
            Iterable $this$any$iv = this.getVerifiedSignatures();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SignatureVerification it = (SignatureVerification)element$iv;
                    boolean bl2 = false;
                    if (!it.getSigningKey().matches(fingerprint)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isVerifiedSignedBy(@NotNull PGPKeyRing keys2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Iterable $this$any$iv = this.getVerifiedSignatures();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SignatureVerification it = (SignatureVerification)element$iv;
                    boolean bl2 = false;
                    if (!PGPKeyRingExtensionsKt.matches(keys2, it.getSigningKey())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isVerifiedDetachedSignedBy(@NotNull OpenPgpFingerprint fingerprint) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
            Iterable $this$any$iv = this.verifiedDetachedSignatures;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SignatureVerification it = (SignatureVerification)element$iv;
                    boolean bl2 = false;
                    if (!it.getSigningKey().matches(fingerprint)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isVerifiedDetachedSignedBy(@NotNull PGPKeyRing keys2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Iterable $this$any$iv = this.verifiedDetachedSignatures;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SignatureVerification it = (SignatureVerification)element$iv;
                    boolean bl2 = false;
                    if (!PGPKeyRingExtensionsKt.matches(keys2, it.getSigningKey())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isVerifiedInlineSignedBy(@NotNull OpenPgpFingerprint fingerprint) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
            Iterable $this$any$iv = this.verifiedInlineSignatures;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SignatureVerification it = (SignatureVerification)element$iv;
                    boolean bl2 = false;
                    if (!it.getSigningKey().matches(fingerprint)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isVerifiedInlineSignedBy(@NotNull PGPKeyRing keys2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Iterable $this$any$iv = this.verifiedInlineSignatures;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SignatureVerification it = (SignatureVerification)element$iv;
                    boolean bl2 = false;
                    if (!PGPKeyRingExtensionsKt.matches(keys2, it.getSigningKey())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final String getFilename() {
        return this.filename;
    }

    public final boolean isForYourEyesOnly() {
        return this.isForYourEyesOnly;
    }

    @Deprecated(message="Reliance on this signaling mechanism is discouraged.")
    public static /* synthetic */ void isForYourEyesOnly$annotations() {
    }

    @Nullable
    public final Date getModificationDate() {
        return this.modificationDate;
    }

    @Nullable
    public final StreamEncoding getLiteralDataEncoding() {
        return this.literalDataEncoding;
    }

    private final LiteralData findLiteralData() {
        Nested nested = this.message.getChild();
        if (nested == null) {
            return null;
        }
        Nested nested2 = nested;
        while (nested2.hasNestedChild()) {
            Nested nested3 = nested2;
            Intrinsics.checkNotNull(nested3, "null cannot be cast to non-null type org.pgpainless.decryption_verification.MessageMetadata.Layer");
            Layer layer = (Layer)((Object)nested3);
            if (layer.getChild() != null) continue;
            boolean bl = false;
            String string = "Malformed OpenPGP message. Cannot find Literal Data Packet";
            throw new IllegalStateException(string.toString());
        }
        Nested nested4 = nested2;
        Intrinsics.checkNotNull(nested4, "null cannot be cast to non-null type org.pgpainless.decryption_verification.MessageMetadata.LiteralData");
        return (LiteralData)nested4;
    }

    @JvmOverloads
    public final boolean isAuthenticatablySignedBy(@NotNull String userId, boolean email, @NotNull CertificateAuthority certificateAuthority) {
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(certificateAuthority, "certificateAuthority");
        return MessageMetadata.isAuthenticatablySignedBy$default(this, userId, email, certificateAuthority, 0, 8, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata$CompressedData;", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "Lorg/pgpainless/decryption_verification/MessageMetadata$Nested;", "algorithm", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "depth", "", "(Lorg/pgpainless/algorithm/CompressionAlgorithm;I)V", "getAlgorithm", "()Lorg/pgpainless/algorithm/CompressionAlgorithm;", "hasNestedChild", "", "pgpainless-core"})
    public static final class CompressedData
    extends Layer
    implements Nested {
        @NotNull
        private final CompressionAlgorithm algorithm;

        public CompressedData(@NotNull CompressionAlgorithm algorithm, int depth) {
            Intrinsics.checkNotNullParameter((Object)algorithm, "algorithm");
            super(depth);
            this.algorithm = algorithm;
        }

        @NotNull
        public final CompressionAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public boolean hasNestedChild() {
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u001b\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata$EncryptedData;", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "Lorg/pgpainless/decryption_verification/MessageMetadata$Nested;", "algorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "depth", "", "(Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;I)V", "getAlgorithm", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "decryptionKey", "Lorg/pgpainless/key/SubkeyIdentifier;", "getDecryptionKey", "()Lorg/pgpainless/key/SubkeyIdentifier;", "setDecryptionKey", "(Lorg/pgpainless/key/SubkeyIdentifier;)V", "recipients", "", "", "getRecipients", "()Ljava/util/List;", "sessionKey", "Lorg/pgpainless/util/SessionKey;", "getSessionKey", "()Lorg/pgpainless/util/SessionKey;", "setSessionKey", "(Lorg/pgpainless/util/SessionKey;)V", "addRecipients", "keyIds", "hasNestedChild", "", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nMessageMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageMetadata.kt\norg/pgpainless/decryption_verification/MessageMetadata$EncryptedData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,545:1\n1#2:546\n*E\n"})
    public static final class EncryptedData
    extends Layer
    implements Nested {
        @NotNull
        private final SymmetricKeyAlgorithm algorithm;
        @Nullable
        private SessionKey sessionKey;
        @NotNull
        private final List<Long> recipients;
        @Nullable
        private SubkeyIdentifier decryptionKey;

        public EncryptedData(@NotNull SymmetricKeyAlgorithm algorithm, int depth) {
            Intrinsics.checkNotNullParameter((Object)algorithm, "algorithm");
            super(depth);
            this.algorithm = algorithm;
            this.recipients = new ArrayList();
        }

        @NotNull
        public final SymmetricKeyAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        @Nullable
        public final SessionKey getSessionKey() {
            return this.sessionKey;
        }

        public final void setSessionKey(@Nullable SessionKey sessionKey) {
            this.sessionKey = sessionKey;
        }

        @NotNull
        public final List<Long> getRecipients() {
            return this.recipients;
        }

        @NotNull
        public final EncryptedData addRecipients(@NotNull List<Long> keyIds) {
            EncryptedData encryptedData;
            Intrinsics.checkNotNullParameter(keyIds, "keyIds");
            EncryptedData $this$addRecipients_u24lambda_u240 = encryptedData = this;
            boolean bl = false;
            List<Long> list = $this$addRecipients_u24lambda_u240.recipients;
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Long>");
            TypeIntrinsics.asMutableList(list).addAll((Collection)keyIds);
            return encryptedData;
        }

        @Nullable
        public final SubkeyIdentifier getDecryptionKey() {
            return this.decryptionKey;
        }

        public final void setDecryptionKey(@Nullable SubkeyIdentifier subkeyIdentifier) {
            this.decryptionKey = subkeyIdentifier;
        }

        @Override
        public boolean hasNestedChild() {
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0017J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0017J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0017R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011\u00a8\u0006&"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "Lorg/pgpainless/decryption_verification/MessageMetadata$Packet;", "depth", "", "(I)V", "child", "Lorg/pgpainless/decryption_verification/MessageMetadata$Nested;", "getChild", "()Lorg/pgpainless/decryption_verification/MessageMetadata$Nested;", "setChild", "(Lorg/pgpainless/decryption_verification/MessageMetadata$Nested;)V", "getDepth", "()I", "rejectedDetachedSignatures", "", "Lorg/pgpainless/decryption_verification/SignatureVerification$Failure;", "getRejectedDetachedSignatures", "()Ljava/util/List;", "rejectedOnePassSignatures", "getRejectedOnePassSignatures", "rejectedPrependedSignatures", "getRejectedPrependedSignatures", "verifiedDetachedSignatures", "Lorg/pgpainless/decryption_verification/SignatureVerification;", "getVerifiedDetachedSignatures", "verifiedOnePassSignatures", "getVerifiedOnePassSignatures", "verifiedPrependedSignatures", "getVerifiedPrependedSignatures", "addRejectedDetachedSignature", "failure", "addRejectedOnePassSignature", "addRejectedPrependedSignature", "addVerifiedDetachedSignature", "signature", "addVerifiedOnePassSignature", "addVerifiedPrependedSignature", "Companion", "pgpainless-core"})
    public static abstract class Layer
    implements Packet {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int depth;
        @NotNull
        private final List<SignatureVerification> verifiedDetachedSignatures;
        @NotNull
        private final List<SignatureVerification.Failure> rejectedDetachedSignatures;
        @NotNull
        private final List<SignatureVerification> verifiedOnePassSignatures;
        @NotNull
        private final List<SignatureVerification.Failure> rejectedOnePassSignatures;
        @NotNull
        private final List<SignatureVerification> verifiedPrependedSignatures;
        @NotNull
        private final List<SignatureVerification.Failure> rejectedPrependedSignatures;
        @Nullable
        private Nested child;
        public static final int MAX_LAYER_DEPTH = 16;

        public Layer(int depth) {
            this.depth = depth;
            if (this.depth > 16) {
                throw new MalformedOpenPgpMessageException("Maximum packet nesting depth (16) exceeded.");
            }
            this.verifiedDetachedSignatures = new ArrayList();
            this.rejectedDetachedSignatures = new ArrayList();
            this.verifiedOnePassSignatures = new ArrayList();
            this.rejectedOnePassSignatures = new ArrayList();
            this.verifiedPrependedSignatures = new ArrayList();
            this.rejectedPrependedSignatures = new ArrayList();
        }

        public final int getDepth() {
            return this.depth;
        }

        @NotNull
        public final List<SignatureVerification> getVerifiedDetachedSignatures() {
            return this.verifiedDetachedSignatures;
        }

        @NotNull
        public final List<SignatureVerification.Failure> getRejectedDetachedSignatures() {
            return this.rejectedDetachedSignatures;
        }

        @NotNull
        public final List<SignatureVerification> getVerifiedOnePassSignatures() {
            return this.verifiedOnePassSignatures;
        }

        @NotNull
        public final List<SignatureVerification.Failure> getRejectedOnePassSignatures() {
            return this.rejectedOnePassSignatures;
        }

        @NotNull
        public final List<SignatureVerification> getVerifiedPrependedSignatures() {
            return this.verifiedPrependedSignatures;
        }

        @NotNull
        public final List<SignatureVerification.Failure> getRejectedPrependedSignatures() {
            return this.rejectedPrependedSignatures;
        }

        @Nullable
        public final Nested getChild() {
            return this.child;
        }

        public final void setChild(@Nullable Nested nested) {
            this.child = nested;
        }

        @NotNull
        public final Layer addVerifiedDetachedSignature(@NotNull SignatureVerification signature) {
            Layer layer;
            Intrinsics.checkNotNullParameter(signature, "signature");
            Layer $this$addVerifiedDetachedSignature_u24lambda_u240 = layer = this;
            boolean bl = false;
            List<SignatureVerification> list = $this$addVerifiedDetachedSignature_u24lambda_u240.verifiedDetachedSignatures;
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<org.pgpainless.decryption_verification.SignatureVerification>");
            TypeIntrinsics.asMutableList(list).add(signature);
            return layer;
        }

        @NotNull
        public final Layer addRejectedDetachedSignature(@NotNull SignatureVerification.Failure failure) {
            Layer layer;
            Intrinsics.checkNotNullParameter(failure, "failure");
            Layer $this$addRejectedDetachedSignature_u24lambda_u241 = layer = this;
            boolean bl = false;
            List<SignatureVerification.Failure> list = $this$addRejectedDetachedSignature_u24lambda_u241.rejectedDetachedSignatures;
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<org.pgpainless.decryption_verification.SignatureVerification.Failure>");
            TypeIntrinsics.asMutableList(list).add(failure);
            return layer;
        }

        @NotNull
        public final Layer addVerifiedOnePassSignature(@NotNull SignatureVerification signature) {
            Layer layer;
            Intrinsics.checkNotNullParameter(signature, "signature");
            Layer $this$addVerifiedOnePassSignature_u24lambda_u242 = layer = this;
            boolean bl = false;
            List<SignatureVerification> list = $this$addVerifiedOnePassSignature_u24lambda_u242.verifiedOnePassSignatures;
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<org.pgpainless.decryption_verification.SignatureVerification>");
            TypeIntrinsics.asMutableList(list).add(signature);
            return layer;
        }

        @NotNull
        public final Layer addRejectedOnePassSignature(@NotNull SignatureVerification.Failure failure) {
            Layer layer;
            Intrinsics.checkNotNullParameter(failure, "failure");
            Layer $this$addRejectedOnePassSignature_u24lambda_u243 = layer = this;
            boolean bl = false;
            List<SignatureVerification.Failure> list = $this$addRejectedOnePassSignature_u24lambda_u243.rejectedOnePassSignatures;
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<org.pgpainless.decryption_verification.SignatureVerification.Failure>");
            TypeIntrinsics.asMutableList(list).add(failure);
            return layer;
        }

        @NotNull
        public final Layer addVerifiedPrependedSignature(@NotNull SignatureVerification signature) {
            Layer layer;
            Intrinsics.checkNotNullParameter(signature, "signature");
            Layer $this$addVerifiedPrependedSignature_u24lambda_u244 = layer = this;
            boolean bl = false;
            List<SignatureVerification> list = $this$addVerifiedPrependedSignature_u24lambda_u244.verifiedPrependedSignatures;
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<org.pgpainless.decryption_verification.SignatureVerification>");
            TypeIntrinsics.asMutableList(list).add(signature);
            return layer;
        }

        @NotNull
        public final Layer addRejectedPrependedSignature(@NotNull SignatureVerification.Failure failure) {
            Layer layer;
            Intrinsics.checkNotNullParameter(failure, "failure");
            Layer $this$addRejectedPrependedSignature_u24lambda_u245 = layer = this;
            boolean bl = false;
            List<SignatureVerification.Failure> list = $this$addRejectedPrependedSignature_u24lambda_u245.rejectedPrependedSignatures;
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<org.pgpainless.decryption_verification.SignatureVerification.Failure>");
            TypeIntrinsics.asMutableList(list).add(failure);
            return layer;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata$Layer$Companion;", "", "()V", "MAX_LAYER_DEPTH", "", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH&J\u000e\u0010\u001b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001cR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0005\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata$LayerIterator;", "O", "", "message", "Lorg/pgpainless/decryption_verification/MessageMetadata$Message;", "(Lorg/pgpainless/decryption_verification/MessageMetadata$Message;)V", "current", "Lorg/pgpainless/decryption_verification/MessageMetadata$Nested;", "last", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "getLast", "()Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "setLast", "(Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;)V", "parent", "getParent", "()Lorg/pgpainless/decryption_verification/MessageMetadata$Message;", "setParent", "findNext", "", "getProperty", "(Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;)Ljava/lang/Object;", "hasNext", "", "matches", "layer", "Lorg/pgpainless/decryption_verification/MessageMetadata$Packet;", "next", "()Ljava/lang/Object;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nMessageMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageMetadata.kt\norg/pgpainless/decryption_verification/MessageMetadata$LayerIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,545:1\n1#2:546\n*E\n"})
    private static abstract class LayerIterator<O>
    implements Iterator<O>,
    KMappedMarker {
        @Nullable
        private Nested current;
        @Nullable
        private Layer last;
        @Nullable
        private Message parent;

        public LayerIterator(@Nonnull @NotNull Message message2) {
            block1: {
                Intrinsics.checkNotNullParameter(message2, "message");
                this.parent = message2;
                Nested nested = this.current = message2.getChild();
                if (nested == null) break block1;
                Nested it = nested;
                boolean bl = false;
                if (this.matches(it)) {
                    Nested nested2 = this.current;
                    Intrinsics.checkNotNull(nested2, "null cannot be cast to non-null type org.pgpainless.decryption_verification.MessageMetadata.Layer");
                    this.last = (Layer)((Object)nested2);
                }
            }
        }

        @Nullable
        public final Layer getLast() {
            return this.last;
        }

        public final void setLast(@Nullable Layer layer) {
            this.last = layer;
        }

        @Nullable
        public final Message getParent() {
            return this.parent;
        }

        public final void setParent(@Nullable Message message2) {
            this.parent = message2;
        }

        @Override
        public boolean hasNext() {
            Message message2 = this.parent;
            if (message2 != null) {
                Message it = message2;
                boolean bl = false;
                if (this.matches(it)) {
                    return true;
                }
            }
            if (this.last == null) {
                this.findNext();
            }
            return this.last != null;
        }

        @Override
        public O next() {
            Layer layer;
            Layer it;
            Message message2 = this.parent;
            if (message2 != null) {
                it = message2;
                boolean bl = false;
                if (this.matches(it)) {
                    O o;
                    O it2 = o = this.getProperty(it);
                    boolean bl2 = false;
                    this.parent = null;
                    return o;
                }
            }
            if (this.last == null) {
                this.findNext();
            }
            if ((layer = this.last) != null) {
                O o;
                it = layer;
                boolean bl = false;
                O it3 = o = this.getProperty(it);
                boolean bl3 = false;
                this.last = null;
                return o;
            }
            throw new NoSuchElementException();
        }

        private final void findNext() {
            while (this.current != null && this.current instanceof Layer) {
                Nested nested = this.current;
                Intrinsics.checkNotNull(nested, "null cannot be cast to non-null type org.pgpainless.decryption_verification.MessageMetadata.Layer");
                this.current = ((Layer)((Object)nested)).getChild();
                if (this.current == null) continue;
                Nested nested2 = this.current;
                Intrinsics.checkNotNull(nested2);
                if (!this.matches(nested2)) continue;
                Nested nested3 = this.current;
                Intrinsics.checkNotNull(nested3, "null cannot be cast to non-null type org.pgpainless.decryption_verification.MessageMetadata.Layer");
                this.last = (Layer)((Object)nested3);
                break;
            }
        }

        public abstract boolean matches(@NotNull Packet var1);

        public abstract O getProperty(@NotNull Layer var1);

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata$LiteralData;", "Lorg/pgpainless/decryption_verification/MessageMetadata$Nested;", "fileName", "", "modificationDate", "Ljava/util/Date;", "format", "Lorg/pgpainless/algorithm/StreamEncoding;", "(Ljava/lang/String;Ljava/util/Date;Lorg/pgpainless/algorithm/StreamEncoding;)V", "getFileName", "()Ljava/lang/String;", "getFormat", "()Lorg/pgpainless/algorithm/StreamEncoding;", "getModificationDate", "()Ljava/util/Date;", "hasNestedChild", "", "pgpainless-core"})
    public static final class LiteralData
    implements Nested {
        @NotNull
        private final String fileName;
        @NotNull
        private final Date modificationDate;
        @NotNull
        private final StreamEncoding format;

        public LiteralData(@NotNull String fileName, @NotNull Date modificationDate, @NotNull StreamEncoding format) {
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            Intrinsics.checkNotNullParameter(modificationDate, "modificationDate");
            Intrinsics.checkNotNullParameter((Object)format, "format");
            this.fileName = fileName;
            this.modificationDate = modificationDate;
            this.format = format;
        }

        public /* synthetic */ LiteralData(String string, Date date, StreamEncoding streamEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                date = new Date(0L);
            }
            if ((n & 4) != 0) {
                streamEncoding = StreamEncoding.BINARY;
            }
            this(string, date, streamEncoding);
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final Date getModificationDate() {
            return this.modificationDate;
        }

        @NotNull
        public final StreamEncoding getFormat() {
            return this.format;
        }

        @Override
        public boolean hasNestedChild() {
            return false;
        }

        public LiteralData() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata$Message;", "Lorg/pgpainless/decryption_verification/MessageMetadata$Layer;", "cleartextSigned", "", "(Z)V", "getCleartextSigned", "()Z", "setCleartextSigned", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nMessageMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageMetadata.kt\norg/pgpainless/decryption_verification/MessageMetadata$Message\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,545:1\n1#2:546\n*E\n"})
    public static final class Message
    extends Layer {
        private boolean cleartextSigned;

        public Message(boolean cleartextSigned) {
            super(0);
            this.cleartextSigned = cleartextSigned;
        }

        public /* synthetic */ Message(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getCleartextSigned() {
            return this.cleartextSigned;
        }

        public final void setCleartextSigned(boolean bl) {
            this.cleartextSigned = bl;
        }

        @NotNull
        public final Message setCleartextSigned() {
            Message message2;
            Message $this$setCleartextSigned_u24lambda_u240 = message2 = this;
            boolean bl = false;
            $this$setCleartextSigned_u24lambda_u240.cleartextSigned = true;
            return message2;
        }

        public Message() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata$Nested;", "Lorg/pgpainless/decryption_verification/MessageMetadata$Packet;", "hasNestedChild", "", "pgpainless-core"})
    public static interface Nested
    extends Packet {
        public boolean hasNestedChild();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lorg/pgpainless/decryption_verification/MessageMetadata$Packet;", "", "pgpainless-core"})
    public static interface Packet {
    }
}

