/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.HashAlgorithmNegotiator;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.exception.KeyException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 92\u00020\u0001:\u00029:B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J:\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001dH\u0007J\u001e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010!\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170#2\u0006\u0010\u001a\u001a\u00020\u001bJ:\u0010$\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J6\u0010$\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J\u001e\u0010$\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010&\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170#2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010'\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J<\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001dH\u0002J \u0010/\u001a\u0002002\u0006\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u00102\u001a\u00020\u00062\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u0006042\u0006\u00105\u001a\u000206H\u0002J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006J\u000e\u00108\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006;"}, d2={"Lorg/pgpainless/encryption_signing/SigningOptions;", "", "()V", "_evaluationDate", "Ljava/util/Date;", "_hashAlgorithmOverride", "Lorg/pgpainless/algorithm/HashAlgorithm;", "evaluationDate", "getEvaluationDate", "()Ljava/util/Date;", "hashAlgorithmOverride", "getHashAlgorithmOverride", "()Lorg/pgpainless/algorithm/HashAlgorithm;", "signingMethods", "", "Lorg/pgpainless/key/SubkeyIdentifier;", "Lorg/pgpainless/encryption_signing/SigningOptions$SigningMethod;", "getSigningMethods", "()Ljava/util/Map;", "addDetachedSignature", "signingKeyProtector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "signingKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "keyId", "", "signatureType", "Lorg/pgpainless/algorithm/DocumentSignatureType;", "subpacketsCallback", "Lorg/pgpainless/signature/subpackets/BaseSignatureSubpackets$Callback;", "userId", "", "subpacketCallback", "addDetachedSignatures", "signingKeys", "", "addInlineSignature", "", "addInlineSignatures", "addSignature", "addSigningMethod", "", "signingSubkey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "hashAlgorithm", "detached", "", "createSignatureGenerator", "Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "privateKey", "negotiateHashAlgorithm", "preferences", "", "policy", "Lorg/pgpainless/policy/Policy;", "overrideHashAlgorithm", "setEvaluationDate", "Companion", "SigningMethod", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nSigningOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SigningOptions.kt\norg/pgpainless/encryption_signing/SigningOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,484:1\n1#2:485\n1855#3,2:486\n1855#3,2:488\n*S KotlinDebug\n*F\n+ 1 SigningOptions.kt\norg/pgpainless/encryption_signing/SigningOptions\n*L\n93#1:486,2\n234#1:488,2\n*E\n"})
public final class SigningOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<SubkeyIdentifier, SigningMethod> signingMethods = new LinkedHashMap();
    @Nullable
    private HashAlgorithm _hashAlgorithmOverride;
    @NotNull
    private Date _evaluationDate = new Date();

    @NotNull
    public final Map<SubkeyIdentifier, SigningMethod> getSigningMethods() {
        return this.signingMethods;
    }

    @Nullable
    public final HashAlgorithm getHashAlgorithmOverride() {
        return this._hashAlgorithmOverride;
    }

    @NotNull
    public final SigningOptions overrideHashAlgorithm(@NotNull HashAlgorithm hashAlgorithmOverride) {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmOverride, "hashAlgorithmOverride");
        SigningOptions $this$overrideHashAlgorithm_u24lambda_u240 = signingOptions = this;
        boolean bl = false;
        $this$overrideHashAlgorithm_u24lambda_u240._hashAlgorithmOverride = hashAlgorithmOverride;
        return signingOptions;
    }

    @NotNull
    public final Date getEvaluationDate() {
        return this._evaluationDate;
    }

    @NotNull
    public final SigningOptions setEvaluationDate(@NotNull Date evaluationDate) {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter(evaluationDate, "evaluationDate");
        SigningOptions $this$setEvaluationDate_u24lambda_u241 = signingOptions = this;
        boolean bl = false;
        $this$setEvaluationDate_u24lambda_u241._evaluationDate = evaluationDate;
        return signingOptions;
    }

    @NotNull
    public final SigningOptions addSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        SigningOptions $this$addSignature_u24lambda_u242 = signingOptions = this;
        boolean bl = false;
        SigningOptions.addInlineSignature$default($this$addSignature_u24lambda_u242, signingKeyProtector, signingKey, null, DocumentSignatureType.BINARY_DOCUMENT, null, 16, null);
        return signingOptions;
    }

    @NotNull
    public final SigningOptions addInlineSignatures(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull Iterable<? extends PGPSecretKeyRing> signingKeys, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKeys, "signingKeys");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        SigningOptions $this$addInlineSignatures_u24lambda_u244 = signingOptions = this;
        boolean bl = false;
        Iterable<? extends PGPSecretKeyRing> $this$forEach$iv = signingKeys;
        boolean $i$f$forEach = false;
        Iterator<? extends PGPSecretKeyRing> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            PGPSecretKeyRing element$iv;
            PGPSecretKeyRing it = element$iv = iterator2.next();
            boolean bl2 = false;
            SigningOptions.addInlineSignature$default($this$addInlineSignatures_u24lambda_u244, signingKeyProtector, it, null, signatureType, null, 16, null);
        }
        return signingOptions;
    }

    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        SigningOptions $this$addInlineSignature_u24lambda_u245 = signingOptions = this;
        boolean bl = false;
        SigningOptions.addInlineSignature$default($this$addInlineSignature_u24lambda_u245, signingKeyProtector, signingKey, null, signatureType, null, 16, null);
        return signingOptions;
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        SigningOptions $this$addInlineSignature_u24lambda_u246 = signingOptions = this;
        boolean bl = false;
        KeyRingInfo keyRingInfo = PGPainless.Companion.inspectKeyRing(signingKey, $this$addInlineSignature_u24lambda_u246.getEvaluationDate());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyException.UnboundUserIdException(OpenPgpFingerprint.Companion.of(signingKey), ((Object)userId).toString(), keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException(OpenPgpFingerprint.Companion.of(signingKey));
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            PGPSecretKey pGPSecretKey = signingKey.getSecretKey(signingPubKey.getKeyID());
            if (pGPSecretKey == null) {
                throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.Companion.of(signingKey), signingPubKey.getKeyID());
            }
            PGPSecretKey signingSecKey = pGPSecretKey;
            PGPPrivateKey signingSubkey = PGPSecretKeyExtensionsKt.unlock(signingSecKey, signingKeyProtector);
            CharSequence charSequence = userId;
            Set<HashAlgorithm> hashAlgorithms = charSequence != null ? keyRingInfo.getPreferredHashAlgorithms(charSequence) : keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = $this$addInlineSignature_u24lambda_u246.negotiateHashAlgorithm(hashAlgorithms, PGPainless.Companion.getPolicy());
            $this$addInlineSignature_u24lambda_u246.addSigningMethod(signingKey, signingSubkey, hashAlgorithm, signatureType, false, subpacketsCallback);
        }
        return signingOptions;
    }

    public static /* synthetic */ SigningOptions addInlineSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, PGPSecretKeyRing pGPSecretKeyRing, CharSequence charSequence, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) throws KeyException, PGPException {
        if ((n & 4) != 0) {
            charSequence = null;
        }
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addInlineSignature(secretKeyRingProtector, pGPSecretKeyRing, charSequence, documentSignatureType, callback2);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        SigningOptions $this$addInlineSignature_u24lambda_u247 = this;
        boolean bl = false;
        KeyRingInfo keyRingInfo = PGPainless.Companion.inspectKeyRing(signingKey, $this$addInlineSignature_u24lambda_u247.getEvaluationDate());
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException(OpenPgpFingerprint.Companion.of(signingKey));
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            if (signingPubKey.getKeyID() != keyId) continue;
            PGPSecretKey pGPSecretKey = signingKey.getSecretKey(signingPubKey.getKeyID());
            if (pGPSecretKey == null) {
                throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.Companion.of(signingKey), signingPubKey.getKeyID());
            }
            PGPSecretKey signingSecKey = pGPSecretKey;
            PGPPrivateKey signingSubkey = PGPSecretKeyExtensionsKt.unlock(signingSecKey, signingKeyProtector);
            Set<HashAlgorithm> hashAlgorithms = keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = $this$addInlineSignature_u24lambda_u247.negotiateHashAlgorithm(hashAlgorithms, PGPainless.Companion.getPolicy());
            $this$addInlineSignature_u24lambda_u247.addSigningMethod(signingKey, signingSubkey, hashAlgorithm, signatureType, false, subpacketsCallback);
            return $this$addInlineSignature_u24lambda_u247;
        }
        throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.Companion.of(signingKey), keyId);
    }

    public static /* synthetic */ SigningOptions addInlineSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, PGPSecretKeyRing pGPSecretKeyRing, long l, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) throws KeyException, PGPException {
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addInlineSignature(secretKeyRingProtector, pGPSecretKeyRing, l, documentSignatureType, callback2);
    }

    @NotNull
    public final SigningOptions addDetachedSignatures(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull Iterable<? extends PGPSecretKeyRing> signingKeys, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKeys, "signingKeys");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        SigningOptions $this$addDetachedSignatures_u24lambda_u249 = signingOptions = this;
        boolean bl = false;
        Iterable<? extends PGPSecretKeyRing> $this$forEach$iv = signingKeys;
        boolean $i$f$forEach = false;
        Iterator<? extends PGPSecretKeyRing> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            PGPSecretKeyRing element$iv;
            PGPSecretKeyRing it = element$iv = iterator2.next();
            boolean bl2 = false;
            SigningOptions.addDetachedSignature$default($this$addDetachedSignatures_u24lambda_u249, signingKeyProtector, it, null, signatureType, null, 16, null);
        }
        return signingOptions;
    }

    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        SigningOptions $this$addDetachedSignature_u24lambda_u2410 = signingOptions = this;
        boolean bl = false;
        SigningOptions.addDetachedSignature$default($this$addDetachedSignature_u24lambda_u2410, signingKeyProtector, signingKey, null, signatureType, null, 16, null);
        return signingOptions;
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable String userId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketCallback) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        SigningOptions $this$addDetachedSignature_u24lambda_u2411 = signingOptions = this;
        boolean bl = false;
        KeyRingInfo keyRingInfo = PGPainless.Companion.inspectKeyRing(signingKey, $this$addDetachedSignature_u24lambda_u2411.getEvaluationDate());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyException.UnboundUserIdException(OpenPgpFingerprint.Companion.of(signingKey), userId.toString(), keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException(OpenPgpFingerprint.Companion.of(signingKey));
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            PGPSecretKey pGPSecretKey = signingKey.getSecretKey(signingPubKey.getKeyID());
            if (pGPSecretKey == null) {
                throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.Companion.of(signingKey), signingPubKey.getKeyID());
            }
            PGPSecretKey signingSecKey = pGPSecretKey;
            PGPPrivateKey signingSubkey = PGPSecretKeyExtensionsKt.unlock(signingSecKey, signingKeyProtector);
            String string = userId;
            Set<HashAlgorithm> hashAlgorithms = string != null ? keyRingInfo.getPreferredHashAlgorithms(string) : keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = $this$addDetachedSignature_u24lambda_u2411.negotiateHashAlgorithm(hashAlgorithms, PGPainless.Companion.getPolicy());
            $this$addDetachedSignature_u24lambda_u2411.addSigningMethod(signingKey, signingSubkey, hashAlgorithm, signatureType, true, subpacketCallback);
        }
        return signingOptions;
    }

    public static /* synthetic */ SigningOptions addDetachedSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, PGPSecretKeyRing pGPSecretKeyRing, String string, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) throws KeyException, PGPException {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addDetachedSignature(secretKeyRingProtector, pGPSecretKeyRing, string, documentSignatureType, callback2);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        SigningOptions $this$addDetachedSignature_u24lambda_u2412 = this;
        boolean bl = false;
        KeyRingInfo keyRingInfo = PGPainless.Companion.inspectKeyRing(signingKey, $this$addDetachedSignature_u24lambda_u2412.getEvaluationDate());
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException(OpenPgpFingerprint.Companion.of(signingKey));
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            if (signingPubKey.getKeyID() != keyId) continue;
            PGPSecretKey pGPSecretKey = signingKey.getSecretKey(signingPubKey.getKeyID());
            if (pGPSecretKey == null) {
                throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.Companion.of(signingKey), signingPubKey.getKeyID());
            }
            PGPSecretKey signingSecKey = pGPSecretKey;
            PGPPrivateKey signingSubkey = PGPSecretKeyExtensionsKt.unlock(signingSecKey, signingKeyProtector);
            Set<HashAlgorithm> hashAlgorithms = keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = $this$addDetachedSignature_u24lambda_u2412.negotiateHashAlgorithm(hashAlgorithms, PGPainless.Companion.getPolicy());
            $this$addDetachedSignature_u24lambda_u2412.addSigningMethod(signingKey, signingSubkey, hashAlgorithm, signatureType, true, subpacketsCallback);
            return $this$addDetachedSignature_u24lambda_u2412;
        }
        throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.Companion.of(signingKey), keyId);
    }

    public static /* synthetic */ SigningOptions addDetachedSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, PGPSecretKeyRing pGPSecretKeyRing, long l, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) throws KeyException, PGPException {
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addDetachedSignature(secretKeyRingProtector, pGPSecretKeyRing, l, documentSignatureType, callback2);
    }

    private final void addSigningMethod(PGPSecretKeyRing signingKey, PGPPrivateKey signingSubkey, HashAlgorithm hashAlgorithm, DocumentSignatureType signatureType, boolean detached, BaseSignatureSubpackets.Callback subpacketCallback) {
        SubkeyIdentifier signingKeyIdentifier = new SubkeyIdentifier((PGPKeyRing)signingKey, signingSubkey.getKeyID());
        PGPSecretKey pGPSecretKey = signingKey.getSecretKey(signingSubkey.getKeyID());
        Intrinsics.checkNotNullExpressionValue(pGPSecretKey, "signingKey.getSecretKey(signingSubkey.keyID)");
        PGPSecretKey signingSecretKey = pGPSecretKey;
        PublicKeyAlgorithm publicKeyAlgorithm = PublicKeyAlgorithm.Companion.requireFromId(signingSecretKey.getPublicKey().getAlgorithm());
        int bitStrength = signingSecretKey.getPublicKey().getBitStrength();
        if (!PGPainless.Companion.getPolicy().getPublicKeyAlgorithmPolicy().isAcceptable(publicKeyAlgorithm, bitStrength)) {
            throw new KeyException.UnacceptableSigningKeyException(new KeyException.PublicKeyAlgorithmPolicyException(OpenPgpFingerprint.Companion.of(signingKey), signingSecretKey.getKeyID(), publicKeyAlgorithm, bitStrength));
        }
        PGPSignatureGenerator generator = this.createSignatureGenerator(signingSubkey, hashAlgorithm, signatureType);
        PGPPublicKey pGPPublicKey = signingSecretKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue(pGPPublicKey, "signingSecretKey.publicKey");
        SignatureSubpackets hashedSubpackets = SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey);
        SignatureSubpackets unhashedSubpackets = SignatureSubpackets.Companion.createEmptySubpackets();
        if (subpacketCallback != null) {
            subpacketCallback.modifyHashedSubpackets((BaseSignatureSubpackets)hashedSubpackets);
            subpacketCallback.modifyUnhashedSubpackets((BaseSignatureSubpackets)unhashedSubpackets);
        }
        generator.setHashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(hashedSubpackets));
        generator.setUnhashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(unhashedSubpackets));
        SigningMethod signingMethod = detached ? SigningMethod.Companion.detachedSignature(generator, hashAlgorithm) : SigningMethod.Companion.inlineSignature(generator, hashAlgorithm);
        Map<SubkeyIdentifier, SigningMethod> map = this.signingMethods;
        Intrinsics.checkNotNull(map, "null cannot be cast to non-null type kotlin.collections.MutableMap<org.pgpainless.key.SubkeyIdentifier, org.pgpainless.encryption_signing.SigningOptions.SigningMethod>");
        TypeIntrinsics.asMutableMap(map).put(signingKeyIdentifier, signingMethod);
    }

    static /* synthetic */ void addSigningMethod$default(SigningOptions signingOptions, PGPSecretKeyRing pGPSecretKeyRing, PGPPrivateKey pGPPrivateKey, HashAlgorithm hashAlgorithm, DocumentSignatureType documentSignatureType, boolean bl, BaseSignatureSubpackets.Callback callback2, int n, Object object) {
        if ((n & 0x20) != 0) {
            callback2 = null;
        }
        signingOptions.addSigningMethod(pGPSecretKeyRing, pGPPrivateKey, hashAlgorithm, documentSignatureType, bl, callback2);
    }

    private final HashAlgorithm negotiateHashAlgorithm(Set<? extends HashAlgorithm> preferences, Policy policy) {
        HashAlgorithm hashAlgorithm = this._hashAlgorithmOverride;
        if (hashAlgorithm == null) {
            hashAlgorithm = HashAlgorithmNegotiator.Companion.negotiateSignatureHashAlgorithm(policy).negotiateHashAlgorithm(preferences);
        }
        return hashAlgorithm;
    }

    private final PGPSignatureGenerator createSignatureGenerator(PGPPrivateKey privateKey, HashAlgorithm hashAlgorithm, DocumentSignatureType signatureType) throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator;
        PGPContentSignerBuilder csb = ImplementationFactory.Companion.getInstance().getPGPContentSignerBuilder(privateKey.getPublicKeyPacket().getAlgorithm(), hashAlgorithm.getAlgorithmId());
        boolean bl = false;
        PGPSignatureGenerator it = pGPSignatureGenerator = new PGPSignatureGenerator(csb);
        boolean bl2 = false;
        it.init(signatureType.getSignatureType().getCode(), privateKey);
        return pGPSignatureGenerator;
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, userId, signatureType, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable CharSequence userId) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, userId, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, null, null, null, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, keyId, signatureType, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, keyId, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable String userId, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, userId, signatureType, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable String userId) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, userId, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, null, null, null, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, keyId, signatureType, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter(signingKeyProtector, "signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, keyId, null, null, 24, null);
    }

    @JvmStatic
    @NotNull
    public static final SigningOptions get() {
        return Companion.get();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/encryption_signing/SigningOptions$Companion;", "", "()V", "get", "Lorg/pgpainless/encryption_signing/SigningOptions;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SigningOptions get() {
            return new SigningOptions();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/encryption_signing/SigningOptions$SigningMethod;", "", "signatureGenerator", "Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "isDetached", "", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "(Lorg/bouncycastle/openpgp/PGPSignatureGenerator;ZLorg/pgpainless/algorithm/HashAlgorithm;)V", "getHashAlgorithm", "()Lorg/pgpainless/algorithm/HashAlgorithm;", "()Z", "getSignatureGenerator", "()Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "Companion", "pgpainless-core"})
    public static final class SigningMethod {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final PGPSignatureGenerator signatureGenerator;
        private final boolean isDetached;
        @NotNull
        private final HashAlgorithm hashAlgorithm;

        private SigningMethod(PGPSignatureGenerator signatureGenerator, boolean isDetached, HashAlgorithm hashAlgorithm) {
            this.signatureGenerator = signatureGenerator;
            this.isDetached = isDetached;
            this.hashAlgorithm = hashAlgorithm;
        }

        @NotNull
        public final PGPSignatureGenerator getSignatureGenerator() {
            return this.signatureGenerator;
        }

        public final boolean isDetached() {
            return this.isDetached;
        }

        @NotNull
        public final HashAlgorithm getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        @JvmStatic
        @NotNull
        public static final SigningMethod inlineSignature(@NotNull PGPSignatureGenerator signatureGenerator, @NotNull HashAlgorithm hashAlgorithm) {
            return Companion.inlineSignature(signatureGenerator, hashAlgorithm);
        }

        @JvmStatic
        @NotNull
        public static final SigningMethod detachedSignature(@NotNull PGPSignatureGenerator signatureGenerator, @NotNull HashAlgorithm hashAlgorithm) {
            return Companion.detachedSignature(signatureGenerator, hashAlgorithm);
        }

        public /* synthetic */ SigningMethod(PGPSignatureGenerator signatureGenerator, boolean isDetached, HashAlgorithm hashAlgorithm, DefaultConstructorMarker $constructor_marker) {
            this(signatureGenerator, isDetached, hashAlgorithm);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/pgpainless/encryption_signing/SigningOptions$SigningMethod$Companion;", "", "()V", "detachedSignature", "Lorg/pgpainless/encryption_signing/SigningOptions$SigningMethod;", "signatureGenerator", "Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "inlineSignature", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final SigningMethod inlineSignature(@NotNull PGPSignatureGenerator signatureGenerator, @NotNull HashAlgorithm hashAlgorithm) {
                Intrinsics.checkNotNullParameter(signatureGenerator, "signatureGenerator");
                Intrinsics.checkNotNullParameter((Object)hashAlgorithm, "hashAlgorithm");
                return new SigningMethod(signatureGenerator, false, hashAlgorithm, null);
            }

            @JvmStatic
            @NotNull
            public final SigningMethod detachedSignature(@NotNull PGPSignatureGenerator signatureGenerator, @NotNull HashAlgorithm hashAlgorithm) {
                Intrinsics.checkNotNullParameter(signatureGenerator, "signatureGenerator");
                Intrinsics.checkNotNullParameter((Object)hashAlgorithm, "hashAlgorithm");
                return new SigningMethod(signatureGenerator, true, hashAlgorithm, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

