/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import openpgp.LongExtensionsKt;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.key.OpenPgpFingerprint;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fB\u0015\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006&"}, d2={"Lorg/pgpainless/key/SubkeyIdentifier;", "", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "(Lorg/pgpainless/key/OpenPgpFingerprint;)V", "keys", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "(Lorg/bouncycastle/openpgp/PGPKeyRing;)V", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "(Lorg/bouncycastle/openpgp/PGPPublicKey;)V", "keyId", "", "(Lorg/bouncycastle/openpgp/PGPKeyRing;J)V", "subkeyFingerprint", "(Lorg/bouncycastle/openpgp/PGPKeyRing;Lorg/pgpainless/key/OpenPgpFingerprint;)V", "primaryKeyFingerprint", "(Lorg/pgpainless/key/OpenPgpFingerprint;Lorg/pgpainless/key/OpenPgpFingerprint;)V", "getFingerprint", "()Lorg/pgpainless/key/OpenPgpFingerprint;", "isPrimaryKey", "", "()Z", "getKeyId", "()J", "getPrimaryKeyFingerprint", "primaryKeyId", "getPrimaryKeyId", "getSubkeyFingerprint", "subkeyId", "getSubkeyId", "equals", "other", "hashCode", "", "matches", "toString", "", "pgpainless-core"})
public final class SubkeyIdentifier {
    @NotNull
    private final OpenPgpFingerprint primaryKeyFingerprint;
    @NotNull
    private final OpenPgpFingerprint subkeyFingerprint;
    private final long keyId;
    @NotNull
    private final OpenPgpFingerprint fingerprint;
    private final long subkeyId;
    private final long primaryKeyId;
    private final boolean isPrimaryKey;

    public SubkeyIdentifier(@NotNull OpenPgpFingerprint primaryKeyFingerprint, @NotNull OpenPgpFingerprint subkeyFingerprint) {
        Intrinsics.checkNotNullParameter(primaryKeyFingerprint, "primaryKeyFingerprint");
        Intrinsics.checkNotNullParameter(subkeyFingerprint, "subkeyFingerprint");
        this.primaryKeyFingerprint = primaryKeyFingerprint;
        this.subkeyFingerprint = subkeyFingerprint;
        this.keyId = this.subkeyFingerprint.getKeyId();
        this.fingerprint = this.subkeyFingerprint;
        this.subkeyId = this.subkeyFingerprint.getKeyId();
        this.primaryKeyId = this.primaryKeyFingerprint.getKeyId();
        this.isPrimaryKey = this.primaryKeyId == this.subkeyId;
    }

    @NotNull
    public final OpenPgpFingerprint getPrimaryKeyFingerprint() {
        return this.primaryKeyFingerprint;
    }

    @NotNull
    public final OpenPgpFingerprint getSubkeyFingerprint() {
        return this.subkeyFingerprint;
    }

    public SubkeyIdentifier(@NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        this(fingerprint, fingerprint);
    }

    public SubkeyIdentifier(@NotNull PGPKeyRing keys2) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        PGPPublicKey pGPPublicKey = keys2.getPublicKey();
        Intrinsics.checkNotNullExpressionValue(pGPPublicKey, "keys.publicKey");
        this(pGPPublicKey);
    }

    public SubkeyIdentifier(@NotNull PGPPublicKey key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        this(OpenPgpFingerprint.Companion.of(key2));
    }

    public SubkeyIdentifier(@NotNull PGPKeyRing keys2, long keyId) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        PGPPublicKey pGPPublicKey = keys2.getPublicKey();
        Intrinsics.checkNotNullExpressionValue(pGPPublicKey, "keys.publicKey");
        PGPPublicKey pGPPublicKey2 = keys2.getPublicKey(keyId);
        if (pGPPublicKey2 == null) {
            throw new NoSuchElementException("OpenPGP key does not contain subkey " + LongExtensionsKt.openPgpKeyId(keyId));
        }
        this(OpenPgpFingerprint.Companion.of(pGPPublicKey), OpenPgpFingerprint.Companion.of(pGPPublicKey2));
    }

    public SubkeyIdentifier(@NotNull PGPKeyRing keys2, @NotNull OpenPgpFingerprint subkeyFingerprint) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        Intrinsics.checkNotNullParameter(subkeyFingerprint, "subkeyFingerprint");
        this(OpenPgpFingerprint.Companion.of(keys2), subkeyFingerprint);
    }

    public final long getKeyId() {
        return this.keyId;
    }

    @NotNull
    public final OpenPgpFingerprint getFingerprint() {
        return this.fingerprint;
    }

    public final long getSubkeyId() {
        return this.subkeyId;
    }

    public final long getPrimaryKeyId() {
        return this.primaryKeyId;
    }

    public final boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public final boolean matches(@NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        return Intrinsics.areEqual(this.primaryKeyFingerprint, fingerprint) || Intrinsics.areEqual(this.subkeyFingerprint, fingerprint);
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof SubkeyIdentifier)) {
            return false;
        }
        return Intrinsics.areEqual(this.primaryKeyFingerprint, ((SubkeyIdentifier)other).primaryKeyFingerprint) && Intrinsics.areEqual(this.subkeyFingerprint, ((SubkeyIdentifier)other).subkeyFingerprint);
    }

    public int hashCode() {
        return this.primaryKeyFingerprint.hashCode() + 31 * this.subkeyFingerprint.hashCode();
    }

    @NotNull
    public String toString() {
        return "" + this.subkeyFingerprint + ' ' + this.primaryKeyFingerprint;
    }
}

