/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.util.encoders.Hex;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.key.OpenPgpFingerprint;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/key/_64DigitFingerprint;", "Lorg/pgpainless/key/OpenPgpFingerprint;", "fingerprint", "", "(Ljava/lang/String;)V", "bytes", "", "([B)V", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "(Lorg/bouncycastle/openpgp/PGPPublicKey;)V", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;)V", "keys", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "(Lorg/bouncycastle/openpgp/PGPKeyRing;)V", "keyId", "", "getKeyId", "()J", "getVersion", "", "isValid", "", "prettyPrint", "toString", "pgpainless-core"})
public class _64DigitFingerprint
extends OpenPgpFingerprint {
    public _64DigitFingerprint(@NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        super(fingerprint);
    }

    public _64DigitFingerprint(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        super(bytes);
    }

    public _64DigitFingerprint(@NotNull PGPPublicKey key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        super(key2);
    }

    public _64DigitFingerprint(@NotNull PGPSecretKey key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        super(key2);
    }

    public _64DigitFingerprint(@NotNull PGPKeyRing keys2) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        super(keys2);
    }

    @Override
    public long getKeyId() {
        String string = this.getFingerprint();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue(charset, "forName(\"UTF-8\")");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] bytes = Hex.decode(byArray);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        Intrinsics.checkNotNull(buf, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)buf).position(0);
        return buf.getLong();
    }

    @Override
    public int getVersion() {
        return -1;
    }

    @Override
    protected boolean isValid(@NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        CharSequence charSequence = fingerprint;
        return new Regex("^[0-9A-F]{64}$").matches(charSequence);
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString();
    }

    @Override
    @NotNull
    public String prettyPrint() {
        int i;
        StringBuilder stringBuilder;
        StringBuilder $this$prettyPrint_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (i = 0; i < 4; ++i) {
            $this$prettyPrint_u24lambda_u240.append(this.getFingerprint(), i * 8, (i + 1) * 8).append(' ');
        }
        $this$prettyPrint_u24lambda_u240.append(' ');
        for (i = 4; i < 7; ++i) {
            $this$prettyPrint_u24lambda_u240.append(this.getFingerprint(), i * 8, (i + 1) * 8).append(' ');
        }
        $this$prettyPrint_u24lambda_u240.append(this.getFingerprint(), 56, 64);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

