/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.certification;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CertificationType;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.Trustworthiness;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.signature.builder.ThirdPartyCertificationSignatureBuilder;
import org.pgpainless.signature.builder.ThirdPartyDirectKeySignatureBuilder;
import org.pgpainless.signature.subpackets.CertificationSubpackets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0006\u000e\u000f\u0010\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0005J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0014"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate;", "", "()V", "certificate", "Lorg/pgpainless/key/certification/CertifyCertificate$DelegationOnCertificate;", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "trustworthiness", "Lorg/pgpainless/algorithm/Trustworthiness;", "userIdOnCertificate", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationOnUserId;", "userId", "", "certificationType", "Lorg/pgpainless/algorithm/CertificationType;", "CertificationOnUserId", "CertificationOnUserIdWithSubpackets", "CertificationResult", "Companion", "DelegationOnCertificate", "DelegationOnCertificateWithSubpackets", "pgpainless-core"})
public final class CertifyCertificate {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CertificationOnUserId userIdOnCertificate(@NotNull String userId, @NotNull PGPPublicKeyRing certificate) {
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        return this.userIdOnCertificate(userId, certificate, CertificationType.GENERIC);
    }

    @NotNull
    public final CertificationOnUserId userIdOnCertificate(@NotNull String userId, @NotNull PGPPublicKeyRing certificate, @NotNull CertificationType certificationType) {
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        Intrinsics.checkNotNullParameter((Object)certificationType, "certificationType");
        return new CertificationOnUserId(userId, certificate, certificationType);
    }

    @NotNull
    public final DelegationOnCertificate certificate(@NotNull PGPPublicKeyRing certificate) {
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        return this.certificate(certificate, null);
    }

    @NotNull
    public final DelegationOnCertificate certificate(@NotNull PGPPublicKeyRing certificate, @Nullable Trustworthiness trustworthiness) {
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        return new DelegationOnCertificate(certificate, trustworthiness);
    }

    @JvmStatic
    private static final PGPSecretKey getCertifyingSecretKey(PGPSecretKeyRing certificationKey) {
        return CertifyCertificate.Companion.getCertifyingSecretKey(certificationKey);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$CertificationOnUserId;", "", "userId", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "certificationType", "Lorg/pgpainless/algorithm/CertificationType;", "(Ljava/lang/String;Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Lorg/pgpainless/algorithm/CertificationType;)V", "getCertificate", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getCertificationType", "()Lorg/pgpainless/algorithm/CertificationType;", "getUserId", "()Ljava/lang/String;", "withKey", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationOnUserIdWithSubpackets;", "certificationKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "pgpainless-core"})
    public static final class CertificationOnUserId {
        @NotNull
        private final String userId;
        @NotNull
        private final PGPPublicKeyRing certificate;
        @NotNull
        private final CertificationType certificationType;

        public CertificationOnUserId(@NotNull String userId, @NotNull PGPPublicKeyRing certificate, @NotNull CertificationType certificationType) {
            Intrinsics.checkNotNullParameter(userId, "userId");
            Intrinsics.checkNotNullParameter(certificate, "certificate");
            Intrinsics.checkNotNullParameter((Object)certificationType, "certificationType");
            this.userId = userId;
            this.certificate = certificate;
            this.certificationType = certificationType;
        }

        @NotNull
        public final String getUserId() {
            return this.userId;
        }

        @NotNull
        public final PGPPublicKeyRing getCertificate() {
            return this.certificate;
        }

        @NotNull
        public final CertificationType getCertificationType() {
            return this.certificationType;
        }

        @NotNull
        public final CertificationOnUserIdWithSubpackets withKey(@NotNull PGPSecretKeyRing certificationKey, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter(certificationKey, "certificationKey");
            Intrinsics.checkNotNullParameter(protector, "protector");
            PGPSecretKey secretKey = Companion.getCertifyingSecretKey(certificationKey);
            ThirdPartyCertificationSignatureBuilder sigBuilder = new ThirdPartyCertificationSignatureBuilder(this.certificationType.asSignatureType(), secretKey, protector);
            return new CertificationOnUserIdWithSubpackets(this.certificate, this.userId, sigBuilder);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$CertificationOnUserIdWithSubpackets;", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "userId", "", "sigBuilder", "Lorg/pgpainless/signature/builder/ThirdPartyCertificationSignatureBuilder;", "(Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Ljava/lang/String;Lorg/pgpainless/signature/builder/ThirdPartyCertificationSignatureBuilder;)V", "getCertificate", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getSigBuilder", "()Lorg/pgpainless/signature/builder/ThirdPartyCertificationSignatureBuilder;", "getUserId", "()Ljava/lang/String;", "build", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationResult;", "buildWithSubpackets", "subpacketCallback", "Lorg/pgpainless/signature/subpackets/CertificationSubpackets$Callback;", "pgpainless-core"})
    public static final class CertificationOnUserIdWithSubpackets {
        @NotNull
        private final PGPPublicKeyRing certificate;
        @NotNull
        private final String userId;
        @NotNull
        private final ThirdPartyCertificationSignatureBuilder sigBuilder;

        public CertificationOnUserIdWithSubpackets(@NotNull PGPPublicKeyRing certificate, @NotNull String userId, @NotNull ThirdPartyCertificationSignatureBuilder sigBuilder) {
            Intrinsics.checkNotNullParameter(certificate, "certificate");
            Intrinsics.checkNotNullParameter(userId, "userId");
            Intrinsics.checkNotNullParameter(sigBuilder, "sigBuilder");
            this.certificate = certificate;
            this.userId = userId;
            this.sigBuilder = sigBuilder;
        }

        @NotNull
        public final PGPPublicKeyRing getCertificate() {
            return this.certificate;
        }

        @NotNull
        public final String getUserId() {
            return this.userId;
        }

        @NotNull
        public final ThirdPartyCertificationSignatureBuilder getSigBuilder() {
            return this.sigBuilder;
        }

        @NotNull
        public final CertificationResult buildWithSubpackets(@NotNull CertificationSubpackets.Callback subpacketCallback) {
            Intrinsics.checkNotNullParameter(subpacketCallback, "subpacketCallback");
            this.sigBuilder.applyCallback(subpacketCallback);
            return this.build();
        }

        @NotNull
        public final CertificationResult build() {
            PGPSignature signature = this.sigBuilder.build(this.certificate, this.userId);
            PGPPublicKeyRing certifiedCertificate = (PGPPublicKeyRing)KeyRingUtils.Companion.injectCertification((PGPKeyRing)this.certificate, this.userId, signature);
            return new CertificationResult(certifiedCertificate, signature);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$CertificationResult;", "", "certifiedCertificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "certification", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Lorg/bouncycastle/openpgp/PGPSignature;)V", "getCertification", "()Lorg/bouncycastle/openpgp/PGPSignature;", "getCertifiedCertificate", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "pgpainless-core"})
    public static final class CertificationResult {
        @NotNull
        private final PGPPublicKeyRing certifiedCertificate;
        @NotNull
        private final PGPSignature certification;

        public CertificationResult(@NotNull PGPPublicKeyRing certifiedCertificate, @NotNull PGPSignature certification) {
            Intrinsics.checkNotNullParameter(certifiedCertificate, "certifiedCertificate");
            Intrinsics.checkNotNullParameter(certification, "certification");
            this.certifiedCertificate = certifiedCertificate;
            this.certification = certification;
        }

        @NotNull
        public final PGPPublicKeyRing getCertifiedCertificate() {
            return this.certifiedCertificate;
        }

        @NotNull
        public final PGPSignature getCertification() {
            return this.certification;
        }

        @NotNull
        public final PGPPublicKeyRing component1() {
            return this.certifiedCertificate;
        }

        @NotNull
        public final PGPSignature component2() {
            return this.certification;
        }

        @NotNull
        public final CertificationResult copy(@NotNull PGPPublicKeyRing certifiedCertificate, @NotNull PGPSignature certification) {
            Intrinsics.checkNotNullParameter(certifiedCertificate, "certifiedCertificate");
            Intrinsics.checkNotNullParameter(certification, "certification");
            return new CertificationResult(certifiedCertificate, certification);
        }

        public static /* synthetic */ CertificationResult copy$default(CertificationResult certificationResult, PGPPublicKeyRing pGPPublicKeyRing, PGPSignature pGPSignature, int n, Object object) {
            if ((n & 1) != 0) {
                pGPPublicKeyRing = certificationResult.certifiedCertificate;
            }
            if ((n & 2) != 0) {
                pGPSignature = certificationResult.certification;
            }
            return certificationResult.copy(pGPPublicKeyRing, pGPSignature);
        }

        @NotNull
        public String toString() {
            return "CertificationResult(certifiedCertificate=" + this.certifiedCertificate + ", certification=" + this.certification + ')';
        }

        public int hashCode() {
            int result = this.certifiedCertificate.hashCode();
            result = result * 31 + this.certification.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CertificationResult)) {
                return false;
            }
            CertificationResult certificationResult = (CertificationResult)other;
            if (!Intrinsics.areEqual(this.certifiedCertificate, certificationResult.certifiedCertificate)) {
                return false;
            }
            return Intrinsics.areEqual(this.certification, certificationResult.certification);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$Companion;", "", "()V", "getCertifyingSecretKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "certificationKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nCertifyCertificate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertifyCertificate.kt\norg/pgpainless/key/certification/CertifyCertificate$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final PGPSecretKey getCertifyingSecretKey(PGPSecretKeyRing certificationKey) {
            OpenPgpFingerprint fingerprint;
            Date now = new Date();
            KeyRingInfo info = PGPainless.Companion.inspectKeyRing(certificationKey, now);
            PGPPublicKey certificationPubKey = info.getPublicKey(fingerprint = info.getFingerprint());
            if (certificationPubKey == null) {
                boolean $i$a$-requireNotNull-CertifyCertificate$Companion$getCertifyingSecretKey$22 = false;
                String $i$a$-requireNotNull-CertifyCertificate$Companion$getCertifyingSecretKey$22 = "Primary key cannot be null.";
                throw new IllegalArgumentException($i$a$-requireNotNull-CertifyCertificate$Companion$getCertifyingSecretKey$22.toString());
            }
            if (!info.isKeyValidlyBound(certificationPubKey.getKeyID())) {
                throw new KeyException.RevokedKeyException(fingerprint);
            }
            if (!info.isUsableForThirdPartyCertification()) {
                throw new KeyException.UnacceptableThirdPartyCertificationKeyException(fingerprint);
            }
            Date expirationDate = info.getExpirationDateForUse(KeyFlag.CERTIFY_OTHER);
            if (expirationDate != null && expirationDate.compareTo(now) < 0) {
                throw new KeyException.ExpiredKeyException(fingerprint, expirationDate);
            }
            PGPSecretKey pGPSecretKey = certificationKey.getSecretKey(certificationPubKey.getKeyID());
            if (pGPSecretKey == null) {
                throw new KeyException.MissingSecretKeyException(fingerprint, certificationPubKey.getKeyID());
            }
            return pGPSecretKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$DelegationOnCertificate;", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "trustworthiness", "Lorg/pgpainless/algorithm/Trustworthiness;", "(Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Lorg/pgpainless/algorithm/Trustworthiness;)V", "getCertificate", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getTrustworthiness", "()Lorg/pgpainless/algorithm/Trustworthiness;", "withKey", "Lorg/pgpainless/key/certification/CertifyCertificate$DelegationOnCertificateWithSubpackets;", "certificationKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "pgpainless-core"})
    public static final class DelegationOnCertificate {
        @NotNull
        private final PGPPublicKeyRing certificate;
        @Nullable
        private final Trustworthiness trustworthiness;

        public DelegationOnCertificate(@NotNull PGPPublicKeyRing certificate, @Nullable Trustworthiness trustworthiness) {
            Intrinsics.checkNotNullParameter(certificate, "certificate");
            this.certificate = certificate;
            this.trustworthiness = trustworthiness;
        }

        @NotNull
        public final PGPPublicKeyRing getCertificate() {
            return this.certificate;
        }

        @Nullable
        public final Trustworthiness getTrustworthiness() {
            return this.trustworthiness;
        }

        @NotNull
        public final DelegationOnCertificateWithSubpackets withKey(@NotNull PGPSecretKeyRing certificationKey, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter(certificationKey, "certificationKey");
            Intrinsics.checkNotNullParameter(protector, "protector");
            PGPSecretKey secretKey = Companion.getCertifyingSecretKey(certificationKey);
            ThirdPartyDirectKeySignatureBuilder sigBuilder = new ThirdPartyDirectKeySignatureBuilder(secretKey, protector);
            if (this.trustworthiness != null) {
                sigBuilder.getHashedSubpackets().setTrust(true, this.trustworthiness.getDepth(), this.trustworthiness.getAmount());
            }
            return new DelegationOnCertificateWithSubpackets(this.certificate, sigBuilder);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$DelegationOnCertificateWithSubpackets;", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "sigBuilder", "Lorg/pgpainless/signature/builder/ThirdPartyDirectKeySignatureBuilder;", "(Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Lorg/pgpainless/signature/builder/ThirdPartyDirectKeySignatureBuilder;)V", "getCertificate", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getSigBuilder", "()Lorg/pgpainless/signature/builder/ThirdPartyDirectKeySignatureBuilder;", "build", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationResult;", "buildWithSubpackets", "subpacketsCallback", "Lorg/pgpainless/signature/subpackets/CertificationSubpackets$Callback;", "pgpainless-core"})
    public static final class DelegationOnCertificateWithSubpackets {
        @NotNull
        private final PGPPublicKeyRing certificate;
        @NotNull
        private final ThirdPartyDirectKeySignatureBuilder sigBuilder;

        public DelegationOnCertificateWithSubpackets(@NotNull PGPPublicKeyRing certificate, @NotNull ThirdPartyDirectKeySignatureBuilder sigBuilder) {
            Intrinsics.checkNotNullParameter(certificate, "certificate");
            Intrinsics.checkNotNullParameter(sigBuilder, "sigBuilder");
            this.certificate = certificate;
            this.sigBuilder = sigBuilder;
        }

        @NotNull
        public final PGPPublicKeyRing getCertificate() {
            return this.certificate;
        }

        @NotNull
        public final ThirdPartyDirectKeySignatureBuilder getSigBuilder() {
            return this.sigBuilder;
        }

        @NotNull
        public final CertificationResult buildWithSubpackets(@NotNull CertificationSubpackets.Callback subpacketsCallback) {
            Intrinsics.checkNotNullParameter(subpacketsCallback, "subpacketsCallback");
            this.sigBuilder.applyCallback(subpacketsCallback);
            return this.build();
        }

        @NotNull
        public final CertificationResult build() {
            PGPPublicKey delegatedKey = this.certificate.getPublicKey();
            Intrinsics.checkNotNullExpressionValue(delegatedKey, "delegatedKey");
            PGPSignature delegation = this.sigBuilder.build(delegatedKey);
            PGPPublicKeyRing delegatedCertificate = (PGPPublicKeyRing)KeyRingUtils.Companion.injectCertification((PGPKeyRing)this.certificate, delegatedKey, delegation);
            return new CertificationResult(delegatedCertificate, delegation);
        }
    }
}

