/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/key/protection/BaseSecretKeyRingProtector;", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "passphraseProvider", "Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;", "(Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;)V", "protectionSettings", "Lorg/pgpainless/key/protection/KeyRingProtectionSettings;", "(Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;Lorg/pgpainless/key/protection/KeyRingProtectionSettings;)V", "getDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "keyId", "", "getEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "hasPassphraseFor", "", "pgpainless-core"})
public class BaseSecretKeyRingProtector
implements SecretKeyRingProtector {
    @NotNull
    private final SecretKeyPassphraseProvider passphraseProvider;
    @NotNull
    private final KeyRingProtectionSettings protectionSettings;

    public BaseSecretKeyRingProtector(@NotNull SecretKeyPassphraseProvider passphraseProvider, @NotNull KeyRingProtectionSettings protectionSettings) {
        Intrinsics.checkNotNullParameter(passphraseProvider, "passphraseProvider");
        Intrinsics.checkNotNullParameter(protectionSettings, "protectionSettings");
        this.passphraseProvider = passphraseProvider;
        this.protectionSettings = protectionSettings;
    }

    public BaseSecretKeyRingProtector(@NotNull SecretKeyPassphraseProvider passphraseProvider) {
        Intrinsics.checkNotNullParameter(passphraseProvider, "passphraseProvider");
        this(passphraseProvider, KeyRingProtectionSettings.Companion.secureDefaultSettings());
    }

    @Override
    public boolean hasPassphraseFor(long keyId) {
        return this.passphraseProvider.hasPassphrase(keyId);
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(long keyId) {
        PBESecretKeyDecryptor pBESecretKeyDecryptor;
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        if (passphrase != null) {
            Passphrase it = passphrase;
            boolean bl = false;
            pBESecretKeyDecryptor = it.isEmpty() ? null : ImplementationFactory.Companion.getInstance().getPBESecretKeyDecryptor(it);
        } else {
            pBESecretKeyDecryptor = null;
        }
        return pBESecretKeyDecryptor;
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(long keyId) {
        PBESecretKeyEncryptor pBESecretKeyEncryptor;
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        if (passphrase != null) {
            Passphrase it = passphrase;
            boolean bl = false;
            pBESecretKeyEncryptor = it.isEmpty() ? null : ImplementationFactory.Companion.getInstance().getPBESecretKeyEncryptor(this.protectionSettings.getEncryptionAlgorithm(), this.protectionSettings.getHashAlgorithm(), this.protectionSettings.getS2kCount(), it);
        } else {
            pBESecretKeyEncryptor = null;
        }
        return pBESecretKeyEncryptor;
    }
}

