/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.key.protection.BaseSecretKeyRingProtector;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.key.protection.passphrase_provider.SolitaryPassphraseProvider;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u0000 \n2\u00020\u0001:\u0001\nJ\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "", "getDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "keyId", "", "getEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "hasPassphraseFor", "", "Companion", "pgpainless-core"})
public interface SecretKeyRingProtector {
    @NotNull
    public static final Companion Companion = org.pgpainless.key.protection.SecretKeyRingProtector$Companion.$$INSTANCE;

    public boolean hasPassphraseFor(long var1);

    @Nullable
    public PBESecretKeyDecryptor getDecryptor(long var1) throws PGPException;

    @Nullable
    public PBESecretKeyEncryptor getEncryptor(long var1) throws PGPException;

    @JvmStatic
    @NotNull
    public static CachingSecretKeyRingProtector defaultSecretKeyRingProtector(@Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
        return Companion.defaultSecretKeyRingProtector(missingPassphraseCallback);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockEachKeyWith(@NotNull Passphrase passphrase, @NotNull PGPSecretKeyRing keys2) {
        return Companion.unlockEachKeyWith(passphrase, keys2);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockAnyKeyWith(@NotNull Passphrase passphrase) {
        return Companion.unlockAnyKeyWith(passphrase);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, @NotNull PGPSecretKey key2) {
        return Companion.unlockSingleKeyWith(passphrase, key2);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, long keyId) {
        return Companion.unlockSingleKeyWith(passphrase, keyId);
    }

    @JvmStatic
    @NotNull
    public static UnprotectedKeysProtector unprotectedKeys() {
        return Companion.unprotectedKeys();
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector fromPassphraseMap(@NotNull Map<Long, Passphrase> passphraseMap) {
        return Companion.fromPassphraseMap(passphraseMap);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0007J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0007\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/key/protection/SecretKeyRingProtector$Companion;", "", "()V", "defaultSecretKeyRingProtector", "Lorg/pgpainless/key/protection/CachingSecretKeyRingProtector;", "missingPassphraseCallback", "Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;", "fromPassphraseMap", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "passphraseMap", "", "", "Lorg/pgpainless/util/Passphrase;", "unlockAnyKeyWith", "passphrase", "unlockEachKeyWith", "keys", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "unlockSingleKeyWith", "keyId", "key", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "unprotectedKeys", "Lorg/pgpainless/key/protection/UnprotectedKeysProtector;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nSecretKeyRingProtector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecretKeyRingProtector.kt\norg/pgpainless/key/protection/SecretKeyRingProtector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1549#2:158\n1620#2,3:159\n1271#2,2:162\n1285#2,4:164\n*S KotlinDebug\n*F\n+ 1 SecretKeyRingProtector.kt\norg/pgpainless/key/protection/SecretKeyRingProtector$Companion\n*L\n90#1:158\n90#1:159,3\n90#1:162,2\n90#1:164,4\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CachingSecretKeyRingProtector defaultSecretKeyRingProtector(@Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
            return new CachingSecretKeyRingProtector(MapsKt.emptyMap(), KeyRingProtectionSettings.Companion.secureDefaultSettings(), missingPassphraseCallback);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockEachKeyWith(@NotNull Passphrase passphrase, @NotNull PGPSecretKeyRing keys2) {
            void $this$associateWith$iv;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(passphrase, "passphrase");
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Iterable iterable = keys2;
            Companion companion = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PGPSecretKey pGPSecretKey = (PGPSecretKey)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getKeyID());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                long it = ((Number)element$iv$iv).longValue();
                Object t = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                Passphrase passphrase2 = passphrase;
                object.put(t, passphrase2);
            }
            return companion.fromPassphraseMap(result$iv);
        }

        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockAnyKeyWith(@NotNull Passphrase passphrase) {
            Intrinsics.checkNotNullParameter(passphrase, "passphrase");
            return new BaseSecretKeyRingProtector(new SolitaryPassphraseProvider(passphrase));
        }

        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, @NotNull PGPSecretKey key2) {
            Intrinsics.checkNotNullParameter(passphrase, "passphrase");
            Intrinsics.checkNotNullParameter(key2, "key");
            return PasswordBasedSecretKeyRingProtector.Companion.forKey(key2, passphrase);
        }

        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, long keyId) {
            Intrinsics.checkNotNullParameter(passphrase, "passphrase");
            return PasswordBasedSecretKeyRingProtector.Companion.forKeyId(keyId, passphrase);
        }

        @JvmStatic
        @NotNull
        public final UnprotectedKeysProtector unprotectedKeys() {
            return new UnprotectedKeysProtector();
        }

        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector fromPassphraseMap(@NotNull Map<Long, Passphrase> passphraseMap) {
            Intrinsics.checkNotNullParameter(passphraseMap, "passphraseMap");
            return new CachingSecretKeyRingProtector(passphraseMap, KeyRingProtectionSettings.Companion.secureDefaultSettings(), null);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

