/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.CertificationSubpackets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0016\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/pgpainless/signature/builder/ThirdPartyCertificationSignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signingKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "signatureType", "Lorg/pgpainless/algorithm/SignatureType;", "(Lorg/pgpainless/algorithm/SignatureType;Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "archetypeSignature", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/bouncycastle/openpgp/PGPSignature;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/CertificationSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/CertificationSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/CertificationSubpackets$Callback;", "build", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "userId", "", "userAttribute", "Lorg/bouncycastle/openpgp/PGPUserAttributeSubpacketVector;", "pgpainless-core"})
public final class ThirdPartyCertificationSignatureBuilder
extends AbstractSignatureBuilder<ThirdPartyCertificationSignatureBuilder> {
    @NotNull
    private final CertificationSubpackets hashedSubpackets;
    @NotNull
    private final CertificationSubpackets unhashedSubpackets;

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return ThirdPartyCertificationSignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    public ThirdPartyCertificationSignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter(protector, "protector");
        super(SignatureType.GENERIC_CERTIFICATION, signingKey, protector);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public ThirdPartyCertificationSignatureBuilder(@NotNull SignatureType signatureType, @NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter(protector, "protector");
        super(signatureType, signingKey, protector);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public ThirdPartyCertificationSignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPSignature archetypeSignature) throws PGPException {
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter(protector, "protector");
        Intrinsics.checkNotNullParameter(archetypeSignature, "archetypeSignature");
        super(signingKey, protector, archetypeSignature);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    @NotNull
    public final CertificationSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final CertificationSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final ThirdPartyCertificationSignatureBuilder applyCallback(@Nullable CertificationSubpackets.Callback callback2) {
        ThirdPartyCertificationSignatureBuilder thirdPartyCertificationSignatureBuilder;
        block0: {
            ThirdPartyCertificationSignatureBuilder $this$applyCallback_u24lambda_u242 = thirdPartyCertificationSignatureBuilder = this;
            boolean bl = false;
            CertificationSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            CertificationSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.unhashedSubpackets);
        }
        return thirdPartyCertificationSignatureBuilder;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPPublicKeyRing certificate, @NotNull CharSequence userId) throws PGPException {
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        Intrinsics.checkNotNullParameter(userId, "userId");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(((Object)userId).toString(), certificate.getPublicKey());
        Intrinsics.checkNotNullExpressionValue(pGPSignature, "buildAndInitSignatureGen\u2026), certificate.publicKey)");
        return pGPSignature;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPPublicKeyRing certificate, @NotNull PGPUserAttributeSubpacketVector userAttribute) throws PGPException {
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        Intrinsics.checkNotNullParameter(userAttribute, "userAttribute");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(userAttribute, certificate.getPublicKey());
        Intrinsics.checkNotNullExpressionValue(pGPSignature, "buildAndInitSignatureGen\u2026e, certificate.publicKey)");
        return pGPSignature;
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.GENERIC_CERTIFICATION, SignatureType.NO_CERTIFICATION, SignatureType.CASUAL_CERTIFICATION, SignatureType.POSITIVE_CERTIFICATION};
        return CollectionsKt.listOf(signatureTypeArray).contains((Object)it);
    }
}

