/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.consumer;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSignatureExtensionsKt;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.consumer.SignatureCreationDateComparator;
import org.pgpainless.signature.consumer.SignatureValidator;
import org.pgpainless.signature.consumer.SignatureVerifier;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/signature/consumer/SignaturePicker;", "", "()V", "Companion", "pgpainless-core"})
public final class SignaturePicker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final PGPSignature pickCurrentRevocationSelfSignature(@NotNull PGPKeyRing keyRing, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickCurrentRevocationSelfSignature(keyRing, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickCurrentDirectKeySelfSignature(@NotNull PGPKeyRing keyRing, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickCurrentDirectKeySelfSignature(keyRing, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickCurrentDirectKeySignature(@NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey signedKey, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickCurrentDirectKeySignature(signingKey, signedKey, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickLatestDirectKeySignature(@NotNull PGPKeyRing keyRing, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickLatestDirectKeySignature(keyRing, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickLatestDirectKeySignature(@NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey signedKey, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickLatestDirectKeySignature(signingKey, signedKey, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickCurrentUserIdRevocationSignature(@NotNull PGPKeyRing keyRing, @NotNull CharSequence userId, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickCurrentUserIdRevocationSignature(keyRing, userId, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickCurrentUserIdCertificationSignature(@NotNull PGPKeyRing keyRing, @NotNull CharSequence userId, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickCurrentUserIdCertificationSignature(keyRing, userId, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickLatestUserIdCertificationSignature(@NotNull PGPKeyRing keyRing, @NotNull CharSequence userId, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickLatestUserIdCertificationSignature(keyRing, userId, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickCurrentSubkeyBindingRevocationSignature(@NotNull PGPKeyRing keyRing, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickCurrentSubkeyBindingRevocationSignature(keyRing, subkey, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickCurrentSubkeyBindingSignature(@NotNull PGPKeyRing keyRing, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickCurrentSubkeyBindingSignature(keyRing, subkey, policy, referenceTime);
    }

    @JvmStatic
    @Nullable
    public static final PGPSignature pickLatestSubkeyBindingSignature(@NotNull PGPKeyRing keyRing, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.pickLatestSubkeyBindingSignature(keyRing, subkey, policy, referenceTime);
    }

    @JvmStatic
    private static final List<PGPSignature> getSortedSignaturesOfType(PGPPublicKey key2, SignatureType type) {
        return SignaturePicker.Companion.getSortedSignaturesOfType(key2, type);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J\"\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/signature/consumer/SignaturePicker$Companion;", "", "()V", "getSortedSignaturesOfType", "", "Lorg/bouncycastle/openpgp/PGPSignature;", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "type", "Lorg/pgpainless/algorithm/SignatureType;", "pickCurrentDirectKeySelfSignature", "keyRing", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "policy", "Lorg/pgpainless/policy/Policy;", "referenceTime", "Ljava/util/Date;", "pickCurrentDirectKeySignature", "signingKey", "signedKey", "pickCurrentRevocationSelfSignature", "pickCurrentSubkeyBindingRevocationSignature", "subkey", "pickCurrentSubkeyBindingSignature", "pickCurrentUserIdCertificationSignature", "userId", "", "pickCurrentUserIdRevocationSignature", "pickLatestDirectKeySignature", "pickLatestSubkeyBindingSignature", "pickLatestUserIdCertificationSignature", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nSignaturePicker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignaturePicker.kt\norg/pgpainless/signature/consumer/SignaturePicker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,384:1\n533#2,6:385\n533#2,6:391\n533#2,6:397\n533#2,6:403\n533#2,6:423\n533#2,6:429\n533#2,6:435\n316#3,7:409\n316#3,7:416\n*S KotlinDebug\n*F\n+ 1 SignaturePicker.kt\norg/pgpainless/signature/consumer/SignaturePicker$Companion\n*L\n48#1:385,6\n85#1:391,6\n137#1:397,6\n174#1:403,6\n285#1:423,6\n318#1:429,6\n353#1:435,6\n210#1:409,7\n246#1:416,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final PGPSignature pickCurrentRevocationSelfSignature(@NotNull PGPKeyRing keyRing, @NotNull Policy policy, @NotNull Date referenceTime) {
            PGPSignature pGPSignature;
            block3: {
                Intrinsics.checkNotNullParameter(keyRing, "keyRing");
                Intrinsics.checkNotNullParameter(policy, "policy");
                Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
                PGPPublicKey primaryKey = keyRing.getPublicKey();
                Intrinsics.checkNotNullExpressionValue(primaryKey, "primaryKey");
                List<PGPSignature> $this$lastOrNull$iv = this.getSortedSignaturesOfType(primaryKey, SignatureType.KEY_REVOCATION);
                boolean $i$f$lastOrNull = false;
                ListIterator<PGPSignature> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    PGPSignature element$iv;
                    PGPSignature it = element$iv = iterator$iv.previous();
                    boolean bl2 = false;
                    try {
                        SignatureVerifier.Companion.verifyKeyRevocationSignature(it, primaryKey, policy, referenceTime);
                        bl = true;
                    }
                    catch (SignatureValidationException e) {
                        bl = false;
                    }
                    if (!bl) continue;
                    pGPSignature = element$iv;
                    break block3;
                }
                pGPSignature = null;
            }
            return pGPSignature;
        }

        @JvmStatic
        @Nullable
        public final PGPSignature pickCurrentDirectKeySelfSignature(@NotNull PGPKeyRing keyRing, @NotNull Policy policy, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter(keyRing, "keyRing");
            Intrinsics.checkNotNullParameter(policy, "policy");
            Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
            PGPPublicKey primaryKey = keyRing.getPublicKey();
            Intrinsics.checkNotNullExpressionValue(primaryKey, "primaryKey");
            return this.pickCurrentDirectKeySignature(primaryKey, primaryKey, policy, referenceTime);
        }

        @JvmStatic
        @Nullable
        public final PGPSignature pickCurrentDirectKeySignature(@NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey signedKey, @NotNull Policy policy, @NotNull Date referenceTime) {
            PGPSignature pGPSignature;
            block3: {
                Intrinsics.checkNotNullParameter(signingKey, "signingKey");
                Intrinsics.checkNotNullParameter(signedKey, "signedKey");
                Intrinsics.checkNotNullParameter(policy, "policy");
                Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
                List<PGPSignature> $this$lastOrNull$iv = this.getSortedSignaturesOfType(signedKey, SignatureType.DIRECT_KEY);
                boolean $i$f$lastOrNull = false;
                ListIterator<PGPSignature> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    PGPSignature element$iv;
                    PGPSignature it = element$iv = iterator$iv.previous();
                    boolean bl2 = false;
                    try {
                        SignatureVerifier.Companion.verifyDirectKeySignature(it, signingKey, signedKey, policy, referenceTime);
                        bl = true;
                    }
                    catch (SignatureValidationException e) {
                        bl = false;
                    }
                    if (!bl) continue;
                    pGPSignature = element$iv;
                    break block3;
                }
                pGPSignature = null;
            }
            return pGPSignature;
        }

        @JvmStatic
        @Nullable
        public final PGPSignature pickLatestDirectKeySignature(@NotNull PGPKeyRing keyRing, @NotNull Policy policy, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter(keyRing, "keyRing");
            Intrinsics.checkNotNullParameter(policy, "policy");
            Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
            PGPPublicKey pGPPublicKey = keyRing.getPublicKey();
            Intrinsics.checkNotNullExpressionValue(pGPPublicKey, "keyRing.publicKey");
            PGPPublicKey pGPPublicKey2 = keyRing.getPublicKey();
            Intrinsics.checkNotNullExpressionValue(pGPPublicKey2, "keyRing.publicKey");
            return this.pickLatestDirectKeySignature(pGPPublicKey, pGPPublicKey2, policy, referenceTime);
        }

        @JvmStatic
        @Nullable
        public final PGPSignature pickLatestDirectKeySignature(@NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey signedKey, @NotNull Policy policy, @NotNull Date referenceTime) {
            PGPSignature pGPSignature;
            block4: {
                Intrinsics.checkNotNullParameter(signingKey, "signingKey");
                Intrinsics.checkNotNullParameter(signedKey, "signedKey");
                Intrinsics.checkNotNullParameter(policy, "policy");
                Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
                PGPSignature latest = null;
                List<PGPSignature> $this$lastOrNull$iv = this.getSortedSignaturesOfType(signedKey, SignatureType.DIRECT_KEY);
                boolean $i$f$lastOrNull = false;
                ListIterator<PGPSignature> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    PGPSignature element$iv;
                    PGPSignature it = element$iv = iterator$iv.previous();
                    boolean bl2 = false;
                    try {
                        SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.DIRECT_KEY};
                        SignatureValidator.Companion.signatureIsOfType(signatureTypeArray).verify(it);
                        SignatureValidator.Companion.signatureStructureIsAcceptable(signingKey, policy).verify(it);
                        SignatureValidator.Companion.signatureIsAlreadyEffective(referenceTime).verify(it);
                        if (latest != null && !PGPSignatureExtensionsKt.isExpired(latest, referenceTime)) {
                            SignatureValidator.Companion.signatureIsNotYetExpired(referenceTime).verify(it);
                        }
                        SignatureValidator.Companion.correctSignatureOverKey(signingKey, signedKey).verify(it);
                        latest = it;
                        bl = true;
                    }
                    catch (SignatureValidationException e) {
                        bl = false;
                    }
                    if (!bl) continue;
                    pGPSignature = element$iv;
                    break block4;
                }
                pGPSignature = null;
            }
            return pGPSignature;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final PGPSignature pickCurrentUserIdRevocationSignature(@NotNull PGPKeyRing keyRing, @NotNull CharSequence userId, @NotNull Policy policy, @NotNull Date referenceTime) {
            Object v1;
            block5: {
                void $this$lastOrNull$iv;
                Intrinsics.checkNotNullParameter(keyRing, "keyRing");
                Intrinsics.checkNotNullParameter(userId, "userId");
                Intrinsics.checkNotNullParameter(policy, "policy");
                Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
                PGPPublicKey primaryKey = keyRing.getPublicKey();
                Intrinsics.checkNotNullExpressionValue(primaryKey, "primaryKey");
                List<PGPSignature> list = this.getSortedSignaturesOfType(primaryKey, SignatureType.CERTIFICATION_REVOCATION);
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    Object element$iv = iterator$iv.previous();
                    PGPSignature it = (PGPSignature)element$iv;
                    boolean bl2 = false;
                    if (PGPKeyRingExtensionsKt.getPublicKeyFor(keyRing, it) == null) {
                        bl = false;
                    } else {
                        boolean bl3;
                        try {
                            SignatureVerifier.Companion.verifyUserIdRevocation(((Object)userId).toString(), it, primaryKey, policy, referenceTime);
                            bl3 = true;
                        }
                        catch (SignatureValidationException e) {
                            bl3 = false;
                        }
                        bl = bl3;
                    }
                    if (!bl) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            return v1;
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @Nullable
        public final PGPSignature pickCurrentUserIdCertificationSignature(@NotNull PGPKeyRing keyRing, @NotNull CharSequence userId, @NotNull Policy policy, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter(keyRing, "keyRing");
            Intrinsics.checkNotNullParameter(userId, "userId");
            Intrinsics.checkNotNullParameter(policy, "policy");
            Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
            primaryKey = keyRing.getPublicKey();
            v0 = primaryKey.getSignaturesForID(userId.toString());
            Intrinsics.checkNotNullExpressionValue(v0, "primaryKey\n             \u2026sForID(userId.toString())");
            var6_6 = SequencesKt.sortedWith(SequencesKt.asSequence(v0), new SignatureCreationDateComparator(null, 1, null));
            $i$f$lastOrNull = false;
            last$iv = null;
            for (T element$iv : $this$lastOrNull$iv) {
                it = (PGPSignature)element$iv;
                $i$a$-lastOrNull-SignaturePicker$Companion$pickCurrentUserIdCertificationSignature$1 = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                Intrinsics.checkNotNullExpressionValue(primaryKey, "primaryKey");
                if (!PGPSignatureExtensionsKt.wasIssuedBy(it, primaryKey)) ** GOTO lbl-1000
                try {
                    SignatureVerifier.Companion.verifyUserIdCertification(userId.toString(), it, primaryKey, policy, referenceTime);
                    var13_13 = true;
                }
                catch (SignatureValidationException e) {
                    var13_13 = false;
                }
                if (var13_13) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                last$iv = element$iv;
            }
            return last$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final PGPSignature pickLatestUserIdCertificationSignature(@NotNull PGPKeyRing keyRing, @NotNull CharSequence userId, @NotNull Policy policy, @NotNull Date referenceTime) {
            void $this$lastOrNull$iv;
            Intrinsics.checkNotNullParameter(keyRing, "keyRing");
            Intrinsics.checkNotNullParameter(userId, "userId");
            Intrinsics.checkNotNullParameter(policy, "policy");
            Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
            PGPPublicKey primaryKey = keyRing.getPublicKey();
            Iterator<PGPSignature> iterator2 = primaryKey.getSignaturesForID(((Object)userId).toString());
            Intrinsics.checkNotNullExpressionValue(iterator2, "primaryKey\n             \u2026sForID(userId.toString())");
            Sequence<PGPSignature> sequence = SequencesKt.sortedWith(SequencesKt.asSequence(iterator2), new SignatureCreationDateComparator(null, 1, null));
            boolean $i$f$lastOrNull = false;
            Object last$iv = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                boolean bl;
                PGPSignature it = (PGPSignature)element$iv;
                boolean bl2 = false;
                try {
                    Intrinsics.checkNotNullExpressionValue(primaryKey, "primaryKey");
                    SignatureValidator signatureValidator = SignatureValidator.Companion.wasPossiblyMadeByKey(primaryKey);
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    signatureValidator.verify(it);
                    SignatureValidator.Companion.signatureIsCertification().verify(it);
                    SignatureValidator.Companion.signatureStructureIsAcceptable(primaryKey, policy).verify(it);
                    SignatureValidator.Companion.signatureIsAlreadyEffective(referenceTime).verify(it);
                    SignatureValidator.Companion.correctSignatureOverUserId(((Object)userId).toString(), primaryKey, primaryKey).verify(it);
                    bl = true;
                }
                catch (SignatureValidationException e) {
                    bl = false;
                }
                if (!bl) continue;
                last$iv = element$iv;
            }
            return last$iv;
        }

        @JvmStatic
        @Nullable
        public final PGPSignature pickCurrentSubkeyBindingRevocationSignature(@NotNull PGPKeyRing keyRing, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) {
            PGPSignature pGPSignature;
            block4: {
                Intrinsics.checkNotNullParameter(keyRing, "keyRing");
                Intrinsics.checkNotNullParameter(subkey, "subkey");
                Intrinsics.checkNotNullParameter(policy, "policy");
                Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
                PGPPublicKey primaryKey = keyRing.getPublicKey();
                if (!(primaryKey.getKeyID() != subkey.getKeyID())) {
                    boolean $i$a$-require-SignaturePicker$Companion$pickCurrentSubkeyBindingRevocationSignature$22 = false;
                    String $i$a$-require-SignaturePicker$Companion$pickCurrentSubkeyBindingRevocationSignature$22 = "Primary key cannot have subkey binding revocations.";
                    throw new IllegalArgumentException($i$a$-require-SignaturePicker$Companion$pickCurrentSubkeyBindingRevocationSignature$22.toString());
                }
                List<PGPSignature> $this$lastOrNull$iv = this.getSortedSignaturesOfType(subkey, SignatureType.SUBKEY_REVOCATION);
                boolean $i$f$lastOrNull = false;
                ListIterator<PGPSignature> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    PGPSignature element$iv;
                    PGPSignature it = element$iv = iterator$iv.previous();
                    boolean bl2 = false;
                    try {
                        Intrinsics.checkNotNullExpressionValue(primaryKey, "primaryKey");
                        SignatureVerifier.Companion.verifySubkeyBindingRevocation(it, primaryKey, subkey, policy, referenceTime);
                        bl = true;
                    }
                    catch (SignatureValidationException e) {
                        bl = false;
                    }
                    if (!bl) continue;
                    pGPSignature = element$iv;
                    break block4;
                }
                pGPSignature = null;
            }
            return pGPSignature;
        }

        @JvmStatic
        @Nullable
        public final PGPSignature pickCurrentSubkeyBindingSignature(@NotNull PGPKeyRing keyRing, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) {
            PGPSignature pGPSignature;
            block4: {
                Intrinsics.checkNotNullParameter(keyRing, "keyRing");
                Intrinsics.checkNotNullParameter(subkey, "subkey");
                Intrinsics.checkNotNullParameter(policy, "policy");
                Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
                PGPPublicKey primaryKey = keyRing.getPublicKey();
                if (!(primaryKey.getKeyID() != subkey.getKeyID())) {
                    boolean $i$a$-require-SignaturePicker$Companion$pickCurrentSubkeyBindingSignature$22 = false;
                    String $i$a$-require-SignaturePicker$Companion$pickCurrentSubkeyBindingSignature$22 = "Primary key cannot have subkey binding signatures.";
                    throw new IllegalArgumentException($i$a$-require-SignaturePicker$Companion$pickCurrentSubkeyBindingSignature$22.toString());
                }
                List<PGPSignature> $this$lastOrNull$iv = this.getSortedSignaturesOfType(subkey, SignatureType.SUBKEY_BINDING);
                boolean $i$f$lastOrNull = false;
                ListIterator<PGPSignature> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    PGPSignature element$iv;
                    PGPSignature it = element$iv = iterator$iv.previous();
                    boolean bl2 = false;
                    try {
                        Intrinsics.checkNotNullExpressionValue(primaryKey, "primaryKey");
                        SignatureVerifier.Companion.verifySubkeyBindingSignature(it, primaryKey, subkey, policy, referenceTime);
                        bl = true;
                    }
                    catch (SignatureValidationException e) {
                        bl = false;
                    }
                    if (!bl) continue;
                    pGPSignature = element$iv;
                    break block4;
                }
                pGPSignature = null;
            }
            return pGPSignature;
        }

        @JvmStatic
        @Nullable
        public final PGPSignature pickLatestSubkeyBindingSignature(@NotNull PGPKeyRing keyRing, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) {
            PGPSignature pGPSignature;
            block5: {
                Intrinsics.checkNotNullParameter(keyRing, "keyRing");
                Intrinsics.checkNotNullParameter(subkey, "subkey");
                Intrinsics.checkNotNullParameter(policy, "policy");
                Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
                PGPPublicKey primaryKey = keyRing.getPublicKey();
                if (!(primaryKey.getKeyID() != subkey.getKeyID())) {
                    boolean $i$a$-require-SignaturePicker$Companion$pickLatestSubkeyBindingSignature$22 = false;
                    String $i$a$-require-SignaturePicker$Companion$pickLatestSubkeyBindingSignature$22 = "Primary key cannot have subkey binding signatures.";
                    throw new IllegalArgumentException($i$a$-require-SignaturePicker$Companion$pickLatestSubkeyBindingSignature$22.toString());
                }
                PGPSignature latest = null;
                List<PGPSignature> $this$lastOrNull$iv = this.getSortedSignaturesOfType(subkey, SignatureType.SUBKEY_BINDING);
                boolean $i$f$lastOrNull = false;
                ListIterator<PGPSignature> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    PGPSignature element$iv;
                    PGPSignature it = element$iv = iterator$iv.previous();
                    boolean bl2 = false;
                    try {
                        SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.SUBKEY_BINDING};
                        SignatureValidator.Companion.signatureIsOfType(signatureTypeArray).verify(it);
                        Intrinsics.checkNotNullExpressionValue(primaryKey, "primaryKey");
                        SignatureValidator.Companion.signatureStructureIsAcceptable(primaryKey, policy).verify(it);
                        SignatureValidator.Companion.signatureDoesNotPredateSignee(subkey).verify(it);
                        SignatureValidator.Companion.signatureIsAlreadyEffective(referenceTime).verify(it);
                        if (latest != null && !PGPSignatureExtensionsKt.isExpired(latest, referenceTime)) {
                            SignatureValidator.Companion.signatureIsNotYetExpired(referenceTime).verify(it);
                        }
                        SignatureValidator.Companion.correctSubkeyBindingSignature(primaryKey, subkey).verify(it);
                        latest = it;
                        bl = true;
                    }
                    catch (SignatureValidationException e) {
                        bl = false;
                    }
                    if (!bl) continue;
                    pGPSignature = element$iv;
                    break block5;
                }
                pGPSignature = null;
            }
            return pGPSignature;
        }

        @JvmStatic
        private final List<PGPSignature> getSortedSignaturesOfType(PGPPublicKey key2, SignatureType type) {
            Iterator<PGPSignature> iterator2 = key2.getSignaturesOfType(type.getCode());
            Intrinsics.checkNotNullExpressionValue(iterator2, "key.getSignaturesOfType(type.code)");
            return SequencesKt.toList(SequencesKt.sortedWith(SequencesKt.asSequence(iterator2), new SignatureCreationDateComparator(null, 1, null)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

