/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.decryption_verification.OpenPgpInputStream;
import org.pgpainless.decryption_verification.cleartext_signatures.ClearsignedMessageUtil;
import org.pgpainless.exception.WrongConsumingMethodException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.sop.InlineDetachImpl;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import sop.ReadyWithResult;
import sop.Signatures;
import sop.exception.SOPGPException;
import sop.operation.InlineDetach;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/sop/InlineDetachImpl;", "Lsop/operation/InlineDetach;", "()V", "armor", "", "message", "Lsop/ReadyWithResult;", "Lsop/Signatures;", "messageInputStream", "Ljava/io/InputStream;", "noArmor", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nInlineDetachImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineDetachImpl.kt\norg/pgpainless/sop/InlineDetachImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class InlineDetachImpl
implements InlineDetach {
    private boolean armor = true;

    @Override
    @NotNull
    public ReadyWithResult<Signatures> message(@NotNull InputStream messageInputStream) {
        Intrinsics.checkNotNullParameter(messageInputStream, "messageInputStream");
        return new ReadyWithResult<Signatures>(messageInputStream, this){
            @NotNull
            private final ByteArrayOutputStream sigOut;
            final /* synthetic */ InputStream $messageInputStream;
            final /* synthetic */ InlineDetachImpl this$0;
            {
                this.$messageInputStream = $messageInputStream;
                this.this$0 = $receiver;
                this.sigOut = new ByteArrayOutputStream();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public Signatures writeTo(@NotNull OutputStream outputStream) {
                block21: {
                    PGPSignatureList signatures;
                    block20: {
                        Object object;
                        Object next;
                        Object objectFactory;
                        Intrinsics.checkNotNullParameter(outputStream, "outputStream");
                        OpenPgpInputStream pgpIn = new OpenPgpInputStream(this.$messageInputStream);
                        if (pgpIn.isNonOpenPgp()) {
                            throw new SOPGPException.BadData("Data appears to be non-OpenPGP.");
                        }
                        signatures = null;
                        if (pgpIn.isAsciiArmored()) {
                            ArmoredInputStream armorIn = new ArmoredInputStream(pgpIn);
                            if (armorIn.isClearText()) {
                                try {
                                    signatures = ClearsignedMessageUtil.Companion.detachSignaturesFromInbandClearsignedMessage(armorIn, outputStream);
                                    if (signatures.isEmpty()) {
                                        throw new SOPGPException.BadData("Data did not contain OpenPGP signatures.");
                                    }
                                }
                                catch (WrongConsumingMethodException e) {
                                    throw new SOPGPException.BadData(e);
                                }
                            }
                            pgpIn = new OpenPgpInputStream(armorIn);
                        }
                        if (signatures == null) {
                            if (!pgpIn.isBinaryOpenPgp()) {
                                throw new SOPGPException.BadData("Data was containing ASCII armored non-OpenPGP data.");
                            }
                            objectFactory = ImplementationFactory.Companion.getInstance().getPGPObjectFactory(pgpIn);
                            next = null;
                            while (true) {
                                object = ((PGPObjectFactory)objectFactory).nextObject();
                                Iterator<T> it = object;
                                boolean bl = false;
                                next = it;
                                if (object == null) break;
                                if (next instanceof PGPOnePassSignatureList) continue;
                                if (next instanceof PGPLiteralData) {
                                    InputStream literalIn = ((PGPLiteralData)next).getDataStream();
                                    Streams.pipeAll(literalIn, outputStream);
                                    literalIn.close();
                                    continue;
                                }
                                if (next instanceof PGPCompressedData) {
                                    try {
                                        ImplementationFactory implementationFactory = ImplementationFactory.Companion.getInstance();
                                        InputStream inputStream = ((PGPCompressedData)next).getDataStream();
                                        Intrinsics.checkNotNullExpressionValue(inputStream, "next as PGPCompressedData).dataStream");
                                        objectFactory = implementationFactory.getPGPObjectFactory(inputStream);
                                    }
                                    catch (PGPException e) {
                                        throw new SOPGPException.BadData("Cannot decompress PGPCompressedData", e);
                                    }
                                }
                                if (!(next instanceof PGPSignatureList)) continue;
                                signatures = (PGPSignatureList)next;
                            }
                        }
                        if (signatures == null) {
                            throw new SOPGPException.BadData("Data did not contain OpenPGP signatures.");
                        }
                        if (!InlineDetachImpl.access$getArmor$p(this.this$0)) break block20;
                        objectFactory = ArmoredOutputStreamFactory.Companion.get$default(ArmoredOutputStreamFactory.Companion, this.sigOut, null, 2, null);
                        next = null;
                        try {
                            ArmoredOutputStream armoredOut = (ArmoredOutputStream)objectFactory;
                            boolean bl = false;
                            Iterable $this$forEach$iv = signatures;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                PGPSignature it = (PGPSignature)element$iv;
                                boolean bl2 = false;
                                it.encode(armoredOut);
                            }
                            object = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            try {
                                next = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                CloseableKt.closeFinally((Closeable)objectFactory, next);
                                throw throwable2;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)objectFactory, (Throwable)next);
                        break block21;
                    }
                    Iterable $this$forEach$iv = signatures;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PGPSignature it = (PGPSignature)element$iv;
                        boolean bl = false;
                        it.encode(this.sigOut);
                    }
                }
                return new Signatures(this){
                    final /* synthetic */ message.1 this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void writeTo(@NotNull OutputStream outputStream) {
                        Intrinsics.checkNotNullParameter(outputStream, "outputStream");
                        message.1.access$getSigOut$p(this.this$0).writeTo(outputStream);
                    }
                };
            }

            public static final /* synthetic */ ByteArrayOutputStream access$getSigOut$p(message.1 $this) {
                return $this.sigOut;
            }
        };
    }

    @Override
    @NotNull
    public InlineDetach noArmor() {
        InlineDetachImpl inlineDetachImpl;
        InlineDetachImpl $this$noArmor_u24lambda_u240 = inlineDetachImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u240.armor = false;
        return inlineDetachImpl;
    }

    public static final /* synthetic */ boolean access$getArmor$p(InlineDetachImpl $this) {
        return $this.armor;
    }
}

