/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.util.encoders.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/util/SessionKey;", "", "sessionKey", "Lorg/bouncycastle/openpgp/PGPSessionKey;", "(Lorg/bouncycastle/openpgp/PGPSessionKey;)V", "algorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "key", "", "(Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;[B)V", "getAlgorithm", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getKey", "()[B", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "pgpainless-core"})
public final class SessionKey {
    @NotNull
    private final SymmetricKeyAlgorithm algorithm;
    @NotNull
    private final byte[] key;

    public SessionKey(@NotNull SymmetricKeyAlgorithm algorithm, @NotNull byte[] key2) {
        Intrinsics.checkNotNullParameter((Object)algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(key2, "key");
        this.algorithm = algorithm;
        this.key = key2;
    }

    @NotNull
    public final SymmetricKeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getKey() {
        return this.key;
    }

    public SessionKey(@NotNull PGPSessionKey sessionKey) {
        Intrinsics.checkNotNullParameter(sessionKey, "sessionKey");
        SymmetricKeyAlgorithm symmetricKeyAlgorithm = SymmetricKeyAlgorithm.Companion.requireFromId(sessionKey.getAlgorithm());
        byte[] byArray = sessionKey.getKey();
        Intrinsics.checkNotNullExpressionValue(byArray, "sessionKey.key");
        this(symmetricKeyAlgorithm, byArray);
    }

    @NotNull
    public String toString() {
        return "" + this.algorithm.getAlgorithmId() + ':' + Hex.toHexString(this.key);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type org.pgpainless.util.SessionKey");
        SessionKey cfr_ignored_0 = (SessionKey)other;
        if (this.algorithm != ((SessionKey)other).algorithm) {
            return false;
        }
        return Arrays.equals(this.key, ((SessionKey)other).key);
    }

    public int hashCode() {
        return 31 * this.algorithm.hashCode() + Arrays.hashCode(this.key);
    }

    @NotNull
    public final SymmetricKeyAlgorithm component1() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] component2() {
        return this.key;
    }

    @NotNull
    public final SessionKey copy(@NotNull SymmetricKeyAlgorithm algorithm, @NotNull byte[] key2) {
        Intrinsics.checkNotNullParameter((Object)algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(key2, "key");
        return new SessionKey(algorithm, key2);
    }

    public static /* synthetic */ SessionKey copy$default(SessionKey sessionKey, SymmetricKeyAlgorithm symmetricKeyAlgorithm, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            symmetricKeyAlgorithm = sessionKey.algorithm;
        }
        if ((n & 2) != 0) {
            byArray = sessionKey.key;
        }
        return sessionKey.copy(symmetricKeyAlgorithm, byArray);
    }
}

