/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.RevokeKey;

@CommandLine.Command(name="revoke-key", resourceBundle="msg_revoke-key", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lsop/cli/picocli/commands/RevokeKeyCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "armor", "", "getArmor", "()Z", "setArmor", "(Z)V", "withKeyPassword", "", "getWithKeyPassword", "()Ljava/lang/String;", "setWithKeyPassword", "(Ljava/lang/String;)V", "run", "", "sop-java-picocli"})
public final class RevokeKeyCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    private boolean armor = true;
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    @Nullable
    private String withKeyPassword;

    public RevokeKeyCmd() {
        super(null, 1, null);
    }

    public final boolean getArmor() {
        return this.armor;
    }

    public final void setArmor(boolean bl) {
        this.armor = bl;
    }

    @Nullable
    public final String getWithKeyPassword() {
        return this.withKeyPassword;
    }

    public final void setWithKeyPassword(@Nullable String string) {
        this.withKeyPassword = string;
    }

    @Override
    public void run() {
        Ready ready;
        String[] stringArray;
        RevokeKey revokeKey = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().revokeKey(), "revoke-key");
        if (!this.armor) {
            revokeKey.noArmor();
        }
        String string = this.withKeyPassword;
        if (string != null) {
            String it = string;
            boolean bl = false;
            try {
                String password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(it));
                stringArray = revokeKey.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption e) {
                String[] stringArray2 = new String[]{"--with-key-password"};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray2);
                throw new SOPGPException.UnsupportedOption(errorMsg, e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "`in`");
            ready = revokeKey.keys(inputStream);
        }
        catch (SOPGPException.KeyIsProtected e) {
            stringArray = new String[]{"STANDARD_IN"};
            String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", stringArray);
            throw new SOPGPException.KeyIsProtected(errorMsg, e);
        }
        Ready ready2 = ready;
        try {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            ready2.writeTo(printStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

