/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class PGPKeyRingGenerator {
    private final List<PGPSecretKey> keys = new ArrayList<PGPSecretKey>();
    private final PBESecretKeyEncryptor keyEncryptor;
    private final PGPDigestCalculator checksumCalculator;
    private final PGPKeyPair primaryKey;
    private final PGPSignatureSubpacketVector hashedPcks;
    private final PGPSignatureSubpacketVector unhashedPcks;
    private final PGPContentSignerBuilder keySignerBuilder;

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string, PGPDigestCalculator pGPDigestCalculator, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this.primaryKey = this.sanitizeKeyPair(pGPKeyPair);
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        this.hashedPcks = pGPSignatureSubpacketVector;
        this.unhashedPcks = pGPSignatureSubpacketVector2;
        this.keys.add(new PGPSecretKey(n, pGPKeyPair, string, pGPDigestCalculator, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, pGPContentSignerBuilder, pBESecretKeyEncryptor));
    }

    public PGPKeyRingGenerator(PGPKeyPair pGPKeyPair, PGPDigestCalculator pGPDigestCalculator, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator;
        this.primaryKey = this.sanitizeKeyPair(pGPKeyPair);
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        this.hashedPcks = pGPSignatureSubpacketVector;
        this.unhashedPcks = pGPSignatureSubpacketVector2;
        try {
            pGPSignatureGenerator = new PGPSignatureGenerator(pGPContentSignerBuilder, pGPKeyPair.getPublicKey());
        }
        catch (Exception exception) {
            throw new PGPException("creating signature generator: " + exception, exception);
        }
        pGPSignatureGenerator.init(31, pGPKeyPair.getPrivateKey());
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
        pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
        PGPSecretKey pGPSecretKey = new PGPSecretKey(pGPKeyPair.getPrivateKey(), pGPKeyPair.getPublicKey(), pGPDigestCalculator, true, pBESecretKeyEncryptor);
        PGPPublicKey pGPPublicKey = pGPSecretKey.getPublicKey();
        try {
            PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(pGPKeyPair.getPublicKey());
            pGPPublicKey = PGPPublicKey.addCertification(pGPPublicKey, pGPSignature);
        }
        catch (Exception exception) {
            throw new PGPException("exception doing direct-key signature: " + exception, exception);
        }
        pGPSecretKey = PGPSecretKey.replacePublicKey(pGPSecretKey, pGPPublicKey);
        this.keys.add(pGPSecretKey);
    }

    public PGPKeyRingGenerator(PGPSecretKeyRing pGPSecretKeyRing, PBESecretKeyDecryptor pBESecretKeyDecryptor, PGPDigestCalculator pGPDigestCalculator, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this.primaryKey = this.sanitizeKeyPair(new PGPKeyPair(pGPSecretKeyRing.getPublicKey(), pGPSecretKeyRing.getSecretKey().extractPrivateKey(pBESecretKeyDecryptor)));
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        PGPSignature pGPSignature = pGPSecretKeyRing.getPublicKey().getSignatures().next();
        ArrayList<SignatureSubpacket> arrayList = new ArrayList<SignatureSubpacket>();
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets();
        for (int i = 0; i != pGPSignatureSubpacketVector.size(); ++i) {
            if (pGPSignatureSubpacketVector.packets[i].getType() == 2) continue;
            arrayList.add(pGPSignatureSubpacketVector.packets[i]);
        }
        this.hashedPcks = new PGPSignatureSubpacketVector(arrayList.toArray(new SignatureSubpacket[arrayList.size()]));
        this.unhashedPcks = pGPSignature.getUnhashedSubPackets();
        this.keys.addAll(pGPSecretKeyRing.keys);
    }

    private PGPKeyPair sanitizeKeyPair(PGPKeyPair pGPKeyPair) throws PGPException {
        PGPPublicKey pGPPublicKey = pGPKeyPair.getPublicKey();
        if (pGPPublicKey.getVersion() == 6) {
            ECPublicBCPGKey eCPublicBCPGKey;
            if (pGPPublicKey.getAlgorithm() == 16 || pGPPublicKey.getAlgorithm() == 20) {
                throw new PGPException("An implementation MUST NOT generate v6 ElGamal keys");
            }
            if (pGPPublicKey.getAlgorithm() == 1 && pGPPublicKey.getBitStrength() < 3072) {
                throw new PGPException("An implementation MUST NOT generate v6 RSA keys of a size less than 3072 bits.");
            }
            if (pGPPublicKey.getAlgorithm() == 2 || pGPPublicKey.getAlgorithm() == 3) {
                throw new PGPException("An implementation MUST NOT generate v6 RSA keys of type RSA_ENCRYPT/RSA_SIGN");
            }
            if (pGPPublicKey.getAlgorithm() == 17) {
                throw new PGPException("An implementation MUST NOT generate v6 DSA keys.");
            }
            if (pGPPublicKey.getAlgorithm() == 22) {
                throw new PGPException("An implementation MUST NOT generate v6 EDDSA_LEGACY keys.");
            }
            if (pGPPublicKey.getAlgorithm() == 18 && (eCPublicBCPGKey = (ECPublicBCPGKey)pGPPublicKey.publicPk.getKey()).getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                throw new PGPException("An implementation MUST NOT generate v6 ECDH keys over Curve25519Legacy.");
            }
            if (pGPPublicKey.getAlgorithm() == 21) {
                throw new PGPException("An implementation MUST NOT generate v6 Diffie-Hellman keys.");
            }
        }
        return pGPKeyPair;
    }

    public void addSubKey(PGPKeyPair pGPKeyPair) throws PGPException {
        this.addSubKey(this.sanitizeKeyPair(pGPKeyPair), this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPContentSignerBuilder pGPContentSignerBuilder) throws PGPException {
        this.addSubKey(this.sanitizeKeyPair(pGPKeyPair), this.hashedPcks, this.unhashedPcks, pGPContentSignerBuilder);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2) throws PGPException {
        this.addSubKey(this.sanitizeKeyPair(pGPKeyPair), pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, null);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder) throws PGPException {
        this.sanitizeKeyPair(pGPKeyPair);
        try {
            Object object;
            Object object2;
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.keySignerBuilder, this.primaryKey.getPublicKey());
            pGPSignatureGenerator.init(24, this.primaryKey.getPrivateKey());
            if (pGPContentSignerBuilder != null) {
                object2 = new PGPSignatureGenerator(pGPContentSignerBuilder, pGPKeyPair.getPublicKey());
                ((PGPSignatureGenerator)object2).init(25, pGPKeyPair.getPrivateKey());
                object = new PGPSignatureSubpacketGenerator(pGPSignatureSubpacketVector);
                ((PGPSignatureSubpacketGenerator)object).addEmbeddedSignature(false, ((PGPSignatureGenerator)object2).generateCertification(this.primaryKey.getPublicKey(), pGPKeyPair.getPublicKey()));
                pGPSignatureGenerator.setHashedSubpackets(((PGPSignatureSubpacketGenerator)object).generate());
            } else {
                pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
            }
            pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
            object2 = new ArrayList();
            object2.add(pGPSignatureGenerator.generateCertification(this.primaryKey.getPublicKey(), pGPKeyPair.getPublicKey()));
            object = new PGPPublicKey(pGPKeyPair.getPublicKey(), null, (List<PGPSignature>)object2);
            ((PGPPublicKey)object).publicPk = new PublicSubkeyPacket(((PGPPublicKey)object).getVersion(), ((PGPPublicKey)object).getAlgorithm(), ((PGPPublicKey)object).getCreationTime(), ((PGPPublicKey)object).publicPk.getKey());
            this.keys.add(new PGPSecretKey(pGPKeyPair.getPrivateKey(), (PGPPublicKey)object, this.checksumCalculator, this.keyEncryptor));
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception adding subkey: ", exception);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator<PGPSecretKey> iterator2 = this.keys.iterator();
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        arrayList.add(iterator2.next().getPublicKey());
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next().getPublicKey());
        }
        return new PGPPublicKeyRing(arrayList);
    }
}

