/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.KeyRingIterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Longs;
import org.bouncycastle.util.Strings;

public class PGPPublicKeyRingCollection
implements Iterable<PGPPublicKeyRing> {
    private Map<Long, PGPPublicKeyRing> pubRings = new HashMap<Long, PGPPublicKeyRing>();
    private List<Long> order = new ArrayList<Long>();

    private PGPPublicKeyRingCollection(Map<Long, PGPPublicKeyRing> map, List<Long> list) {
        this.pubRings = map;
        this.order = list;
    }

    public PGPPublicKeyRingCollection(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public PGPPublicKeyRingCollection(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        Object object;
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream, keyFingerPrintCalculator);
        while ((object = pGPObjectFactory.nextObject()) != null) {
            if (object instanceof PGPMarker || object instanceof PGPPadding) continue;
            if (!(object instanceof PGPPublicKeyRing)) {
                throw new PGPException(object.getClass().getName() + " found where PGPPublicKeyRing expected");
            }
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)object;
            Long l = Longs.valueOf(pGPPublicKeyRing.getPublicKey().getKeyID());
            this.pubRings.put(l, pGPPublicKeyRing);
            this.order.add(l);
        }
    }

    public PGPPublicKeyRingCollection(Collection<PGPPublicKeyRing> collection) {
        for (PGPPublicKeyRing pGPPublicKeyRing : collection) {
            Long l = Longs.valueOf(pGPPublicKeyRing.getPublicKey().getKeyID());
            this.pubRings.put(l, pGPPublicKeyRing);
            this.order.add(l);
        }
    }

    public int size() {
        return this.order.size();
    }

    public Iterator<PGPPublicKeyRing> getKeyRings() {
        return this.pubRings.values().iterator();
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String string) {
        return this.getKeyRings(string, false, false);
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String string, boolean bl) {
        return this.getKeyRings(string, bl, false);
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String string, boolean bl, boolean bl2) {
        Iterator<PGPPublicKeyRing> iterator2 = this.getKeyRings();
        ArrayList<PGPPublicKeyRing> arrayList = new ArrayList<PGPPublicKeyRing>();
        if (bl2) {
            string = Strings.toLowerCase(string);
        }
        while (iterator2.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator2.next();
            Iterator<String> iterator3 = pGPPublicKeyRing.getPublicKey().getUserIDs();
            while (iterator3.hasNext()) {
                String string2 = iterator3.next();
                if (bl2) {
                    string2 = Strings.toLowerCase(string2);
                }
                if (bl) {
                    if (string2.indexOf(string) < 0) continue;
                    arrayList.add(pGPPublicKeyRing);
                    continue;
                }
                if (!string2.equals(string)) continue;
                arrayList.add(pGPPublicKeyRing);
            }
        }
        return arrayList.iterator();
    }

    public PGPPublicKey getPublicKey(long l) {
        Iterator<PGPPublicKeyRing> iterator2 = this.getKeyRings();
        while (iterator2.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator2.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(l);
            if (pGPPublicKey == null) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public PGPPublicKeyRing getPublicKeyRing(long l) {
        Long l2 = Longs.valueOf(l);
        if (this.pubRings.containsKey(l2)) {
            return this.pubRings.get(l2);
        }
        Iterator<PGPPublicKeyRing> iterator2 = this.getKeyRings();
        while (iterator2.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator2.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(l);
            if (pGPPublicKey == null) continue;
            return pGPPublicKeyRing;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(byte[] byArray) {
        Iterator<PGPPublicKeyRing> iterator2 = this.getKeyRings();
        while (iterator2.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator2.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(byArray);
            if (pGPPublicKey == null) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public PGPPublicKeyRing getPublicKeyRing(byte[] byArray) {
        Iterator<PGPPublicKeyRing> iterator2 = this.getKeyRings();
        while (iterator2.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator2.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(byArray);
            if (pGPPublicKey == null) continue;
            return pGPPublicKeyRing;
        }
        return null;
    }

    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long l) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        for (PGPPublicKeyRing pGPPublicKeyRing : this) {
            Iterator<PGPPublicKey> iterator2 = pGPPublicKeyRing.getKeysWithSignaturesBy(l);
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        return arrayList.iterator();
    }

    public boolean contains(long l) {
        return this.getPublicKey(l) != null;
    }

    public boolean contains(byte[] byArray) {
        return this.getPublicKey(byArray) != null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = BCPGOutputStream.wrap(outputStream);
        Iterator<Long> iterator2 = this.order.iterator();
        while (iterator2.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = this.pubRings.get(iterator2.next());
            pGPPublicKeyRing.encode(bCPGOutputStream);
        }
    }

    public static PGPPublicKeyRingCollection addPublicKeyRing(PGPPublicKeyRingCollection pGPPublicKeyRingCollection, PGPPublicKeyRing pGPPublicKeyRing) {
        Long l = Longs.valueOf(pGPPublicKeyRing.getPublicKey().getKeyID());
        if (pGPPublicKeyRingCollection.pubRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPPublicKeyRing> hashMap = new HashMap<Long, PGPPublicKeyRing>(pGPPublicKeyRingCollection.pubRings);
        ArrayList<Long> arrayList = new ArrayList<Long>(pGPPublicKeyRingCollection.order);
        hashMap.put(l, pGPPublicKeyRing);
        arrayList.add(l);
        return new PGPPublicKeyRingCollection(hashMap, arrayList);
    }

    public static PGPPublicKeyRingCollection removePublicKeyRing(PGPPublicKeyRingCollection pGPPublicKeyRingCollection, PGPPublicKeyRing pGPPublicKeyRing) {
        Long l = Longs.valueOf(pGPPublicKeyRing.getPublicKey().getKeyID());
        if (!pGPPublicKeyRingCollection.pubRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection does not contain a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPPublicKeyRing> hashMap = new HashMap<Long, PGPPublicKeyRing>(pGPPublicKeyRingCollection.pubRings);
        ArrayList<Long> arrayList = new ArrayList<Long>(pGPPublicKeyRingCollection.order);
        hashMap.remove(l);
        for (int i = 0; i < arrayList.size(); ++i) {
            Long l2 = (Long)arrayList.get(i);
            if (l2.longValue() != l.longValue()) continue;
            arrayList.remove(i);
            break;
        }
        return new PGPPublicKeyRingCollection(hashMap, arrayList);
    }

    @Override
    public Iterator<PGPPublicKeyRing> iterator() {
        return new KeyRingIterator<PGPPublicKeyRing>(this.order, this.pubRings);
    }
}

