/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class EllipticCurveKeyPairGenerator {
    private static final int SIG_HASH = 10;
    private static final int[] HASH_PREFERENCES = new int[]{10, 9, 8, 11};
    private static final int[] SYM_PREFERENCES = new int[]{9, 8, 7};
    private static final int[] COMP_PREFERENCES = new int[]{2, 3, 2, 0};

    private static void generateAndExportKeyRing(OutputStream outputStream, OutputStream outputStream2, String string, char[] cArray, boolean bl) throws IOException, NoSuchProviderException, PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EdDSA", "BC");
        KeyPairGenerator keyPairGenerator2 = KeyPairGenerator.getInstance("XDH", "BC");
        JcaPGPContentSignerBuilder jcaPGPContentSignerBuilder = new JcaPGPContentSignerBuilder(22, 10);
        PBESecretKeyEncryptor pBESecretKeyEncryptor = new JcePBESecretKeyEncryptorBuilder(9, pGPDigestCalculator).build(cArray);
        Date date = new Date();
        keyPairGenerator.initialize(new ECNamedCurveGenParameterSpec("ed25519"));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(22, keyPair, date);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setKeyFlags(true, 1);
        pGPSignatureSubpacketGenerator.setPreferredHashAlgorithms(false, HASH_PREFERENCES);
        pGPSignatureSubpacketGenerator.setPreferredSymmetricAlgorithms(false, SYM_PREFERENCES);
        pGPSignatureSubpacketGenerator.setPreferredCompressionAlgorithms(false, COMP_PREFERENCES);
        pGPSignatureSubpacketGenerator.setFeature(false, (byte)1);
        pGPSignatureSubpacketGenerator.setIssuerFingerprint(false, jcaPGPKeyPair.getPublicKey());
        keyPairGenerator.initialize(new ECNamedCurveGenParameterSpec("ed25519"));
        KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
        JcaPGPKeyPair jcaPGPKeyPair2 = new JcaPGPKeyPair(22, keyPair2, date);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator2 = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator2.setKeyFlags(true, 2);
        pGPSignatureSubpacketGenerator2.setIssuerFingerprint(false, jcaPGPKeyPair.getPublicKey());
        keyPairGenerator2.initialize(new ECNamedCurveGenParameterSpec("X25519"));
        KeyPair keyPair3 = keyPairGenerator2.generateKeyPair();
        JcaPGPKeyPair jcaPGPKeyPair3 = new JcaPGPKeyPair(18, keyPair3, date);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator3 = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator3.setKeyFlags(true, 12);
        pGPSignatureSubpacketGenerator3.setIssuerFingerprint(false, jcaPGPKeyPair.getPublicKey());
        PGPKeyRingGenerator pGPKeyRingGenerator = new PGPKeyRingGenerator(19, jcaPGPKeyPair, string, pGPDigestCalculator, pGPSignatureSubpacketGenerator.generate(), null, jcaPGPContentSignerBuilder, pBESecretKeyEncryptor);
        pGPKeyRingGenerator.addSubKey(jcaPGPKeyPair2, pGPSignatureSubpacketGenerator2.generate(), null, jcaPGPContentSignerBuilder);
        pGPKeyRingGenerator.addSubKey(jcaPGPKeyPair3, pGPSignatureSubpacketGenerator3.generate(), null);
        PGPSecretKeyRing pGPSecretKeyRing = pGPKeyRingGenerator.generateSecretKeyRing();
        pGPSecretKeyRing.encode(outputStream);
        outputStream.close();
        if (bl) {
            outputStream2 = new ArmoredOutputStream(outputStream2);
        }
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> iterator2 = pGPSecretKeyRing.getPublicKeys();
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next());
        }
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(arrayList);
        pGPPublicKeyRing.encode(outputStream2);
        outputStream2.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray.length < 2) {
            System.out.println("EllipticCurveKeyPairGenerator [-a] identity passPhrase");
            System.exit(0);
        }
        if (stringArray[0].equals("-a")) {
            if (stringArray.length < 3) {
                System.out.println("EllipticCurveKeyPairGenerator [-a] identity passPhrase");
                System.exit(0);
            }
            FileOutputStream fileOutputStream = new FileOutputStream("secret.asc");
            FileOutputStream fileOutputStream2 = new FileOutputStream("pub.asc");
            EllipticCurveKeyPairGenerator.generateAndExportKeyRing(fileOutputStream, fileOutputStream2, stringArray[1], stringArray[2].toCharArray(), true);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream("secret.bpg");
            FileOutputStream fileOutputStream3 = new FileOutputStream("pub.bpg");
            EllipticCurveKeyPairGenerator.generateAndExportKeyRing(fileOutputStream, fileOutputStream3, stringArray[0], stringArray[1].toCharArray(), false);
        }
    }
}

