/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0001\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0015"}, d2={"Lorg/pgpainless/algorithm/HashAlgorithm;", "", "algorithmId", "", "algorithmName", "", "(Ljava/lang/String;IILjava/lang/String;)V", "getAlgorithmId", "()I", "getAlgorithmName", "()Ljava/lang/String;", "MD5", "SHA1", "RIPEMD160", "SHA256", "SHA384", "SHA512", "SHA224", "SHA3_256", "SHA3_512", "Companion", "pgpainless-core"})
public final class HashAlgorithm
extends Enum<HashAlgorithm> {
    @NotNull
    public static final Companion Companion;
    private final int algorithmId;
    @NotNull
    private final String algorithmName;
    @Deprecated(message="MD5 is deprecated")
    public static final /* enum */ HashAlgorithm MD5;
    public static final /* enum */ HashAlgorithm SHA1;
    public static final /* enum */ HashAlgorithm RIPEMD160;
    public static final /* enum */ HashAlgorithm SHA256;
    public static final /* enum */ HashAlgorithm SHA384;
    public static final /* enum */ HashAlgorithm SHA512;
    public static final /* enum */ HashAlgorithm SHA224;
    public static final /* enum */ HashAlgorithm SHA3_256;
    public static final /* enum */ HashAlgorithm SHA3_512;
    private static final /* synthetic */ HashAlgorithm[] $VALUES;

    private HashAlgorithm(int algorithmId, String algorithmName) {
        this.algorithmId = algorithmId;
        this.algorithmName = algorithmName;
    }

    public final int getAlgorithmId() {
        return this.algorithmId;
    }

    @NotNull
    public final String getAlgorithmName() {
        return this.algorithmName;
    }

    public static HashAlgorithm[] values() {
        return (HashAlgorithm[])$VALUES.clone();
    }

    public static HashAlgorithm valueOf(String value) {
        return Enum.valueOf(HashAlgorithm.class, value);
    }

    @JvmStatic
    @Nullable
    public static final HashAlgorithm fromId(int id) {
        return Companion.fromId(id);
    }

    @JvmStatic
    @NotNull
    public static final HashAlgorithm requireFromId(int id) {
        return Companion.requireFromId(id);
    }

    @JvmStatic
    @Nullable
    public static final HashAlgorithm fromName(@NotNull String name) {
        return Companion.fromName(name);
    }

    static {
        MD5 = new HashAlgorithm(1, "MD5");
        SHA1 = new HashAlgorithm(2, "SHA1");
        RIPEMD160 = new HashAlgorithm(3, "RIPEMD160");
        SHA256 = new HashAlgorithm(8, "SHA256");
        SHA384 = new HashAlgorithm(9, "SHA384");
        SHA512 = new HashAlgorithm(10, "SHA512");
        SHA224 = new HashAlgorithm(11, "SHA224");
        SHA3_256 = new HashAlgorithm(12, "SHA3-256");
        SHA3_512 = new HashAlgorithm(14, "SHA3-512");
        $VALUES = hashAlgorithmArray = new HashAlgorithm[]{HashAlgorithm.MD5, HashAlgorithm.SHA1, HashAlgorithm.RIPEMD160, HashAlgorithm.SHA256, HashAlgorithm.SHA384, HashAlgorithm.SHA512, HashAlgorithm.SHA224, HashAlgorithm.SHA3_256, HashAlgorithm.SHA3_512};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/algorithm/HashAlgorithm$Companion;", "", "()V", "fromId", "Lorg/pgpainless/algorithm/HashAlgorithm;", "id", "", "fromName", "name", "", "requireFromId", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nHashAlgorithm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashAlgorithm.kt\norg/pgpainless/algorithm/HashAlgorithm$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n1282#2,2:72\n1282#2,2:74\n1282#2,2:76\n*S KotlinDebug\n*F\n+ 1 HashAlgorithm.kt\norg/pgpainless/algorithm/HashAlgorithm$Companion\n*L\n35#1:72,2\n65#1:74,2\n66#1:76,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final HashAlgorithm fromId(int id) {
            HashAlgorithm hashAlgorithm;
            block1: {
                HashAlgorithm[] $this$firstOrNull$iv = HashAlgorithm.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    HashAlgorithm element$iv;
                    HashAlgorithm h = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!(h.getAlgorithmId() == id)) continue;
                    hashAlgorithm = element$iv;
                    break block1;
                }
                hashAlgorithm = null;
            }
            return hashAlgorithm;
        }

        @JvmStatic
        @NotNull
        public final HashAlgorithm requireFromId(int id) {
            HashAlgorithm hashAlgorithm = this.fromId(id);
            if (hashAlgorithm == null) {
                throw new NoSuchElementException("No HashAlgorithm found for id " + id);
            }
            return hashAlgorithm;
        }

        @JvmStatic
        @Nullable
        public final HashAlgorithm fromName(@NotNull String name) {
            HashAlgorithm hashAlgorithm;
            block4: {
                HashAlgorithm hashAlgorithm2;
                HashAlgorithm it;
                HashAlgorithm element$iv;
                int n;
                int n2;
                boolean $i$f$firstOrNull;
                HashAlgorithm[] $this$firstOrNull$iv;
                String algoName;
                block3: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    String string = name.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
                    algoName = string;
                    boolean bl = false;
                    $this$firstOrNull$iv = HashAlgorithm.values();
                    $i$f$firstOrNull = false;
                    n2 = $this$firstOrNull$iv.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = $this$firstOrNull$iv[n];
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getAlgorithmName(), algoName)) continue;
                        hashAlgorithm2 = element$iv;
                        break block3;
                    }
                    hashAlgorithm2 = hashAlgorithm = null;
                }
                if (hashAlgorithm2 == null) {
                    $this$firstOrNull$iv = HashAlgorithm.values();
                    $i$f$firstOrNull = false;
                    n2 = $this$firstOrNull$iv.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = $this$firstOrNull$iv[n];
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getAlgorithmName(), StringsKt.replace$default(algoName, "-", "", false, 4, null))) continue;
                        hashAlgorithm = element$iv;
                        break block4;
                    }
                    hashAlgorithm = null;
                }
            }
            return hashAlgorithm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

