/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/algorithm/Trustworthiness;", "", "amount", "", "depth", "(II)V", "getAmount", "()I", "getDepth", "canIntroduce", "", "otherDepth", "other", "isFullyTrusted", "isIntroducer", "isMarginallyTrusted", "isNotTrusted", "Builder", "Companion", "pgpainless-core"})
public final class Trustworthiness {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int depth;
    private final int amount;
    public static final int THRESHOLD_FULLY_CONVINCED = 120;
    public static final int MARGINALLY_CONVINCED = 60;
    public static final int NOT_TRUSTED = 0;
    @NotNull
    private static final IntRange validRange = new IntRange(0, 255);

    public Trustworthiness(int amount, int depth) {
        this.depth = Trustworthiness.Companion.capDepth(depth);
        this.amount = Trustworthiness.Companion.capAmount(amount);
    }

    public final int getDepth() {
        return this.depth;
    }

    public final int getAmount() {
        return this.amount;
    }

    public final boolean isNotTrusted() {
        return this.amount == 0;
    }

    public final boolean isMarginallyTrusted() {
        return this.amount > 0;
    }

    public final boolean isFullyTrusted() {
        return this.amount >= 120;
    }

    public final boolean isIntroducer() {
        return this.depth >= 1;
    }

    public final boolean canIntroduce(int otherDepth) {
        return this.depth > otherDepth;
    }

    public final boolean canIntroduce(@NotNull Trustworthiness other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.canIntroduce(other.depth);
    }

    @JvmStatic
    @NotNull
    public static final Builder fullyTrusted() {
        return Companion.fullyTrusted();
    }

    @JvmStatic
    @NotNull
    public static final Builder marginallyTrusted() {
        return Companion.marginallyTrusted();
    }

    @JvmStatic
    @NotNull
    public static final Builder untrusted() {
        return Companion.untrusted();
    }

    @JvmStatic
    private static final int capAmount(int amount) {
        return Trustworthiness.Companion.capAmount(amount);
    }

    @JvmStatic
    private static final int capDepth(int depth) {
        return Trustworthiness.Companion.capDepth(depth);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/pgpainless/algorithm/Trustworthiness$Builder;", "", "amount", "", "(I)V", "getAmount", "()I", "introducer", "Lorg/pgpainless/algorithm/Trustworthiness;", "metaIntroducer", "metaIntroducerOfDepth", "d", "pgpainless-core"})
    public static final class Builder {
        private final int amount;

        public Builder(int amount) {
            this.amount = amount;
        }

        public final int getAmount() {
            return this.amount;
        }

        @NotNull
        public final Trustworthiness introducer() {
            return new Trustworthiness(this.amount, 1);
        }

        @NotNull
        public final Trustworthiness metaIntroducer() {
            return new Trustworthiness(this.amount, 2);
        }

        @NotNull
        public final Trustworthiness metaIntroducerOfDepth(int d) {
            return new Trustworthiness(this.amount, d);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0003J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u000fH\u0007J\b\u0010\u0011\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002\u00a8\u0006\u0012"}, d2={"Lorg/pgpainless/algorithm/Trustworthiness$Companion;", "", "()V", "MARGINALLY_CONVINCED", "", "NOT_TRUSTED", "THRESHOLD_FULLY_CONVINCED", "validRange", "Lkotlin/ranges/IntRange;", "getValidRange$annotations", "capAmount", "amount", "capDepth", "depth", "fullyTrusted", "Lorg/pgpainless/algorithm/Trustworthiness$Builder;", "marginallyTrusted", "untrusted", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getValidRange$annotations() {
        }

        @JvmStatic
        @NotNull
        public final Builder fullyTrusted() {
            return new Builder(120);
        }

        @JvmStatic
        @NotNull
        public final Builder marginallyTrusted() {
            return new Builder(60);
        }

        @JvmStatic
        @NotNull
        public final Builder untrusted() {
            return new Builder(0);
        }

        @JvmStatic
        private final int capAmount(int amount) {
            IntRange intRange = validRange;
            int n = intRange.getFirst();
            if (!(amount <= intRange.getLast() ? n <= amount : false)) {
                throw new IllegalArgumentException("Trust amount MUST be a value between 0 and 255");
            }
            return amount;
        }

        @JvmStatic
        private final int capDepth(int depth) {
            IntRange intRange = validRange;
            int n = intRange.getFirst();
            if (!(depth <= intRange.getLast() ? n <= depth : false)) {
                throw new IllegalArgumentException("Trust depth MUST be a value between 0 and 255");
            }
            return depth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

