/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import openpgp.LongExtensionsKt;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.bouncycastle.extensions.PGPSignatureExtensionsKt;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0012\u0010\u0011\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0014\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"openPgpFingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "getOpenPgpFingerprint", "(Lorg/bouncycastle/openpgp/PGPKeyRing;)Lorg/pgpainless/key/OpenPgpFingerprint;", "getPublicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "fingerprint", "getPublicKeyFor", "onePassSignature", "Lorg/bouncycastle/openpgp/PGPOnePassSignature;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "hasPublicKey", "", "keyId", "", "matches", "subkeyIdentifier", "Lorg/pgpainless/key/SubkeyIdentifier;", "requirePublicKey", "toAsciiArmor", "", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nPGPKeyRingExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPKeyRingExtensions.kt\norg/pgpainless/bouncycastle/extensions/PGPKeyRingExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class PGPKeyRingExtensionsKt {
    public static final boolean matches(@NotNull PGPKeyRing $this$matches, @NotNull SubkeyIdentifier subkeyIdentifier) {
        Intrinsics.checkNotNullParameter($this$matches, "<this>");
        Intrinsics.checkNotNullParameter(subkeyIdentifier, "subkeyIdentifier");
        return $this$matches.getPublicKey().getKeyID() == subkeyIdentifier.getPrimaryKeyId() && $this$matches.getPublicKey(subkeyIdentifier.getSubkeyId()) != null;
    }

    public static final boolean hasPublicKey(@NotNull PGPKeyRing $this$hasPublicKey, long keyId) {
        Intrinsics.checkNotNullParameter($this$hasPublicKey, "<this>");
        return $this$hasPublicKey.getPublicKey(keyId) != null;
    }

    public static final boolean hasPublicKey(@NotNull PGPKeyRing $this$hasPublicKey, @NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter($this$hasPublicKey, "<this>");
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        return PGPKeyRingExtensionsKt.getPublicKey($this$hasPublicKey, fingerprint) != null;
    }

    @Nullable
    public static final PGPPublicKey getPublicKey(@NotNull PGPKeyRing $this$getPublicKey, @NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter($this$getPublicKey, "<this>");
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        return $this$getPublicKey.getPublicKey(fingerprint.getBytes());
    }

    @NotNull
    public static final PGPPublicKey requirePublicKey(@NotNull PGPKeyRing $this$requirePublicKey, long keyId) {
        Intrinsics.checkNotNullParameter($this$requirePublicKey, "<this>");
        PGPPublicKey pGPPublicKey = $this$requirePublicKey.getPublicKey(keyId);
        if (pGPPublicKey == null) {
            throw new NoSuchElementException("OpenPGP key does not contain key with id " + LongExtensionsKt.openPgpKeyId(keyId) + '.');
        }
        return pGPPublicKey;
    }

    @NotNull
    public static final PGPPublicKey requirePublicKey(@NotNull PGPKeyRing $this$requirePublicKey, @NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter($this$requirePublicKey, "<this>");
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        PGPPublicKey pGPPublicKey = PGPKeyRingExtensionsKt.getPublicKey($this$requirePublicKey, fingerprint);
        if (pGPPublicKey == null) {
            throw new NoSuchElementException("OpenPGP key does not contain key with fingerprint " + fingerprint + '.');
        }
        return pGPPublicKey;
    }

    @Nullable
    public static final PGPPublicKey getPublicKeyFor(@NotNull PGPKeyRing $this$getPublicKeyFor, @NotNull PGPSignature signature) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$getPublicKeyFor, "<this>");
                Intrinsics.checkNotNullParameter(signature, "signature");
                object = PGPSignatureExtensionsKt.getFingerprint(signature);
                if (object == null) break block2;
                OpenPgpFingerprint it = object;
                boolean bl = false;
                PGPPublicKey pGPPublicKey = PGPKeyRingExtensionsKt.getPublicKey($this$getPublicKeyFor, it);
                object = pGPPublicKey;
                if (pGPPublicKey != null) break block3;
            }
            object = $this$getPublicKeyFor.getPublicKey(signature.getKeyID());
        }
        return object;
    }

    @Nullable
    public static final PGPPublicKey getPublicKeyFor(@NotNull PGPKeyRing $this$getPublicKeyFor, @NotNull PGPOnePassSignature onePassSignature) {
        Intrinsics.checkNotNullParameter($this$getPublicKeyFor, "<this>");
        Intrinsics.checkNotNullParameter(onePassSignature, "onePassSignature");
        return $this$getPublicKeyFor.getPublicKey(onePassSignature.getKeyID());
    }

    @NotNull
    public static final OpenPgpFingerprint getOpenPgpFingerprint(@NotNull PGPKeyRing $this$openPgpFingerprint) {
        Intrinsics.checkNotNullParameter($this$openPgpFingerprint, "<this>");
        return OpenPgpFingerprint.Companion.of($this$openPgpFingerprint);
    }

    @NotNull
    public static final String toAsciiArmor(@NotNull PGPKeyRing $this$toAsciiArmor) {
        Intrinsics.checkNotNullParameter($this$toAsciiArmor, "<this>");
        return PGPainless.Companion.asciiArmor($this$toAsciiArmor);
    }
}

