/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import openpgp.LongExtensionsKt;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.bouncycastle.extensions.PGPSignatureExtensionsKt;
import org.pgpainless.key.OpenPgpFingerprint;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u0014\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "getCertificate", "(Lorg/bouncycastle/openpgp/PGPSecretKeyRing;)Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getSecretKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "getSecretKeyFor", "onePassSignature", "Lorg/bouncycastle/openpgp/PGPOnePassSignature;", "pkesk", "Lorg/bouncycastle/openpgp/PGPPublicKeyEncryptedData;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "hasSecretKey", "", "keyId", "", "requireSecretKey", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nPGPSecretKeyRingExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPSecretKeyRingExtensions.kt\norg/pgpainless/bouncycastle/extensions/PGPSecretKeyRingExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class PGPSecretKeyRingExtensionsKt {
    @NotNull
    public static final PGPPublicKeyRing getCertificate(@NotNull PGPSecretKeyRing $this$certificate) {
        Intrinsics.checkNotNullParameter($this$certificate, "<this>");
        Iterator<PGPPublicKey> iterator2 = $this$certificate.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue(iterator2, "this.publicKeys");
        return new PGPPublicKeyRing(SequencesKt.toList(SequencesKt.asSequence(iterator2)));
    }

    public static final boolean hasSecretKey(@NotNull PGPSecretKeyRing $this$hasSecretKey, long keyId) {
        Intrinsics.checkNotNullParameter($this$hasSecretKey, "<this>");
        return $this$hasSecretKey.getSecretKey(keyId) != null;
    }

    public static final boolean hasSecretKey(@NotNull PGPSecretKeyRing $this$hasSecretKey, @NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter($this$hasSecretKey, "<this>");
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        return PGPSecretKeyRingExtensionsKt.getSecretKey($this$hasSecretKey, fingerprint) != null;
    }

    @Nullable
    public static final PGPSecretKey getSecretKey(@NotNull PGPSecretKeyRing $this$getSecretKey, @NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter($this$getSecretKey, "<this>");
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        return $this$getSecretKey.getSecretKey(fingerprint.getBytes());
    }

    @NotNull
    public static final PGPSecretKey requireSecretKey(@NotNull PGPSecretKeyRing $this$requireSecretKey, long keyId) {
        Intrinsics.checkNotNullParameter($this$requireSecretKey, "<this>");
        PGPSecretKey pGPSecretKey = $this$requireSecretKey.getSecretKey(keyId);
        if (pGPSecretKey == null) {
            throw new NoSuchElementException("OpenPGP key does not contain key with id " + LongExtensionsKt.openPgpKeyId(keyId) + '.');
        }
        return pGPSecretKey;
    }

    @NotNull
    public static final PGPSecretKey requireSecretKey(@NotNull PGPSecretKeyRing $this$requireSecretKey, @NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter($this$requireSecretKey, "<this>");
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        PGPSecretKey pGPSecretKey = PGPSecretKeyRingExtensionsKt.getSecretKey($this$requireSecretKey, fingerprint);
        if (pGPSecretKey == null) {
            throw new NoSuchElementException("OpenPGP key does not contain key with fingerprint " + fingerprint + '.');
        }
        return pGPSecretKey;
    }

    @Nullable
    public static final PGPSecretKey getSecretKeyFor(@NotNull PGPSecretKeyRing $this$getSecretKeyFor, @NotNull PGPSignature signature) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$getSecretKeyFor, "<this>");
                Intrinsics.checkNotNullParameter(signature, "signature");
                object = PGPSignatureExtensionsKt.getFingerprint(signature);
                if (object == null) break block2;
                OpenPgpFingerprint it = object;
                boolean bl = false;
                PGPSecretKey pGPSecretKey = PGPSecretKeyRingExtensionsKt.getSecretKey($this$getSecretKeyFor, it);
                object = pGPSecretKey;
                if (pGPSecretKey != null) break block3;
            }
            object = $this$getSecretKeyFor.getSecretKey(signature.getKeyID());
        }
        return object;
    }

    @Nullable
    public static final PGPSecretKey getSecretKeyFor(@NotNull PGPSecretKeyRing $this$getSecretKeyFor, @NotNull PGPOnePassSignature onePassSignature) {
        Intrinsics.checkNotNullParameter($this$getSecretKeyFor, "<this>");
        Intrinsics.checkNotNullParameter(onePassSignature, "onePassSignature");
        return $this$getSecretKeyFor.getSecretKey(onePassSignature.getKeyID());
    }

    @Nullable
    public static final PGPSecretKey getSecretKeyFor(@NotNull PGPSecretKeyRing $this$getSecretKeyFor, @NotNull PGPPublicKeyEncryptedData pkesk) {
        Intrinsics.checkNotNullParameter($this$getSecretKeyFor, "<this>");
        Intrinsics.checkNotNullParameter(pkesk, "pkesk");
        if (pkesk.getVersion() != 3) {
            throw new NotImplementedError("Version 6 PKESKs are not yet supported.");
        }
        return $this$getSecretKeyFor.getSecretKey(pkesk.getKeyID());
    }
}

