/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.key.SubkeyIdentifier;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0010J-\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00122\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010!2\b\u0010\u001f\u001a\u0004\u0018\u00010\"H\u0016J\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010#2\b\u0010\u001f\u001a\u0004\u0018\u00010\"H\u0016J\u001f\u0010$\u001a\u0004\u0018\u00010\n2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0012H\u0002\u00a2\u0006\u0002\u0010%J-\u0010&\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00122\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010'\u001a\u00020\t2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0012H\u0002\u00a2\u0006\u0002\u0010(R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/pgpainless/decryption_verification/CachingBcPublicKeyDataDecryptorFactory;", "Lorg/pgpainless/decryption_verification/CustomPublicKeyDataDecryptorFactory;", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "subkeyIdentifier", "Lorg/pgpainless/key/SubkeyIdentifier;", "(Lorg/bouncycastle/openpgp/PGPPrivateKey;Lorg/pgpainless/key/SubkeyIdentifier;)V", "cachedSessions", "", "", "", "decryptorFactory", "Lorg/bouncycastle/openpgp/operator/bc/BcPublicKeyDataDecryptorFactory;", "getSubkeyIdentifier", "()Lorg/pgpainless/key/SubkeyIdentifier;", "cacheSessionKeyData", "", "secKeyData", "", "sessionKey", "([[B[B)V", "clear", "costlyRecoverSessionData", "keyAlgorithm", "", "pkeskVersion", "(I[[BI)[B", "createDataDecryptor", "Lorg/bouncycastle/openpgp/operator/PGPDataDecryptor;", "p0", "", "p1", "p2", "Lorg/bouncycastle/bcpg/AEADEncDataPacket;", "Lorg/bouncycastle/openpgp/PGPSessionKey;", "Lorg/bouncycastle/bcpg/SymmetricEncIntegrityPacket;", "lookupSessionKeyData", "([[B)[B", "recoverSessionData", "toKey", "([[B)Ljava/lang/String;", "pgpainless-core"})
public final class CachingBcPublicKeyDataDecryptorFactory
extends CustomPublicKeyDataDecryptorFactory {
    @NotNull
    private final SubkeyIdentifier subkeyIdentifier;
    @NotNull
    private final BcPublicKeyDataDecryptorFactory decryptorFactory;
    @NotNull
    private final Map<String, byte[]> cachedSessions;

    public CachingBcPublicKeyDataDecryptorFactory(@NotNull PGPPrivateKey privateKey, @NotNull SubkeyIdentifier subkeyIdentifier) {
        Intrinsics.checkNotNullParameter(privateKey, "privateKey");
        Intrinsics.checkNotNullParameter(subkeyIdentifier, "subkeyIdentifier");
        this.subkeyIdentifier = subkeyIdentifier;
        this.decryptorFactory = new BcPublicKeyDataDecryptorFactory(privateKey);
        this.cachedSessions = new LinkedHashMap();
    }

    @Override
    @NotNull
    public SubkeyIdentifier getSubkeyIdentifier() {
        return this.subkeyIdentifier;
    }

    @Override
    @NotNull
    public PGPDataDecryptor createDataDecryptor(boolean p0, int p1, @Nullable byte[] p2) {
        PGPDataDecryptor pGPDataDecryptor = this.decryptorFactory.createDataDecryptor(p0, p1, p2);
        Intrinsics.checkNotNullExpressionValue(pGPDataDecryptor, "decryptorFactory.createDataDecryptor(p0, p1, p2)");
        return pGPDataDecryptor;
    }

    @Override
    @NotNull
    public PGPDataDecryptor createDataDecryptor(@Nullable AEADEncDataPacket p0, @Nullable PGPSessionKey p1) {
        PGPDataDecryptor pGPDataDecryptor = this.decryptorFactory.createDataDecryptor(p0, p1);
        Intrinsics.checkNotNullExpressionValue(pGPDataDecryptor, "decryptorFactory.createDataDecryptor(p0, p1)");
        return pGPDataDecryptor;
    }

    @Override
    @NotNull
    public PGPDataDecryptor createDataDecryptor(@Nullable SymmetricEncIntegrityPacket p0, @Nullable PGPSessionKey p1) {
        PGPDataDecryptor pGPDataDecryptor = this.decryptorFactory.createDataDecryptor(p0, p1);
        Intrinsics.checkNotNullExpressionValue(pGPDataDecryptor, "decryptorFactory.createDataDecryptor(p0, p1)");
        return pGPDataDecryptor;
    }

    @Override
    @NotNull
    public byte[] recoverSessionData(int keyAlgorithm, @NotNull byte[][] secKeyData, int pkeskVersion) {
        Intrinsics.checkNotNullParameter(secKeyData, "secKeyData");
        byte[] byArray = this.lookupSessionKeyData(secKeyData);
        if (byArray == null) {
            byte[] byArray2;
            byte[] it = byArray2 = this.costlyRecoverSessionData(keyAlgorithm, secKeyData, pkeskVersion);
            boolean bl = false;
            this.cacheSessionKeyData(secKeyData, it);
            byArray = byArray2;
        }
        return byArray;
    }

    private final byte[] lookupSessionKeyData(byte[][] secKeyData) {
        byte[] byArray = this.cachedSessions.get(this.toKey(secKeyData));
        return (byte[])(byArray != null ? (byte[])byArray.clone() : null);
    }

    private final byte[] costlyRecoverSessionData(int keyAlgorithm, byte[][] secKeyData, int pkeskVersion) {
        byte[] byArray = this.decryptorFactory.recoverSessionData(keyAlgorithm, secKeyData, pkeskVersion);
        Intrinsics.checkNotNullExpressionValue(byArray, "decryptorFactory.recover\u2026secKeyData, pkeskVersion)");
        return byArray;
    }

    private final void cacheSessionKeyData(byte[][] secKeyData, byte[] sessionKey) {
        this.cachedSessions.put(this.toKey(secKeyData), (byte[])sessionKey.clone());
    }

    private final String toKey(byte[][] secKeyData) {
        String string = Base64.toBase64String(secKeyData[0]);
        Intrinsics.checkNotNullExpressionValue(string, "toBase64String(secKeyData[0])");
        return string;
    }

    public final void clear() {
        this.cachedSessions.clear();
    }
}

