/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.cleartext_signatures;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.exception.WrongConsumingMethodException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.util.ArmoredInputStreamFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/decryption_verification/cleartext_signatures/ClearsignedMessageUtil;", "", "()V", "Companion", "pgpainless-core"})
public final class ClearsignedMessageUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final PGPSignatureList detachSignaturesFromInbandClearsignedMessage(@NotNull InputStream clearsignedInputStream, @NotNull OutputStream messageOutputStream) throws WrongConsumingMethodException, IOException {
        return Companion.detachSignaturesFromInbandClearsignedMessage(clearsignedInputStream, messageOutputStream);
    }

    @JvmStatic
    private static final int readInputLine(ByteArrayOutputStream bOut, InputStream fIn) {
        return ClearsignedMessageUtil.Companion.readInputLine(bOut, fIn);
    }

    @JvmStatic
    private static final int readInputLine(ByteArrayOutputStream bOut, int lookAhead, InputStream fIn) {
        return ClearsignedMessageUtil.Companion.readInputLine(bOut, lookAhead, fIn);
    }

    @JvmStatic
    private static final int readPassedEOL(ByteArrayOutputStream bOut, int lastCh, InputStream fIn) {
        return ClearsignedMessageUtil.Companion.readPassedEOL(bOut, lastCh, fIn);
    }

    @JvmStatic
    private static final byte[] getLineSeparator() {
        return ClearsignedMessageUtil.Companion.getLineSeparator();
    }

    @JvmStatic
    private static final int getLengthWithoutSeparatorOrTrailingWhitespace(byte[] line) {
        return ClearsignedMessageUtil.Companion.getLengthWithoutSeparatorOrTrailingWhitespace(line);
    }

    @JvmStatic
    private static final boolean isLineEnding(byte b) {
        return ClearsignedMessageUtil.Companion.isLineEnding(b);
    }

    @JvmStatic
    private static final boolean isWhiteSpace(byte b) {
        return ClearsignedMessageUtil.Companion.isWhiteSpace(b);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\b\u0010\r\u001a\u00020\fH\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0003J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0006H\u0003J \u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0006H\u0003\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/decryption_verification/cleartext_signatures/ClearsignedMessageUtil$Companion;", "", "()V", "detachSignaturesFromInbandClearsignedMessage", "Lorg/bouncycastle/openpgp/PGPSignatureList;", "clearsignedInputStream", "Ljava/io/InputStream;", "messageOutputStream", "Ljava/io/OutputStream;", "getLengthWithoutSeparatorOrTrailingWhitespace", "", "line", "", "getLineSeparator", "isLineEnding", "", "b", "", "isWhiteSpace", "readInputLine", "bOut", "Ljava/io/ByteArrayOutputStream;", "fIn", "lookAhead", "readPassedEOL", "lastCh", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nClearsignedMessageUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClearsignedMessageUtil.kt\norg/pgpainless/decryption_verification/cleartext_signatures/ClearsignedMessageUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final PGPSignatureList detachSignaturesFromInbandClearsignedMessage(@NotNull InputStream clearsignedInputStream, @NotNull OutputStream messageOutputStream) throws WrongConsumingMethodException, IOException {
            ArmoredInputStream input;
            Intrinsics.checkNotNullParameter(clearsignedInputStream, "clearsignedInputStream");
            Intrinsics.checkNotNullParameter(messageOutputStream, "messageOutputStream");
            ArmoredInputStream armoredInputStream = input = clearsignedInputStream instanceof ArmoredInputStream ? (ArmoredInputStream)clearsignedInputStream : ArmoredInputStreamFactory.Companion.get$default(ArmoredInputStreamFactory.Companion, clearsignedInputStream, null, 2, null);
            if (!input.isClearText()) {
                throw new WrongConsumingMethodException("Message isn't using the Cleartext Signature Framework.");
            }
            Closeable closeable = new BufferedOutputStream(messageOutputStream);
            Throwable throwable = null;
            try {
                BufferedOutputStream output = (BufferedOutputStream)closeable;
                boolean bl = false;
                ByteArrayOutputStream lineOut = new ByteArrayOutputStream();
                int lookAhead = Companion.readInputLine(lineOut, input);
                byte[] lineSep = Companion.getLineSeparator();
                if (lookAhead != -1 && input.isClearText()) {
                    byte[] line = lineOut.toByteArray();
                    Intrinsics.checkNotNullExpressionValue(line, "line");
                    output.write(line, 0, Companion.getLengthWithoutSeparatorOrTrailingWhitespace(line));
                    while (lookAhead != -1 && input.isClearText()) {
                        lookAhead = Companion.readInputLine(lineOut, lookAhead, input);
                        line = lineOut.toByteArray();
                        output.write(lineSep);
                        Intrinsics.checkNotNullExpressionValue(line, "line");
                        output.write(line, 0, Companion.getLengthWithoutSeparatorOrTrailingWhitespace(line));
                    }
                } else if (lookAhead != -1) {
                    byte[] line = lineOut.toByteArray();
                    Intrinsics.checkNotNullExpressionValue(line, "line");
                    output.write(line, 0, Companion.getLengthWithoutSeparatorOrTrailingWhitespace(line));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            PGPObjectFactory objectFactory = ImplementationFactory.Companion.getInstance().getPGPObjectFactory(input);
            Object object = objectFactory.nextObject();
            if (object == null) {
                object = new PGPSignatureList(new PGPSignature[0]);
            }
            Object next = object;
            return (PGPSignatureList)next;
        }

        @JvmStatic
        private final int readInputLine(ByteArrayOutputStream bOut, InputStream fIn) {
            int lookAhead;
            block1: {
                bOut.reset();
                lookAhead = -1;
                int ch = 0;
                do {
                    int n;
                    int it = n = fIn.read();
                    boolean bl = false;
                    ch = it;
                    if (n < 0) break block1;
                    bOut.write(ch);
                } while (ch != 13 && ch != 10);
                lookAhead = this.readPassedEOL(bOut, ch, fIn);
            }
            return lookAhead;
        }

        @JvmStatic
        private final int readInputLine(ByteArrayOutputStream bOut, int lookAhead, InputStream fIn) {
            int n;
            int mLookAhead = lookAhead;
            bOut.reset();
            int ch = 0;
            ch = mLookAhead;
            do {
                bOut.write(ch);
                if (ch == 13 || ch == 10) {
                    mLookAhead = this.readPassedEOL(bOut, ch, fIn);
                    break;
                }
                int it = n = fIn.read();
                boolean bl = false;
                ch = it;
            } while (n >= 0);
            if (ch < 0) {
                mLookAhead = -1;
            }
            return mLookAhead;
        }

        @JvmStatic
        private final int readPassedEOL(ByteArrayOutputStream bOut, int lastCh, InputStream fIn) {
            int lookAhead = fIn.read();
            if (lastCh == 13 && lookAhead == 10) {
                bOut.write(lookAhead);
                lookAhead = fIn.read();
            }
            return lookAhead;
        }

        @JvmStatic
        private final byte[] getLineSeparator() {
            String nl = Strings.lineSeparator();
            byte[] nlBytes = new byte[nl.length()];
            int n = nlBytes.length;
            for (int i = 0; i < n; ++i) {
                nlBytes[i] = (byte)nl.charAt(i);
            }
            return nlBytes;
        }

        @JvmStatic
        private final int getLengthWithoutSeparatorOrTrailingWhitespace(byte[] line) {
            int end;
            for (end = line.length - 1; end >= 0 && this.isWhiteSpace(line[end]); --end) {
            }
            return end + 1;
        }

        @JvmStatic
        private final boolean isLineEnding(byte b) {
            return b == 13 || b == 10;
        }

        @JvmStatic
        private final boolean isWhiteSpace(byte b) {
            return this.isLineEnding(b) || b == 9 || b == 32;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

